/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.core.domains.models.X_AD_Column;
import org.adempiere.core.domains.models.X_C_ElementValue;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.GenericPO;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.DocWorkflowMgr;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Lookup;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientShare;
import org.compiere.model.MColumn;
import org.compiere.model.MElement;
import org.compiere.model.MLanguage;
import org.compiere.model.MRefList;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.M_Element;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Null;
import org.compiere.model.POInfo;
import org.compiere.model.POInfoColumn;
import org.compiere.model.PO_LOB;
import org.compiere.model.PO_Record;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class PO
implements Serializable,
Comparator,
Evaluatee,
Cloneable {
    private static final long serialVersionUID = -4708137979682082002L;
    private static final String USE_TIMEOUT_FOR_UPDATE = "org.adempiere.po.useTimeoutForUpdate";
    private static final int QUERY_TIME_OUT = 10;
    private static DocWorkflowMgr s_docWFMgr = null;
    protected static final String ENTITYTYPE_UserMaintained = "U";
    protected static final String ENTITYTYPE_Dictionary = "D";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PO.class);
    protected Properties p_ctx;
    protected volatile POInfo p_info = null;
    private Object[] m_oldValues = null;
    private Object[] m_newValues = null;
    private Object[] m_IDs = new Object[]{I_ZERO};
    private String[] m_KeyColumns = null;
    private boolean m_createNew = false;
    private MAttachment m_attachment = null;
    private int m_idOld = 0;
    private HashMap<String, String> m_custom = null;
    protected static final Integer I_ZERO = 0;
    private ArrayList<String> s_acctColumns = null;
    private boolean m_isReplication = false;
    private boolean isDirectLoad = false;
    public static final int ACCESSLEVEL_SYSTEM = 4;
    public static final int ACCESSLEVEL_CLIENT = 2;
    public static final int ACCESSLEVEL_ORG = 1;
    public static final int ACCESSLEVEL_ALL = 7;
    public static final int ACCESSLEVEL_SYSTEMCLIENT = 6;
    public static final int ACCESSLEVEL_CLIENTORG = 3;
    private String m_trxName = null;
    private ArrayList<PO_LOB> m_lobInfo = null;
    protected static final String XML_ATTRIBUTE_AD_Table_ID = "AD_Table_ID";
    protected static final String XML_ATTRIBUTE_Record_ID = "Record_ID";
    private Doc m_doc;

    public static List<?> getInstances(Integer tableId, List<Integer> recordIds, String trxName) throws AdempiereException {
        if (tableId <= 0) {
            throw new AdempiereException("@AD_Table_ID@  @NotFound@");
        }
        if (recordIds == null || recordIds.size() <= 0) {
            throw new AdempiereException("@NoRecordID@");
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (int)tableId);
        return recordIds.stream().filter(recordId -> recordId > 0).map(recordId -> table.getPO(recordId.intValue(), trxName)).collect(Collectors.toList());
    }

    public static void setDocWorkflowMgr(DocWorkflowMgr docWFMgr) {
        s_docWFMgr = docWFMgr;
        s_log.config(s_docWFMgr.toString());
    }

    public PO(Properties ctx) {
        this(ctx, 0, null, null);
    }

    public PO(Properties ctx, int ID, String trxName) {
        this(ctx, ID, trxName, null);
    }

    public PO(Properties ctx, ResultSet rs, String trxName) {
        this(ctx, 0, trxName, rs);
    }

    public PO(Properties ctx, int ID, String trxName, ResultSet rs) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Context");
        }
        this.p_ctx = ctx;
        this.m_trxName = trxName;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + this.p_info);
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        if (rs != null) {
            this.load(rs);
        } else {
            this.load(ID, trxName);
        }
    }

    public PO(Properties ctx, PO source, int AD_Client_ID, int AD_Org_ID) {
        this(ctx, 0, null, null);
        if (source != null) {
            PO.copyValues((PO)source, (PO)this);
        }
        this.setAD_Client_ID(AD_Client_ID);
        this.setAD_Org_ID(AD_Org_ID);
    }

    public boolean isDirectLoad() {
        return this.isDirectLoad;
    }

    public void setIsDirectLoad(boolean directLoad) {
        this.isDirectLoad = directLoad;
    }

    protected abstract POInfo initPO(Properties var1);

    protected abstract int get_AccessLevel();

    public String toString() {
        StringBuffer sb = new StringBuffer("PO[").append(this.get_WhereClause(true)).append(", UUID=").append(this.get_UUID()).append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object cmp) {
        if (this == cmp) {
            return true;
        }
        if (cmp == null) {
            return false;
        }
        if (!(cmp instanceof PO)) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            if (((PO)cmp).get_ID() == 0 && this.get_ID() == 0) {
                return super.equals(cmp);
            }
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return super.equals(cmp);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!(o1 instanceof PO)) {
            throw new ClassCastException("Not PO -1- " + o1);
        }
        if (!(o2 instanceof PO)) {
            throw new ClassCastException("Not PO -2- " + o2);
        }
        if (o1.getClass().equals(o2.getClass())) {
            int index = this.get_ColumnIndex("DocumentNo");
            if (index == -1) {
                index = this.get_ColumnIndex("Value");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Name");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Description");
            }
            if (index != -1) {
                PO po1 = (PO)o1;
                Object comp1 = po1.get_Value(index);
                PO po2 = (PO)o2;
                Object comp2 = po2.get_Value(index);
                if (comp1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return comp1.toString().compareTo(comp2.toString());
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    public String get_TableName() {
        return this.p_info.getTableName();
    }

    public String[] get_KeyColumns() {
        return this.m_KeyColumns;
    }

    public int get_Table_ID() {
        return this.p_info.getAD_Table_ID();
    }

    public int get_ID() {
        Object oo = this.m_IDs[0];
        if (oo != null && oo instanceof Integer) {
            return (Integer)oo;
        }
        return 0;
    }

    public String get_UUID() {
        return this.get_ValueAsString("UUID");
    }

    public int get_IDOld() {
        return this.m_idOld;
    }

    public Properties getCtx() {
        return this.p_ctx;
    }

    public CLogger get_Logger() {
        return this.log;
    }

    public final Object get_Value(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        if (this.m_newValues[index] != null) {
            if (this.m_newValues[index].equals(Null.NULL)) {
                return null;
            }
            return this.m_newValues[index];
        }
        return this.m_oldValues[index];
    }

    public int get_ValueAsInt(int index) {
        Object value = this.get_Value(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(this.p_info.getColumnName(index) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final Object get_Value(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            Trace.printStack();
            return null;
        }
        return this.get_Value(index);
    }

    protected final Object get_ValueE(String columnName) {
        return this.get_Value(columnName);
    }

    public String get_ValueAsString(String variableName) {
        Object value = this.get_Value(variableName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public final Object get_ValueOfColumn(int AD_Column_ID) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.WARNING, "Not found - AD_Column_ID=" + AD_Column_ID);
            return null;
        }
        return this.get_Value(index);
    }

    public final Object get_ValueOld(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        return this.m_oldValues[index];
    }

    public final Object get_ValueOld(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueOld(index);
    }

    public int get_ValueOldAsInt(String columnName) {
        Object value = this.get_ValueOld(columnName);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(columnName + " - " + ex.getMessage());
            return 0;
        }
    }

    public final boolean is_ValueChanged(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        if (this.m_newValues[index] == null || this.m_newValues[index].equals(Null.NULL) && this.m_oldValues[index] == null) {
            return false;
        }
        return !this.m_newValues[index].equals(this.m_oldValues[index]);
    }

    public final boolean is_ValueChanged(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return false;
        }
        return this.is_ValueChanged(index);
    }

    public final Object get_ValueDifference(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        Object nValue = this.m_newValues[index];
        if (nValue == null || nValue == Null.NULL) {
            return null;
        }
        Object oValue = this.m_oldValues[index];
        if (oValue == null || oValue == Null.NULL) {
            return nValue;
        }
        if (nValue instanceof BigDecimal) {
            BigDecimal obd = (BigDecimal)oValue;
            return ((BigDecimal)nValue).subtract(obd);
        }
        if (nValue instanceof Integer) {
            int result = (Integer)nValue;
            return result -= ((Integer)oValue).intValue();
        }
        this.log.warning("Invalid type - New=" + nValue);
        return null;
    }

    public final Object get_ValueDifference(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueDifference(index);
    }

    protected final boolean set_Value(String ColumnName, Object value) {
        Class clazz;
        int index;
        if (value instanceof String && ColumnName.equals("WhereClause") && value.toString().toUpperCase().indexOf("=NULL") != -1) {
            this.log.warning("Invalid Null Value - " + ColumnName + "=" + value);
        }
        if ((index = this.get_ColumnIndex(ColumnName)) < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (ColumnName.endsWith("_ID") && value instanceof String && Integer.class == (clazz = this.p_info.getColumnClass(this.p_info.getColumnIndex(ColumnName)))) {
            this.log.severe("Invalid Data Type for " + ColumnName + "=" + value);
            value = Integer.parseInt((String)value);
        }
        return this.set_Value(index, value);
    }

    protected final boolean set_ValueE(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value);
    }

    protected final boolean set_Value(int index, Object value) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        if (this.p_info.isVirtualColumn(index)) {
            this.log.log(Level.WARNING, "Virtual Column" + colInfo);
            return false;
        }
        if (!this.p_info.isColumnUpdateable(index) && !this.is_new()) {
            colInfo = colInfo + " - NewValue=" + value + " - OldValue=" + this.get_Value(index);
            this.log.log(Level.WARNING, "Column not updateable" + colInfo);
            return false;
        }
        if (value == null) {
            if (this.p_info.isColumnMandatory(index)) {
                throw new IllegalArgumentException(ColumnName + " is mandatory.");
            }
            this.m_newValues[index] = Null.NULL;
            this.log.finer(ColumnName + " = null");
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = ((BigDecimal)value).intValue();
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = "Y".equals(value);
            } else if (value.getClass() == Integer.class && this.p_info.getColumnClass(index) == String.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == String.class && this.p_info.getColumnClass(index) == Integer.class) {
                try {
                    this.m_newValues[index] = Integer.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    this.log.log(Level.SEVERE, ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                    return false;
                }
            } else {
                this.log.log(Level.SEVERE, ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                return false;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.log(Level.WARNING, ColumnName + "=" + value + " - " + error);
                return false;
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
            if (this.p_info.getColumn((int)index).DisplayType == 17 && this.p_info.getColumn((int)index).AD_Reference_Value_ID > 0 && value instanceof String && MRefList.get((Properties)this.getCtx(), (int)this.p_info.getColumn((int)index).AD_Reference_Value_ID, (String)((String)value), (String)this.get_TrxName()) == null) {
                StringBuffer validValues = new StringBuffer();
                for (ValueNamePair vp : MRefList.getList((Properties)this.getCtx(), (int)this.p_info.getColumn((int)index).AD_Reference_Value_ID, (boolean)false)) {
                    validValues.append(" - ").append(vp.getValue());
                }
                throw new IllegalArgumentException(ColumnName + " Invalid value - " + value + " - Reference_ID=" + this.p_info.getColumn((int)index).AD_Reference_Value_ID + validValues.toString());
            }
            if (CLogMgt.isLevelFinest()) {
                this.log.finest(ColumnName + " = " + this.m_newValues[index] + " (OldValue=" + this.m_oldValues[index] + ")");
            }
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    public void setProcessedOn(String ColumnName, Object value, Object oldValue) {
        if ("Processed".equals(ColumnName) && value instanceof Boolean && ((Boolean)value).booleanValue() && (oldValue == null || oldValue instanceof Boolean && !((Boolean)oldValue).booleanValue()) && this.get_ColumnIndex("ProcessedOn") > 0) {
            Timestamp ts = DB.getSQLValueTS(null, (String)"SELECT CURRENT_TIMESTAMP FROM DUAL", (Object[])new Object[0]);
            long mili = ts.getTime();
            int nano = ts.getNanos();
            double doublets = Double.parseDouble(Long.toString(mili) + "." + Integer.toString(nano));
            BigDecimal bdtimestamp = new BigDecimal(doublets);
            this.set_Value("ProcessedOn", (Object)bdtimestamp);
        }
    }

    protected final boolean set_ValueNoCheck(String ColumnName, Object value) {
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (value == null) {
            this.m_newValues[index] = Null.NULL;
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = ((BigDecimal)value).intValue();
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = "Y".equals(value);
            } else if (this.p_info.getColumnClass(index) == Integer.class && value.getClass() == String.class) {
                try {
                    int intValue = Integer.parseInt((String)value);
                    this.m_newValues[index] = intValue;
                }
                catch (Exception e) {
                    this.log.warning(ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                    this.m_newValues[index] = null;
                }
            } else {
                this.log.warning(ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                this.m_newValues[index] = value;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.warning(ColumnName + "=" + value + " - " + error);
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
        }
        this.log.finest(ColumnName + " = " + this.m_newValues[index] + " (" + (this.m_newValues[index] == null ? "-" : this.m_newValues[index].getClass().getName()) + ")");
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    protected final boolean set_ValueNoCheckE(String ColumnName, Object value) {
        return this.set_ValueNoCheck(ColumnName, value);
    }

    public final void set_ValueOfColumn(String columnName, Object value) {
        this.set_ValueOfColumnReturningBoolean(columnName, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(String columnName, Object value) {
        int AD_Column_ID = this.p_info.getAD_Column_ID(columnName);
        if (AD_Column_ID > 0) {
            return this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
        }
        return false;
    }

    public final void set_ValueOfColumn(int AD_Column_ID, Object value) {
        this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(int AD_Column_ID, Object value) {
        String ColumnName;
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Not found - AD_Column_ID=" + AD_Column_ID);
        }
        if ((ColumnName = this.p_info.getColumnName(index)).equals("IsApproved")) {
            return this.set_ValueNoCheck(ColumnName, value);
        }
        return this.set_Value(index, value);
    }

    public final void set_CustomColumn(String columnName, Object value) {
        this.set_CustomColumnReturningBoolean(columnName, value);
    }

    public final boolean set_CustomColumnReturningBoolean(String columnName, Object value) {
        int poIndex = this.get_ColumnIndex(columnName);
        if (poIndex >= 0) {
            return this.set_Value(columnName, value);
        }
        if (this.m_custom == null) {
            this.m_custom = new HashMap();
        }
        String valueString = "NULL";
        if (value != null) {
            valueString = value instanceof Number ? value.toString() : (value instanceof Boolean ? ((Boolean)value != false ? "'Y'" : "'N'") : (value instanceof Timestamp ? DB.TO_DATE((Timestamp)((Timestamp)value), (boolean)false) : DB.TO_STRING((String)value.toString())));
        }
        this.log.log(Level.INFO, columnName + "=" + valueString);
        this.m_custom.put(columnName, valueString);
        return true;
    }

    private void set_Keys(String ColumnName, Object value) {
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (!ColumnName.equals(this.m_KeyColumns[i])) continue;
            this.m_IDs[i] = value;
        }
    }

    public int get_ColumnCount() {
        return this.p_info.getColumnCount();
    }

    public String get_ColumnName(int index) {
        return this.p_info.getColumnName(index);
    }

    protected String get_ColumnLabel(int index) {
        return this.p_info.getColumnLabel(index);
    }

    protected String get_ColumnDescription(int index) {
        return this.p_info.getColumnDescription(index);
    }

    protected boolean isColumnMandatory(int index) {
        return this.p_info.isColumnMandatory(index);
    }

    protected boolean isColumnUpdateable(int index) {
        return this.p_info.isColumnUpdateable(index);
    }

    protected void set_ColumnUpdateable(int index, boolean updateable) {
        this.p_info.setColumnUpdateable(index, updateable);
    }

    protected void setUpdateable(boolean updateable) {
        this.p_info.setUpdateable(updateable);
    }

    protected int get_ColumnDisplayType(int index) {
        return this.p_info.getColumnDisplayType(index);
    }

    protected Lookup get_ColumnLookup(int index) {
        return this.p_info.getColumnLookup(index);
    }

    public final int get_ColumnIndex(String columnName) {
        return this.p_info.getColumnIndex(columnName);
    }

    protected String get_DisplayValue(String columnName, boolean currentValue) {
        Lookup lookup;
        Object value;
        Object object = value = currentValue ? this.get_Value(columnName) : this.get_ValueOld(columnName);
        if (value == null) {
            return "./.";
        }
        String retValue = value.toString();
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int displayType = this.get_ColumnDisplayType(index);
        if (DisplayType.isText((int)displayType) || 20 == displayType) {
            return retValue;
        }
        if (DisplayType.isDate((int)displayType)) {
            SimpleDateFormat format = DisplayType.getDateFormat((int)displayType);
            return format.format(value);
        }
        if (DisplayType.isNumeric((int)displayType)) {
            DecimalFormat format = DisplayType.getNumberFormat((int)displayType);
            format.format(value);
        }
        if ((lookup = this.get_ColumnLookup(index)) != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    public String getDisplayValue() {
        StringBuffer identifier = new StringBuffer();
        MTable table = MTable.get((Properties)this.getCtx(), (int)this.get_Table_ID());
        table.getColumnsAsList().stream().sorted(Comparator.comparing(X_AD_Column::getSeqNo)).filter(entry -> entry.isIdentifier() && this.get_Value(entry.getColumnName()) != null && !Util.isEmpty((String)this.get_DisplayValue(entry.getColumnName(), true))).forEach(column -> {
            String displayColumn = this.get_DisplayValue(column.getColumnName(), true);
            if (identifier.length() > 0) {
                identifier.append("_");
            }
            identifier.append(displayColumn);
        });
        if (identifier.length() == 0) {
            identifier.append("<").append(this.get_ID()).append(">");
        }
        return identifier.toString();
    }

    protected static void copyValues(PO from, PO to, int AD_Client_ID, int AD_Org_ID) {
        PO.copyValues((PO)from, (PO)to, (boolean)true);
        to.setAD_Client_ID(AD_Client_ID);
        to.setAD_Org_ID(AD_Org_ID);
    }

    public static void copyValues(PO from, PO to) {
        PO.copyValues((PO)from, (PO)to, (boolean)true);
    }

    public static void copyValues(PO from, PO to, boolean force) {
        s_log.fine("From ID=" + from.get_ID() + " - To ID=" + to.get_ID());
        if (from.getClass() != to.getClass()) {
            block0: for (int i1 = 0; i1 < from.m_oldValues.length; ++i1) {
                String colName;
                if (from.p_info.isVirtualColumn(i1) || from.p_info.isKey(i1) || !from.p_info.isAllowCopy(i1) && !force || M_Element.isReservedColumnName((String)(colName = from.p_info.getColumnName(i1)))) continue;
                for (int i2 = 0; i2 < to.m_oldValues.length; ++i2) {
                    if (!to.p_info.getColumnName(i2).equals(colName)) continue;
                    to.m_newValues[i2] = from.m_oldValues[i1];
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < from.m_oldValues.length; ++i) {
                String colName;
                if (from.p_info.isVirtualColumn(i) || from.p_info.isKey(i) || !from.p_info.isAllowCopy(i) && !force || (colName = from.p_info.getColumnName(i)).startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID") || colName.equals("Processing") || colName.equals("UUID")) continue;
                to.m_newValues[i] = from.m_oldValues[i];
            }
        }
    }

    protected void load(int ID, String trxName) {
        this.log.finest("ID=" + ID);
        if (ID > 0) {
            this.setKeyInfo();
            this.m_IDs = new Object[]{ID};
            this.load(trxName);
        } else {
            this.loadDefaults();
            this.m_createNew = true;
            this.setKeyInfo();
            this.loadComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String trxName) {
        this.m_trxName = trxName;
        boolean success = true;
        StringBuffer sql = this.p_info.buildSelect();
        sql.append(" WHERE ").append(this.get_WhereClause(false));
        int size = this.get_ColumnCount();
        if (CLogMgt.isLevelFinest()) {
            this.log.finest(this.get_WhereClause(true));
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.m_trxName);
            for (int i = 0; i < this.m_IDs.length; ++i) {
                Object oo = this.m_IDs[i];
                if (oo instanceof Integer) {
                    pstmt.setInt(i + 1, (Integer)this.m_IDs[i]);
                    continue;
                }
                pstmt.setString(i + 1, this.m_IDs[i].toString());
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                success = this.load(rs);
            } else {
                if (!this.log.getLevel().equals(Level.CONFIG)) {
                    this.log.log(Level.WARNING, "NO Data found for " + this.get_WhereClause(true));
                }
                this.m_IDs = new Object[]{I_ZERO};
                success = false;
            }
            this.m_createNew = false;
            this.m_newValues = new Object[size];
        }
        catch (Exception e) {
            try {
                Object msg = "";
                if (this.m_trxName != null) {
                    msg = "[" + this.m_trxName + "] - ";
                }
                msg = (String)msg + this.get_WhereClause(true) + ", SQL=" + sql.toString();
                success = false;
                this.m_IDs = new Object[]{I_ZERO};
                this.log.log(Level.SEVERE, (String)msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.loadComplete(success);
        return success;
    }

    protected boolean load(ResultSet rs) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(rs)");
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            Class clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            if (this.p_info.isVirtualColumn(index)) continue;
            try {
                this.m_oldValues[index] = clazz == Integer.class ? this.decrypt(index, (Object)rs.getInt(columnName)) : (clazz == BigDecimal.class ? this.decrypt(index, (Object)rs.getBigDecimal(columnName)) : (clazz == Boolean.class ? Boolean.valueOf("Y".equals(this.decrypt(index, (Object)rs.getString(columnName)))) : (clazz == Timestamp.class ? this.decrypt(index, (Object)rs.getTimestamp(columnName)) : (DisplayType.isLOB((int)dt) || DisplayType.isText((int)dt) && this.p_info.getFieldLength(index) > 4000 ? this.get_LOB(rs.getObject(columnName)) : (clazz == String.class ? this.decrypt(index, (Object)rs.getString(columnName)) : this.loadSpecial(rs, index))))));
                if (rs.wasNull() && this.m_oldValues[index] != null) {
                    this.m_oldValues[index] = null;
                }
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.SEVERE, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                success = false;
            }
        }
        this.m_createNew = false;
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected boolean load(HashMap<String, String> hmIn) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(hm)");
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            String value = hmIn.get(columnName);
            if (value == null) continue;
            Class clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                this.m_oldValues[index] = clazz == Integer.class ? Integer.valueOf(value) : (clazz == BigDecimal.class ? new BigDecimal(value) : (clazz == Boolean.class ? Boolean.valueOf("Y".equals(value)) : (clazz == Timestamp.class ? Timestamp.valueOf(value) : (DisplayType.isLOB((int)dt) ? null : (clazz == String.class ? value : null)))));
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (Exception e) {
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.SEVERE, "(ht) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                success = false;
            }
        }
        this.m_createNew = false;
        this.setStandardDefaults();
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected HashMap<String, String> get_HashMap() {
        HashMap<String, String> hmOut = new HashMap<String, String>();
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            Object value = this.get_Value(i);
            if (value == null || this.p_info.isVirtualColumn(i)) continue;
            int dt = this.p_info.getColumnDisplayType(i);
            Class c = this.p_info.getColumnClass(i);
            String stringValue = null;
            if (c != Object.class && value != null && !value.equals(Null.NULL)) {
                if (value instanceof Integer || value instanceof BigDecimal) {
                    stringValue = value.toString();
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    stringValue = bValue ? "Y" : "N";
                } else if (value instanceof Timestamp) {
                    stringValue = value.toString();
                } else if (c == String.class) {
                    stringValue = (String)value;
                } else if (DisplayType.isLOB((int)dt)) {
                    // empty if block
                }
            }
            if (stringValue == null) continue;
            hmOut.put(this.p_info.getColumnName(i), stringValue);
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                String value = (String)this.m_custom.get(column);
                if (value == null) continue;
                hmOut.put(column, value);
            }
            this.m_custom = null;
        }
        return hmOut;
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        this.log.finest("(NOP) - " + this.p_info.getColumnName(index));
        return null;
    }

    protected void loadComplete(boolean success) {
    }

    protected void loadDefaults() {
        this.setStandardDefaults();
    }

    protected void setStandardDefaults() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (this.p_info.isVirtualColumn(i)) continue;
            String colName = this.p_info.getColumnName(i);
            this.m_newValues[i] = colName.endsWith("tedBy") ? Integer.valueOf(Env.getContextAsInt((Properties)this.p_ctx, (String)"#AD_User_ID")) : (colName.equals("Created") || colName.equals("Updated") ? new Timestamp(System.currentTimeMillis()) : (colName.equals(this.p_info.getTableName() + "_ID") ? I_ZERO : (colName.equals("IsActive") ? Boolean.TRUE : (colName.equals("AD_Client_ID") ? Integer.valueOf(Env.getAD_Client_ID((Properties)this.p_ctx)) : (colName.equals("AD_Org_ID") ? Integer.valueOf(Env.getAD_Org_ID((Properties)this.p_ctx)) : (colName.equals("Processed") ? Boolean.FALSE : (colName.equals("Processing") ? Boolean.FALSE : (colName.equals("Posted") ? Boolean.FALSE : this.getDefaultValue(this.get_ColumnName(i))))))))));
        }
    }

    public Object getDefaultValue(String columnName) {
        int columnIndex = this.get_ColumnIndex(columnName);
        return this.getDefaultValue(columnIndex);
    }

    public Object getDefaultValue(int columnIndex) {
        String defaultValue = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)this.p_info.getDefaultLogic(columnIndex), (boolean)true, (boolean)false);
        if (defaultValue != null && defaultValue.length() > 0) {
            POInfoColumn infoColumn = this.p_info.getColumn(columnIndex);
            GridFieldVO valueObject = GridFieldVO.createStdField((Properties)Env.getCtx(), (int)0, (int)0, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false);
            valueObject.isProcess = true;
            valueObject.IsUpdateable = infoColumn.IsUpdateable;
            valueObject.AD_Column_ID = infoColumn.AD_Column_ID;
            valueObject.AD_Table_ID = this.p_info.getAD_Table_ID();
            valueObject.ColumnName = infoColumn.ColumnName;
            valueObject.displayType = infoColumn.DisplayType;
            valueObject.AD_Reference_Value_ID = infoColumn.AD_Reference_Value_ID;
            valueObject.IsMandatory = infoColumn.IsMandatory;
            valueObject.IsKey = infoColumn.IsKey;
            valueObject.DefaultValue = defaultValue;
            valueObject.ValueMin = infoColumn.ValueMin;
            valueObject.ValueMax = infoColumn.ValueMin;
            valueObject.ValidationCode = infoColumn.ValidationCode;
            valueObject.Description = infoColumn.ColumnDescription;
            valueObject.ColumnSQL = infoColumn.ColumnSQL;
            valueObject.Header = infoColumn.ColumnLabel;
            valueObject.initFinish();
            GridField field = new GridField(valueObject);
            return field.getDefault();
        }
        return null;
    }

    private void setKeyInfo() {
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isKey(i)) continue;
            String ColumnName = this.p_info.getColumnName(i);
            this.m_KeyColumns = new String[]{ColumnName};
            if (this.p_info.getColumnName(i).endsWith("_ID")) {
                Integer ii = (Integer)this.get_Value(i);
                this.m_IDs = ii == null ? new Object[]{I_ZERO} : new Object[]{ii};
                this.log.finest("(PK) " + ColumnName + "=" + ii);
            } else {
                Object oo = this.get_Value(i);
                this.m_IDs = oo == null ? new Object[]{null} : new Object[]{oo};
                this.log.finest("(PK) " + ColumnName + "=" + oo);
            }
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnParent(i)) continue;
            columnNames.add(this.p_info.getColumnName(i));
        }
        int size = columnNames.size();
        if (size == 0) {
            throw new IllegalStateException("No PK nor FK - " + this.p_info.getTableName());
        }
        this.m_IDs = new Object[size];
        this.m_KeyColumns = new String[size];
        for (int i = 0; i < size; ++i) {
            this.m_KeyColumns[i] = (String)columnNames.get(i);
            if (this.m_KeyColumns[i].endsWith("_ID")) {
                Integer ii = null;
                try {
                    ii = (Integer)this.get_Value(this.m_KeyColumns[i]);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", (Throwable)e);
                }
                if (ii != null) {
                    this.m_IDs[i] = ii;
                }
            } else {
                this.m_IDs[i] = this.get_Value(this.m_KeyColumns[i]);
            }
            this.log.finest("(FK) " + this.m_KeyColumns[i] + "=" + this.m_IDs[i]);
        }
    }

    protected boolean isMandatoryOK() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (!this.p_info.isColumnMandatory(i) || this.p_info.isVirtualColumn(i) || this.get_Value(i) != null && !this.get_Value(i).equals(Null.NULL)) continue;
            this.log.info(this.p_info.getColumnName(i));
            return false;
        }
        return true;
    }

    protected final void setAD_Client_ID(int AD_Client_ID) {
        this.set_ValueNoCheck("AD_Client_ID", (Object)AD_Client_ID);
    }

    public final int getAD_Client_ID() {
        Integer ii = (Integer)this.get_Value("AD_Client_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final void setAD_Org_ID(int AD_Org_ID) {
        this.set_ValueNoCheck("AD_Org_ID", (Object)AD_Org_ID);
    }

    public int getAD_Org_ID() {
        Integer ii = (Integer)this.get_Value("AD_Org_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        if (AD_Client_ID != this.getAD_Client_ID()) {
            this.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != this.getAD_Org_ID()) {
            this.setAD_Org_ID(AD_Org_ID);
        }
    }

    protected void setClientOrg(PO po) {
        this.setClientOrg(po.getAD_Client_ID(), po.getAD_Org_ID());
    }

    public final void setIsActive(boolean active) {
        this.set_Value("IsActive", (Object)active);
    }

    public final boolean isActive() {
        Boolean bb = (Boolean)this.get_Value("IsActive");
        if (bb != null) {
            return bb;
        }
        return false;
    }

    public final Timestamp getCreated() {
        return (Timestamp)this.get_Value("Created");
    }

    public final Timestamp getUpdated() {
        return (Timestamp)this.get_Value("Updated");
    }

    public final int getCreatedBy() {
        Integer ii = (Integer)this.get_Value("CreatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final int getUpdatedBy() {
        Integer ii = (Integer)this.get_Value("UpdatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected final void setUpdatedBy(int AD_User_ID) {
        this.set_ValueNoCheck("UpdatedBy", (Object)AD_User_ID);
    }

    public String get_Translation(String columnName, String AD_Language) {
        if (columnName == null || AD_Language == null || this.m_IDs.length > 1) {
            throw new IllegalArgumentException("ColumnName=" + columnName + ", AD_Language=" + AD_Language + ", ID.length=" + this.m_IDs.length + ", ID=" + this.m_IDs[0]);
        }
        String retValue = null;
        if (!Env.isBaseLanguage((String)AD_Language, (String)this.get_TableName()) && this.p_info.isColumnTranslated(this.p_info.getColumnIndex(columnName))) {
            int ID = (Integer)this.m_IDs[0];
            StringBuffer sql = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(this.p_info.getTableName()).append("_Trl WHERE ").append(this.m_KeyColumns[0]).append("=?").append(" AND AD_Language=?");
            retValue = DB.getSQLValueString((String)this.get_TrxName(), (String)sql.toString(), (Object[])new Object[]{ID, AD_Language});
        }
        if (retValue == null) {
            Object val = this.get_Value(columnName);
            retValue = val != null ? val.toString() : null;
        }
        return retValue;
    }

    public String get_Translation(String columnName) {
        return this.get_Translation(columnName, Env.getAD_Language((Properties)this.getCtx()));
    }

    public boolean is_new() {
        if (this.m_createNew) {
            return true;
        }
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (this.m_IDs[i].equals(I_ZERO) || this.m_IDs[i] == Null.NULL) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        CLogger.resetLast();
        boolean newRecord = this.is_new();
        if (!newRecord && !this.is_Changed()) {
            this.log.fine("Nothing changed - " + this.p_info.getTableName());
            return true;
        }
        if (this.getAD_Org_ID() == 0 && (this.get_AccessLevel() == 1 || this.get_AccessLevel() == 3 && MClientShare.isOrgLevelOnly((int)this.getAD_Client_ID(), (int)this.get_Table_ID()))) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID"));
            return false;
        }
        if (this.getAD_Org_ID() != 0) {
            boolean reset;
            boolean bl = reset = this.get_AccessLevel() == 4;
            if (!reset && MClientShare.isClientLevelOnly((int)this.getAD_Client_ID(), (int)this.get_Table_ID())) {
                boolean bl2 = reset = this.get_AccessLevel() == 2 || this.get_AccessLevel() == 6 || this.get_AccessLevel() == 7 || this.get_AccessLevel() == 3;
            }
            if (reset) {
                this.log.warning("Set Org to 0");
                this.setAD_Org_ID(0);
            }
        }
        Trx localTrx = null;
        Trx trx = null;
        Savepoint savepoint = null;
        if (this.m_trxName == null) {
            this.m_trxName = Trx.createTrxName((String)"POSave");
            localTrx = Trx.get((String)this.m_trxName, (boolean)true);
        } else {
            trx = Trx.get((String)this.m_trxName, (boolean)false);
            if (trx == null) {
                trx = Trx.get((String)this.m_trxName, (boolean)true);
                this.log.severe("Transaction closed or never opened (" + this.m_trxName + ") => starting now --> " + this.toString());
            }
        }
        try {
            if (localTrx == null) {
                savepoint = trx.setSavepoint(null);
            }
            if (!this.beforeSave(newRecord)) {
                this.log.warning("beforeSave failed - " + this.toString());
                if (localTrx != null) {
                    localTrx.rollback(true);
                    localTrx.close();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                    savepoint = null;
                }
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeSave - " + this.toString(), (Throwable)e);
            this.log.saveError("Error", e, false);
            if (localTrx != null) {
                localTrx.rollback();
                localTrx.close();
                this.m_trxName = null;
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                savepoint = null;
            }
            return false;
        }
        try {
            boolean b;
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? 1 : 2);
            if (errorMsg != null) {
                this.log.warning("Validation failed - " + errorMsg);
                this.log.saveError("Error", errorMsg);
                if (localTrx != null) {
                    localTrx.rollback(true);
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                }
                boolean bl = false;
                return bl;
            }
            if (newRecord) {
                b = this.saveNew();
                if (b) {
                    if (localTrx != null) {
                        boolean e = localTrx.commit(true);
                        return e;
                    }
                    boolean e = b;
                    return e;
                }
                if (localTrx != null) {
                    localTrx.rollback(true);
                } else {
                    trx.rollback(savepoint);
                }
                boolean e = b;
                return e;
            }
            b = this.saveUpdate();
            if (b) {
                if (localTrx != null) {
                    boolean e = localTrx.commit(true);
                    return e;
                }
                boolean e = b;
                return e;
            }
            if (localTrx != null) {
                localTrx.rollback(true);
            } else {
                trx.rollback(savepoint);
            }
            boolean e = b;
            return e;
        }
        catch (Exception e) {
            this.log.saveError("Error", e);
            if (localTrx != null) {
                localTrx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                savepoint = null;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (localTrx != null) {
                    localTrx.close();
                    this.m_trxName = null;
                } else {
                    if (savepoint != null) {
                        trx.releaseSavepoint(savepoint);
                    }
                    savepoint = null;
                    trx = null;
                }
            }
            catch (SQLException e) {
                this.log.saveError("Error", (Exception)e);
            }
        }
    }

    public void saveEx() throws AdempiereException {
        if (!this.save()) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "SaveError";
            }
            throw new AdempiereException(msg);
        }
    }

    private boolean saveFinish(boolean newRecord, boolean success) {
        if (!this.isDirectLoad) {
            if (success) {
                if (newRecord) {
                    this.insertTranslations();
                } else {
                    this.updateTranslations();
                }
            }
            try {
                success = this.afterSave(newRecord, success);
                if (success && newRecord) {
                    this.insertTreeNode();
                } else if (success && !newRecord) {
                    this.updateTreeNode();
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "afterSave", (Throwable)e);
                this.log.saveError("Error", e, false);
                success = false;
            }
        }
        if (success && !this.isDirectLoad) {
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? (this.isReplication() ? 7 : 4) : (this.isReplication() ? 8 : 5));
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
        }
        if (success && !this.isDirectLoad) {
            if (s_docWFMgr == null) {
                try {
                    Class.forName("org.compiere.wf.DocWorkflowManager");
                }
                catch (Exception errorMsg) {
                    // empty catch block
                }
            }
            if (s_docWFMgr != null) {
                s_docWFMgr.process(this, this.p_info.getAD_Table_ID());
            }
        }
        if (success) {
            int size = this.p_info.getColumnCount();
            for (int i = 0; i < size; ++i) {
                if (this.m_newValues[i] == null) continue;
                this.m_oldValues[i] = this.m_newValues[i] == Null.NULL ? null : this.m_newValues[i];
            }
            this.m_newValues = new Object[size];
        }
        this.m_createNew = false;
        if (!newRecord) {
            CacheMgt.get().reset(this.p_info.getTableName());
        }
        return success;
    }

    public boolean save(String trxName) {
        this.set_TrxName(trxName);
        return this.save();
    }

    public void saveReplica(boolean isFromReplication) throws AdempiereException {
        this.setReplication(isFromReplication);
        this.saveEx();
    }

    public void saveEx(String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.saveEx();
    }

    public boolean is_Changed() {
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (!this.is_ValueChanged(i)) continue;
            return true;
        }
        return this.m_custom != null && this.m_custom.size() > 0;
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean saveUpdate() {
        MSession session;
        String value;
        String where = this.get_WhereClause(true);
        boolean changes = false;
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET ");
        boolean updated = false;
        boolean updatedBy = false;
        this.lobReset();
        String columnName = "UUID";
        if (this.p_info.getColumnIndex(columnName) != -1 && ((value = this.get_ValueAsString(columnName)) == null || value.length() == 0)) {
            value = DB.getUUID((String)this.m_trxName);
            this.set_ValueNoCheck(columnName, (Object)value);
        }
        if ((session = MSession.get((Properties)this.p_ctx, (boolean)false, (boolean)false)) == null) {
            this.log.fine("No Session found");
        } else if (Ini.isPropertyBool((String)"LogMigrationScript")) {
            session.logMigration(this, this.p_info, "U");
        }
        int AD_ChangeLog_ID = 0;
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            MChangeLog cLog;
            columnName = this.p_info.getColumnName(i);
            Object value2 = this.m_newValues[i];
            if (value2 == null || this.p_info.isVirtualColumn(i)) continue;
            Class c = this.p_info.getColumnClass(i);
            int dt = this.p_info.getColumnDisplayType(i);
            if (columnName.equals("UpdatedBy")) {
                if (updatedBy) continue;
                updatedBy = true;
            } else if (columnName.equals("Updated")) {
                if (updated) continue;
                updated = true;
            }
            if (DisplayType.isLOB((int)dt) || DisplayType.isText((int)dt) && this.p_info.getFieldLength(i) > 4000) {
                this.lobAdd(value2, i, dt);
                if (changes || updatedBy) continue;
                int AD_User_ID = Env.getContextAsInt((Properties)this.p_ctx, (String)"#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", (Object)AD_User_ID);
                sql.append("UpdatedBy=").append(AD_User_ID);
                changes = true;
                updatedBy = true;
                continue;
            }
            if (columnName.equals("DocumentNo") && value2 instanceof String) {
                String strValue = (String)value2;
                if (strValue.startsWith("<") && strValue.endsWith(">")) {
                    value2 = null;
                    int AD_Client_ID = this.getAD_Client_ID();
                    int index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                    if (index == -1) {
                        index = this.p_info.getColumnIndex("C_DocType_ID");
                    }
                    if (index != -1) {
                        value2 = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.m_trxName, (boolean)false, (PO)this);
                    }
                    if (value2 == null) {
                        value2 = DB.getDocumentNo((int)AD_Client_ID, (String)this.p_info.getTableName(), (String)this.m_trxName, (PO)this);
                    }
                } else {
                    this.log.warning("DocumentNo updated: " + this.m_oldValues[i] + " -> " + value2);
                }
            }
            if (changes) {
                sql.append(", ");
            }
            changes = true;
            sql.append(columnName).append("=");
            if (value2 == Null.NULL) {
                sql.append("NULL");
            } else if (value2 instanceof Integer || value2 instanceof BigDecimal) {
                sql.append(this.encrypt(i, value2));
            } else if (c == Boolean.class) {
                boolean bValue = false;
                bValue = value2 instanceof Boolean ? ((Boolean)value2).booleanValue() : "Y".equals(value2);
                sql.append(this.encrypt(i, (Object)(bValue ? "'Y'" : "'N'")));
            } else if (value2 instanceof Timestamp) {
                sql.append(DB.TO_DATE((Timestamp)((Timestamp)this.encrypt(i, value2)), (this.p_info.getColumnDisplayType(i) == 15 ? 1 : 0) != 0));
            } else if (value2.toString().length() == 0) {
                sql.append(DB.TO_STRING((String)value2.toString()));
            } else {
                sql.append(this.encrypt(i, (Object)DB.TO_STRING((String)value2.toString())));
            }
            if (session == null || this.m_IDs.length != 1 || !this.p_info.isAllowLogging(i) || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(columnName) || this.p_info.getTableName().equals("AD_Session")) continue;
            Object oldV = this.m_oldValues[i];
            Object newV = value2;
            if (oldV != null && oldV == Null.NULL) {
                oldV = null;
            }
            if (newV != null && newV == Null.NULL) {
                newV = null;
            }
            if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, "U")) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            Iterator it = this.m_custom.keySet().iterator();
            while (it.hasNext()) {
                if (changes) {
                    sql.append(", ");
                }
                changes = true;
                String column = (String)it.next();
                String value3 = (String)this.m_custom.get(column);
                int index = this.p_info.getColumnIndex(column);
                sql.append(column).append("=").append(this.encrypt(index, (Object)value3));
            }
            this.m_custom = null;
        }
        if (changes) {
            boolean ok;
            if (this.m_trxName == null) {
                this.log.fine(this.p_info.getTableName() + "." + where);
            } else {
                this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            if (!updated) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.set_ValueNoCheck("Updated", (Object)now);
                sql.append(",Updated=").append(DB.TO_DATE((Timestamp)now, (boolean)false));
            }
            if (!updatedBy) {
                int AD_User_ID = Env.getContextAsInt((Properties)this.p_ctx, (String)"#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", (Object)AD_User_ID);
                sql.append(",UpdatedBy=").append(AD_User_ID);
            }
            sql.append(" WHERE ").append(where);
            this.log.finest(sql.toString());
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? DB.executeUpdateEx((String)sql.toString(), (String)this.m_trxName, (int)10) : DB.executeUpdate((String)sql.toString(), (String)this.m_trxName);
            boolean bl = ok = no == 1;
            if (ok) {
                ok = this.lobSave();
            } else if (this.m_trxName == null) {
                this.log.log(Level.WARNING, "#" + no + " - " + this.p_info.getTableName() + "." + where);
            } else {
                this.log.log(Level.WARNING, "#" + no + " - [" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            return this.saveFinish(false, ok);
        }
        return this.saveFinish(false, true);
    }

    private boolean isUseTimeoutForUpdate() {
        return "true".equalsIgnoreCase(System.getProperty("org.adempiere.po.useTimeoutForUpdate", "false")) && DB.getDatabase().isQueryTimeoutSupported();
    }

    private boolean saveNew() {
        boolean ok;
        String value;
        if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID") && (!this.isDirectLoad || this.get_ID() <= 0)) {
            int no = this.saveNew_getID();
            if (no <= 0) {
                no = DB.getNextID((int)this.getAD_Client_ID(), (String)this.p_info.getTableName(), (String)this.m_trxName);
            }
            if (this.isReplication() && this.get_ID() > 0) {
                no = this.get_ID();
            }
            if (no <= 0) {
                this.log.severe("No NextID (" + no + ")");
                return this.saveFinish(true, false);
            }
            this.m_IDs[0] = no;
            this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
        }
        if (this.m_trxName == null) {
            this.log.fine(this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        } else {
            this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        }
        String columnName = "DocumentNo";
        int index = this.p_info.getColumnIndex(columnName);
        if (index != -1 && this.p_info.getColumn((int)index).ColumnSQL == null) {
            value = (String)this.get_Value(index);
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                int dt = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                if (dt == -1) {
                    dt = this.p_info.getColumnIndex("C_DocType_ID");
                }
                if (dt != -1) {
                    value = DB.getDocumentNo((int)this.get_ValueAsInt(dt), (String)this.m_trxName, (boolean)false, (PO)this);
                }
                if (value == null) {
                    value = DB.getDocumentNo((int)this.getAD_Client_ID(), (String)this.p_info.getTableName(), (String)this.m_trxName, (PO)this);
                }
                this.set_ValueNoCheck(columnName, (Object)value);
            }
        }
        if ((index = this.p_info.getColumnIndex(columnName = "Value")) != -1 && ((value = (String)this.get_Value(index)) == null || value.length() == 0)) {
            value = DB.getDocumentNo((int)this.getAD_Client_ID(), (String)this.p_info.getTableName(), (String)this.m_trxName, (PO)this);
            this.set_ValueNoCheck(columnName, (Object)value);
        }
        if (this.p_info.getColumnIndex(columnName = "UUID") != -1 && (Util.isEmpty((String)(value = this.get_ValueAsString(columnName))) || !this.isDirectLoad && !this.isReplication())) {
            value = DB.getUUID((String)this.m_trxName);
            this.set_ValueNoCheck(columnName, (Object)value);
        }
        this.lobReset();
        MSession session = MSession.get((Properties)this.p_ctx, (boolean)false, (boolean)false);
        if (session == null) {
            this.log.fine("No Session found");
        } else if (Ini.isPropertyBool((String)"LogMigrationScript")) {
            session.logMigration(this, this.p_info, "I");
        }
        int AD_ChangeLog_ID = 0;
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO ");
        sqlInsert.append(this.p_info.getTableName()).append(" (");
        StringBuffer sqlValues = new StringBuffer(") VALUES (");
        int size = this.get_ColumnCount();
        boolean doComma = false;
        for (int i = 0; i < size; ++i) {
            MChangeLog cLog;
            Object value2 = this.get_Value(i);
            if (value2 == null || this.p_info.isVirtualColumn(i)) continue;
            int dt = this.p_info.getColumnDisplayType(i);
            if (DisplayType.isLOB((int)dt) || DisplayType.isText((int)dt) && this.p_info.getFieldLength(i) > 4000) {
                this.lobAdd(value2, i, dt);
                continue;
            }
            if (doComma) {
                sqlInsert.append(",");
                sqlValues.append(",");
            } else {
                doComma = true;
            }
            sqlInsert.append(this.p_info.getColumnName(i));
            Class c = this.p_info.getColumnClass(i);
            try {
                if (c == Object.class) {
                    sqlValues.append(this.saveNewSpecial(value2, i));
                } else if (value2 == null || value2.equals(Null.NULL)) {
                    sqlValues.append("NULL");
                } else if (value2 instanceof Integer || value2 instanceof BigDecimal) {
                    sqlValues.append(this.encrypt(i, value2));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value2 instanceof Boolean ? ((Boolean)value2).booleanValue() : "Y".equals(value2);
                    sqlValues.append(this.encrypt(i, (Object)(bValue ? "'Y'" : "'N'")));
                } else if (value2 instanceof Timestamp) {
                    sqlValues.append(DB.TO_DATE((Timestamp)((Timestamp)this.encrypt(i, value2)), (this.p_info.getColumnDisplayType(i) == 15 ? 1 : 0) != 0));
                } else if (c == String.class) {
                    sqlValues.append(this.encrypt(i, (Object)DB.TO_STRING((String)((String)value2))));
                } else if (DisplayType.isLOB((int)dt)) {
                    sqlValues.append("null");
                } else {
                    sqlValues.append(this.saveNewSpecial(value2, i));
                }
            }
            catch (Exception e) {
                Object msg = "";
                if (this.m_trxName != null) {
                    msg = "[" + this.m_trxName + "] - ";
                }
                msg = (String)msg + this.p_info.toString(i) + " - Value=" + value2 + "(" + (value2 == null ? "null" : value2.getClass().getName()) + ")";
                this.log.log(Level.SEVERE, (String)msg, (Throwable)e);
                throw new DBException(e);
            }
            String insertLog = MSysConfig.getValue((String)"SYSTEM_INSERT_CHANGELOG", (String)"Y", (int)this.getAD_Client_ID());
            if (session == null || this.m_IDs.length != 1 || !this.p_info.isAllowLogging(i) || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(columnName) || this.p_info.getTableName().equals("AD_Session") || !insertLog.equalsIgnoreCase("Y") && (!insertLog.equalsIgnoreCase("K") || !this.p_info.getColumn((int)i).IsKey) || (cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), null, value2, "I")) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                index = this.p_info.getColumnIndex(column);
                String value3 = (String)this.m_custom.get(column);
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(column);
                sqlValues.append(this.encrypt(index, (Object)value3));
            }
            this.m_custom = null;
        }
        sqlInsert.append(sqlValues).append(")");
        int no = DB.executeUpdate((String)sqlInsert.toString(), (String)this.m_trxName);
        boolean bl = ok = no == 1;
        if (ok) {
            ok = this.lobSave();
            if (!this.load(this.m_trxName)) {
                if (this.m_trxName == null) {
                    this.log.log(Level.SEVERE, "reloading");
                } else {
                    this.log.log(Level.SEVERE, "[" + this.m_trxName + "] - reloading");
                }
                ok = false;
            }
        } else {
            Object msg = "Not inserted - ";
            msg = CLogMgt.isLevelFiner() ? (String)msg + sqlInsert.toString() : (String)msg + this.get_TableName();
            if (this.m_trxName == null) {
                this.log.log(Level.WARNING, (String)msg);
            } else {
                this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + (String)msg);
            }
        }
        return this.saveFinish(true, ok);
    }

    protected int saveNew_getID() {
        if (this.get_ID() < 999999) {
            return this.get_ID();
        }
        return 0;
    }

    public String get_WhereClause(boolean withValues) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_IDs.length; ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(this.m_KeyColumns[i]).append("=");
            if (withValues) {
                if (this.m_KeyColumns[i].endsWith("_ID")) {
                    sb.append(this.m_IDs[i]);
                    continue;
                }
                sb.append("'").append(this.m_IDs[i]).append("'");
                continue;
            }
            sb.append("?");
        }
        return sb.toString();
    }

    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colClass = this.p_info.getColumnClass(index).toString();
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.log(Level.SEVERE, "Unknown class for column " + colName + " (" + colClass + ") - Value=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private Object encrypt(int index, Object xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt((Object)xx);
        }
        return xx;
    }

    private Object decrypt(int index, Object yy) {
        if (yy == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.decrypt((Object)yy);
        }
        return yy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(boolean force) {
        CLogger.resetLast();
        if (this.is_new()) {
            return true;
        }
        int AD_Table_ID = this.p_info.getAD_Table_ID();
        int Record_ID = this.get_ID();
        if (!force) {
            Boolean processed;
            int clientId = Env.getAD_Client_ID((Properties)this.p_ctx);
            if (clientId > 0 && clientId != this.getAD_Client_ID()) {
                this.log.warning("Record is other client");
                this.log.saveError("CannotDeleteRecordOfAnotherClient", "", false);
                return false;
            }
            int iProcessed = this.get_ColumnIndex("Processed");
            if (iProcessed != -1 && (processed = (Boolean)this.get_Value(iProcessed)) != null && processed.booleanValue()) {
                this.log.warning("Record processed");
                this.log.saveError("Processed", "Processed", false);
                return false;
            }
        }
        Trx localTrx = null;
        boolean success = false;
        try {
            String localTrxName = this.m_trxName;
            if (localTrxName == null) {
                localTrxName = Trx.createTrxName((String)"POdel");
                localTrx = Trx.get((String)localTrxName, (boolean)true);
                this.m_trxName = localTrxName;
            }
            try {
                if (!this.beforeDelete()) {
                    this.log.warning("beforeDelete failed");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "beforeDelete", (Throwable)e);
                this.log.saveError("Error", e, false);
                boolean bl = false;
                return bl;
            }
            String errorMsg = PO_Record.exists((int)AD_Table_ID, (int)Record_ID, (String)this.m_trxName);
            if (errorMsg != null) {
                this.log.saveError("CannotDelete", errorMsg);
                boolean bl = false;
                return bl;
            }
            errorMsg = ModelValidationEngine.get().fireModelChange(this, this.isReplication() ? 9 : 3);
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                boolean bl = false;
                return bl;
            }
            this.deleteTranslations(localTrxName);
            PO_Record.deleteCascade((int)AD_Table_ID, (int)Record_ID, (String)localTrxName);
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(true));
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? DB.executeUpdateEx((String)sql.toString(), (String)localTrxName, (int)10) : DB.executeUpdate((String)sql.toString(), (String)localTrxName);
            success = no == 1;
            this.m_idOld = this.get_ID();
            if (!success) {
                this.log.warning("Not deleted");
                if (localTrx != null) {
                    localTrx.rollback();
                }
            } else if (success) {
                MSession session = MSession.get((Properties)this.p_ctx, (boolean)false, (boolean)false);
                if (session == null) {
                    this.log.fine("No Session found");
                } else if (Ini.isPropertyBool((String)"LogMigrationScript")) {
                    session.logMigration(this, this.p_info, "D");
                }
                if (this.p_info.isChangeLog()) {
                    if (session != null && this.m_IDs.length == 1) {
                        int AD_ChangeLog_ID = 0;
                        int size = this.get_ColumnCount();
                        for (int i = 0; i < size; ++i) {
                            MChangeLog cLog;
                            Object value = this.m_oldValues[i];
                            if (value == null || !this.p_info.isAllowLogging(i) || this.p_info.isEncrypted(i) || this.p_info.isVirtualColumn(i) || "Password".equals(this.p_info.getColumnName(i)) || this.p_info.getTableName().equals("AD_Session") || (cLog = session.changeLog(this.m_trxName != null ? this.m_trxName : localTrxName, AD_ChangeLog_ID, AD_Table_ID, this.p_info.getColumn((int)i).AD_Column_ID, Record_ID, this.getAD_Client_ID(), this.getAD_Org_ID(), value, null, "D")) == null) continue;
                            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                        }
                    }
                    this.m_IDs[0] = I_ZERO;
                    if (this.m_trxName == null) {
                        this.log.fine("complete");
                    } else {
                        this.log.fine("[" + this.m_trxName + "] - complete");
                    }
                    this.m_attachment = null;
                }
            } else {
                this.log.warning("Not deleted");
            }
            try {
                success = this.afterDelete(success);
                if (success) {
                    this.deleteTreeNode();
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "afterDelete", (Throwable)e);
                this.log.saveError("Error", e, false);
                success = false;
            }
            if (success && (errorMsg = ModelValidationEngine.get().fireModelChange(this, 6)) != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
            if (!success) {
                if (localTrx != null) {
                    localTrx.rollback();
                }
            } else if (localTrx != null) {
                try {
                    localTrx.commit(true);
                }
                catch (SQLException e) {
                    this.log.saveError("Error", (Exception)e);
                    success = false;
                }
            }
            if (success) {
                this.m_idOld = 0;
                int size = this.p_info.getColumnCount();
                this.m_oldValues = new Object[size];
                this.m_newValues = new Object[size];
                CacheMgt.get().reset(this.p_info.getTableName());
            }
        }
        finally {
            if (localTrx != null) {
                localTrx.close();
                this.m_trxName = null;
            }
        }
        return success;
    }

    public void deleteEx(boolean force) throws AdempiereException {
        if (!this.delete(force)) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "DeleteError";
            }
            throw new AdempiereException(msg);
        }
    }

    public boolean delete(boolean force, String trxName) {
        this.set_TrxName(trxName);
        return this.delete(force);
    }

    public void deleteEx(boolean force, String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.deleteEx(force);
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        return success;
    }

    public boolean insertTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        ArrayList<String> tColumns = new ArrayList<String>();
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnTranslated(i)) continue;
            tColumns.add(this.p_info.getColumnName(i));
        }
        if (tColumns.size() == 0) {
            return true;
        }
        MLanguage[] langs = MLanguage.getMaintainLanguage((Properties)this.getCtx());
        if (langs.length == 0) {
            return true;
        }
        String tableName = this.p_info.getTableName() + "_Trl";
        String keyColumn = this.m_KeyColumns[0];
        MTable table = MTable.get((Properties)this.getCtx(), (String)tableName);
        if (table == null) {
            this.log.warning("Table [" + tableName + "] Not found");
            return false;
        }
        int no = 0;
        for (MLanguage language : langs) {
            GenericPO po = new GenericPO(tableName, this.getCtx(), -1);
            po.set_Value(keyColumn, (Object)this.get_ID());
            po.set_Value("IsTranslated", (Object)false);
            po.set_Value("AD_Language", (Object)language.getAD_Language());
            po.setAD_Client_ID(this.getAD_Client_ID());
            po.setAD_Org_ID(0);
            for (String translationColumn : tColumns) {
                Object value = this.get_Value(translationColumn);
                po.set_Value(translationColumn, value);
            }
            po.saveEx(this.m_trxName);
            ++no;
        }
        this.log.fine("#" + no);
        return no >= 0;
    }

    private boolean updateTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        boolean trlColumnChanged = false;
        for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
            if (!this.p_info.isColumnTranslated(i) || !this.is_ValueChanged(this.p_info.getColumnName(i))) continue;
            trlColumnChanged = true;
            break;
        }
        if (!trlColumnChanged) {
            return true;
        }
        String tableName = this.p_info.getTableName() + "_Trl";
        String keyColumn = this.m_KeyColumns[0];
        MTable table = MTable.get((Properties)this.getCtx(), (String)tableName);
        if (table == null) {
            this.log.warning("Table [" + tableName + "] Not found");
            return false;
        }
        MClient client = MClient.get((Properties)this.getCtx());
        List trlList = new Query(this.getCtx(), tableName, keyColumn + " = ?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        if (trlList == null || trlList.size() == 0) {
            return true;
        }
        int no = 0;
        for (PO trl : trlList) {
            boolean isTranslated = false;
            if (client.isAutoUpdateTrl(tableName)) {
                for (int i = 0; i < this.p_info.getColumnCount(); ++i) {
                    if (!this.p_info.isColumnTranslated(i)) continue;
                    String columnName = this.p_info.getColumnName(i);
                    Object value = this.get_Value(columnName);
                    trl.set_Value(columnName, value);
                }
                isTranslated = true;
            }
            trl.set_Value("IsTranslated", (Object)isTranslated);
            trl.saveEx(this.m_trxName);
            ++no;
        }
        this.log.fine("#" + no);
        return no >= 0;
    }

    private boolean deleteTranslations(String trxName) {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        String tableName = this.p_info.getTableName() + "_Trl";
        String keyColumn = this.m_KeyColumns[0];
        List trlList = new Query(this.getCtx(), tableName, keyColumn + " = ?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        if (trlList == null || trlList.size() == 0) {
            return true;
        }
        int no = 0;
        for (PO trl : trlList) {
            trl.deleteEx(true, this.m_trxName);
            ++no;
        }
        this.log.fine("#" + no);
        return no >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insert_Accounting(String acctTable, String acctBaseTable, String whereClause) {
        block6: {
            if (this.s_acctColumns != null && !acctTable.startsWith("C_BP_")) break block6;
            this.s_acctColumns = new ArrayList();
            String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.IsActive='Y' AND c.AD_Reference_ID=25 ORDER BY c.ColumnName";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setString(1, acctTable);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.s_acctColumns.add(rs.getString(1));
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, acctTable, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (this.s_acctColumns.size() == 0) {
                this.log.severe("No Columns for " + acctTable);
                return false;
            }
        }
        AtomicBoolean inserted = new AtomicBoolean(false);
        Arrays.stream(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (String)this.get_TrxName())).filter(accountSchema -> accountSchema != null).forEach(accountSchema -> {
            CPreparedStatement statement = null;
            ResultSet resultSet = null;
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            try {
                StringBuilder select = new StringBuilder();
                select.append("SELECT  * FROM ").append(acctBaseTable).append(" p WHERE p.AD_Client_ID=? AND ").append("p.C_AcctSchema_ID=?");
                if (whereClause != null && whereClause.length() > 0) {
                    select.append(" AND ").append(whereClause);
                }
                select.append(" AND NOT EXISTS (SELECT * FROM ").append(acctTable).append(" e WHERE e.C_AcctSchema_ID=p.C_AcctSchema_ID AND e.").append(this.get_TableName()).append("_ID=? )");
                parameters.add(this.getAD_Client_ID());
                parameters.add(accountSchema.getC_AcctSchema_ID());
                parameters.add(this.get_ID());
                statement = DB.prepareStatement((String)select.toString(), (String)this.get_TrxName());
                DB.setParameters((PreparedStatement)statement, parameters);
                resultSet = statement.executeQuery();
                PO accountBase = null;
                if (resultSet.next()) {
                    accountBase = MTable.get((Properties)this.getCtx(), (String)acctBaseTable).getPO(resultSet, this.get_TrxName());
                }
                if (accountBase != null) {
                    StringBuilder where = new StringBuilder();
                    where.append("C_AcctSchema_ID").append("=? AND ").append(this.get_TableName()).append("_ID=?");
                    parameters = new ArrayList();
                    parameters.add(accountSchema.getC_AcctSchema_ID());
                    parameters.add(this.get_ID());
                    PO accountSetting = MTable.get((Properties)this.getCtx(), (String)acctTable).getPO(where.toString(), parameters.toArray(), this.get_TrxName());
                    if (accountSetting == null) {
                        accountSetting = MTable.get((Properties)this.getCtx(), (String)acctTable).getPO(0, this.get_TrxName());
                        accountSetting.setAD_Client_ID(this.getAD_Client_ID());
                        accountSetting.setAD_Org_ID(0);
                        accountSetting.set_Value("C_AcctSchema_ID", (Object)accountSchema.getC_AcctSchema_ID());
                        accountSetting.set_Value(this.get_TableName() + "_ID", (Object)this.get_ID());
                        for (String columnName : this.s_acctColumns) {
                            accountSetting.set_Value(columnName, accountBase.get_Value(columnName));
                        }
                        accountSetting.saveEx();
                        inserted.set(true);
                    }
                }
                DB.close((ResultSet)resultSet, (Statement)statement);
                resultSet = null;
                statement = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, acctTable, (Throwable)e);
            }
            finally {
                DB.close(resultSet, statement);
                resultSet = null;
                statement = null;
            }
        });
        return inserted.get();
    }

    protected boolean delete_Accounting(String acctTable) {
        return true;
    }

    private boolean insertTreeNode() {
        Integer ii;
        int tableId = this.get_Table_ID();
        String whereClause = null;
        if (!MTree.hasTree((int)tableId)) {
            return false;
        }
        AtomicReference<String> treeTableName = new AtomicReference<String>();
        AtomicInteger treeId = new AtomicInteger();
        AtomicInteger parentColumnId = new AtomicInteger();
        AtomicInteger sortColumnId = new AtomicInteger();
        int elementId = 0;
        if (tableId == X_C_ElementValue.Table_ID && (ii = (Integer)this.get_Value("C_Element_ID")) != null) {
            elementId = ii;
            whereClause = "C_Element_ID = " + elementId;
            MElement element = MElement.get((Properties)this.getCtx(), (int)elementId, (String)this.get_TrxName());
            Optional.ofNullable(element.getTree()).ifPresent(tree -> {
                treeTableName.set(MTree.getNodeTableName((String)tree.getTreeType()));
                treeId.set(element.getAD_Tree_ID());
                parentColumnId.set(tree.getParent_Column_ID());
                sortColumnId.set(tree.getAD_ColumnSortOrder_ID());
            });
        }
        if (treeTableName.get() == null) {
            treeTableName.set(MTree.getNodeTableName((int)tableId));
        }
        if (treeId.get() <= 0) {
            treeId.set(MTree.getDefaultTreeIdFromTableId((int)this.getAD_Client_ID(), (int)tableId, (int)elementId));
        }
        if (treeId.get() <= 0) {
            return false;
        }
        if (treeTableName.get() == null) {
            return false;
        }
        if (elementId <= 0) {
            MTree tree2 = new MTree(this.getCtx(), treeId.get(), this.get_TrxName());
            parentColumnId.set(tree2.getParent_Column_ID());
            sortColumnId.set(tree2.getAD_ColumnSortOrder_ID());
        }
        PO treeNode = MTable.get((Properties)this.getCtx(), (String)((String)treeTableName.get())).getPO(0, this.get_TrxName());
        treeNode.setAD_Client_ID(this.getAD_Client_ID());
        treeNode.setAD_Org_ID(0);
        treeNode.setIsActive(true);
        treeNode.set_CustomColumn("AD_Tree_ID", (Object)treeId.get());
        treeNode.set_CustomColumn("Node_ID", (Object)this.get_ID());
        MColumn parentColumnIDforTree = null;
        if (parentColumnId.get() > 0) {
            parentColumnIDforTree = MColumn.get((Properties)this.getCtx(), (int)parentColumnId.get());
            treeNode.set_CustomColumn("Parent_ID", (Object)this.get_ValueAsInt(parentColumnIDforTree.getColumnName()));
        } else {
            treeNode.set_CustomColumn("Parent_ID", (Object)0);
        }
        if (treeNode.get_ValueAsInt("Parent_ID") == 0 && sortColumnId.get() > 0) {
            MColumn columnSortforTree = MColumn.get((Properties)this.getCtx(), (int)sortColumnId.get());
            treeNode.set_CustomColumn("Parent_ID", (Object)this.getParentFromSort(columnSortforTree.getColumnName(), this.get_ValueAsString(columnSortforTree.getColumnName()), whereClause));
            if (parentColumnIDforTree != null && treeNode.get_ValueAsInt("Parent_ID") != this.get_ValueAsInt(parentColumnIDforTree.getColumnName())) {
                this.set_Value(parentColumnIDforTree.getColumnName(), (Object)treeNode.get_ValueAsInt("Parent_ID"));
                this.saveEx();
            }
        }
        treeNode.set_CustomColumn("SeqNo", (Object)999);
        treeNode.saveEx();
        return true;
    }

    private boolean updateTreeNode() {
        MColumn columnIDforTree;
        PO treeNode;
        Integer ii;
        int tableId = this.get_Table_ID();
        if (!MTree.hasTree((int)tableId)) {
            return false;
        }
        AtomicReference<String> treeTableName = new AtomicReference<String>();
        AtomicInteger treeId = new AtomicInteger();
        AtomicInteger parentColumnId = new AtomicInteger();
        AtomicInteger sortColumnId = new AtomicInteger();
        int elementId = 0;
        if (tableId == X_C_ElementValue.Table_ID && (ii = (Integer)this.get_Value("C_Element_ID")) != null) {
            elementId = ii;
            MElement element = MElement.get((Properties)this.getCtx(), (int)elementId, (String)this.get_TrxName());
            Optional.ofNullable(element.getTree()).ifPresent(tree -> {
                treeTableName.set(MTree.getNodeTableName((String)tree.getTreeType()));
                treeId.set(element.getAD_Tree_ID());
                parentColumnId.set(tree.getParent_Column_ID());
                sortColumnId.set(tree.getAD_ColumnSortOrder_ID());
            });
        }
        if (treeTableName.get() == null) {
            treeTableName.set(MTree.getNodeTableName((int)tableId));
        }
        if (treeId.get() <= 0) {
            treeId.set(MTree.getDefaultTreeIdFromTableId((int)this.getAD_Client_ID(), (int)tableId, (int)elementId));
        }
        if (treeId.get() <= 0) {
            return false;
        }
        if (treeTableName.get() == null) {
            return false;
        }
        if (elementId <= 0) {
            MTree tree2 = new MTree(this.getCtx(), treeId.get(), this.get_TrxName());
            parentColumnId.set(tree2.getParent_Column_ID());
            sortColumnId.set(tree2.getAD_ColumnSortOrder_ID());
        }
        if ((treeNode = MTable.get((Properties)this.getCtx(), (String)((String)treeTableName.get())).getPO("Node_ID = " + this.get_ID(), this.get_TrxName())) != null && parentColumnId.get() > 0 && this.get_ValueAsInt((columnIDforTree = MColumn.get((Properties)this.getCtx(), (int)parentColumnId.get())).getColumnName()) != treeNode.get_ValueAsInt("Parent_ID")) {
            treeNode.set_CustomColumn("Parent_ID", (Object)this.get_ValueAsInt(columnIDforTree.getColumnName()));
            treeNode.saveEx();
        }
        return true;
    }

    protected boolean deleteTreeNode() {
        int AD_Table_ID;
        int id = this.get_ID();
        if (id == 0) {
            id = this.get_IDOld();
        }
        if (!MTree.hasTree((int)(AD_Table_ID = this.get_Table_ID()))) {
            return false;
        }
        int treeId = MTree.getDefaultTreeIdFromTableId((int)this.getAD_Client_ID(), (int)this.get_Table_ID());
        if (treeId < 0) {
            return false;
        }
        String treeNodeTableName = MTree.getNodeTableName((int)this.get_Table_ID());
        String whereClause = treeNodeTableName + ".Node_ID=" + id + " AND EXISTS (SELECT 1 FROM AD_Tree t WHERE t.AD_Tree_ID=" + treeNodeTableName + ".AD_Tree_ID AND t.AD_Table_ID=" + this.get_Table_ID() + ")";
        PO treeNode = MTable.get((Properties)this.getCtx(), (String)treeNodeTableName).getPO(whereClause, this.get_TrxName());
        if (treeNode != null) {
            treeNode.deleteEx(true);
        }
        return true;
    }

    public boolean lock() {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.TRUE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='Y' WHERE (Processing='N' OR Processing IS NULL) AND " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx((String)sql, null, (int)10) == 1;
            } else {
                boolean bl = success = DB.executeUpdate((String)sql, null) == 1;
            }
            if (success) {
                this.log.fine("success");
            } else {
                this.log.log(Level.WARNING, "failed");
            }
            return success;
        }
        return false;
    }

    private int get_ProcessingIndex() {
        return this.p_info.getColumnIndex("Processing");
    }

    public boolean unlock(String trxName) {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.FALSE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='N' WHERE " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx((String)sql, (String)trxName, (int)10) == 1;
            } else {
                boolean bl = success = DB.executeUpdate((String)sql, (String)trxName) == 1;
            }
            if (success) {
                this.log.fine("success" + (String)(trxName == null ? "" : "[" + trxName + "]"));
            } else {
                this.log.log(Level.WARNING, "failed" + (String)(trxName == null ? "" : " [" + trxName + "]"));
            }
            return success;
        }
        return true;
    }

    public void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public MAttachment getAttachment() {
        return this.getAttachment(false);
    }

    public MAttachment getAttachment(boolean requery) {
        if (this.m_attachment == null || requery) {
            this.m_attachment = MAttachment.get((Properties)this.getCtx(), (int)this.p_info.getAD_Table_ID(), (int)this.get_ID());
        }
        return this.m_attachment;
    }

    public MAttachment createAttachment() {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            this.m_attachment = new MAttachment(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), null);
        }
        return this.m_attachment;
    }

    public boolean isAttachment(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return false;
        }
        for (int i = 0; i < this.m_attachment.getEntryCount(); ++i) {
            if (!this.m_attachment.getEntryName(i).endsWith(extension)) continue;
            this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
            return true;
        }
        return false;
    }

    public byte[] getAttachmentData(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return null;
        }
        for (int i = 0; i < this.m_attachment.getEntryCount(); ++i) {
            if (!this.m_attachment.getEntryName(i).endsWith(extension)) continue;
            this.log.fine("#" + i + ": " + this.m_attachment.getEntryName(i));
            return this.m_attachment.getEntryData(i);
        }
        return null;
    }

    public boolean isPdfAttachment() {
        return this.isAttachment(".pdf");
    }

    public byte[] getPdfAttachment() {
        return this.getAttachmentData(".pdf");
    }

    public void dump() {
        if (CLogMgt.isLevelFinest()) {
            this.log.finer(this.get_WhereClause(true));
            for (int i = 0; i < this.get_ColumnCount(); ++i) {
                this.dump(i);
            }
        }
    }

    public void dump(int index) {
        StringBuffer sb = new StringBuffer(" ").append(index);
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.finest(sb.append(": invalid").toString());
            return;
        }
        sb.append(": ").append(this.get_ColumnName(index)).append(" = ").append(this.m_oldValues[index]).append(" (").append(this.m_newValues[index]).append(")");
        this.log.finest(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getAllIDs(String TableName, String WhereClause, String trxName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(TableName).append("_ID FROM ").append(TableName);
        if (WhereClause != null && WhereClause.length() > 0) {
            sql.append(" WHERE ").append(WhereClause);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            int[] nArray;
            try {
                s_log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                nArray = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return nArray;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        for (int i = 0; i < retValue.length; ++i) {
            retValue[i] = (Integer)list.get(i);
        }
        return retValue;
    }

    protected static String getFindParameter(String query) {
        if (query == null) {
            return null;
        }
        if (((String)query).length() == 0 || ((String)query).equals("%")) {
            return null;
        }
        if (!((String)query).endsWith("%")) {
            query = (String)query + "%";
        }
        return ((String)query).toUpperCase();
    }

    private Object get_LOB(Object value) {
        this.log.fine("Value=" + value);
        if (value == null) {
            return null;
        }
        Object retValue = null;
        long length = -99L;
        try {
            if (value instanceof String || value instanceof byte[]) {
                retValue = value;
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                length = clob.length();
                retValue = clob.getSubString(1L, (int)length);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                length = blob.length();
                int index = 1;
                if (blob.getClass().getName().equals("oracle.jdbc.rowset.OracleSerialBlob")) {
                    index = 0;
                }
                retValue = blob.getBytes(index, (int)length);
            } else {
                this.log.log(Level.SEVERE, "Unknown: " + value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Length=" + length, (Throwable)e);
        }
        return retValue;
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(Object value, int index, int displayType) {
        this.log.finest("Value=" + value);
        PO_LOB lob = new PO_LOB(this.p_info.getTableName(), this.get_ColumnName(index), this.get_WhereClause(true), displayType, value);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private boolean lobSave() {
        if (this.m_lobInfo == null) {
            return true;
        }
        boolean retValue = true;
        for (int i = 0; i < this.m_lobInfo.size(); ++i) {
            PO_LOB lob = (PO_LOB)this.m_lobInfo.get(i);
            if (lob.save(this.get_TrxName())) continue;
            retValue = false;
            break;
        }
        this.lobReset();
        return retValue;
    }

    public StringBuffer get_xmlString(StringBuffer xml) {
        if (xml == null) {
            xml = new StringBuffer();
        } else {
            xml.append(Env.NL);
        }
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.get_xmlDocument(xml.length() != 0));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            StringBuffer newXML = writer.getBuffer();
            if (xml.length() != 0) {
                int tagIndex = newXML.indexOf("?>");
                if (tagIndex != -1) {
                    xml.append(newXML.substring(tagIndex + 2));
                } else {
                    xml.append(newXML);
                }
            } else {
                xml.append(newXML);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        return xml;
    }

    public Document get_xmlDocument(boolean noComment) {
        Object value;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            if (!noComment) {
                document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        Element root = document.createElement(this.get_TableName());
        root.setAttribute("AD_Table_ID", String.valueOf(this.get_Table_ID()));
        root.setAttribute("Record_ID", String.valueOf(this.get_ID()));
        document.appendChild(root);
        int size = this.get_ColumnCount();
        for (int i = 0; i < size; ++i) {
            if (this.p_info.isVirtualColumn(i)) continue;
            Element col = document.createElement(this.p_info.getColumnName(i));
            value = this.get_Value(i);
            int dt = this.p_info.getColumnDisplayType(i);
            Class c = this.p_info.getColumnClass(i);
            if (value != null && !value.equals(Null.NULL)) {
                if (c == Object.class) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else if (value instanceof Integer || value instanceof BigDecimal) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    col.appendChild(document.createTextNode(bValue ? "Y" : "N"));
                } else if (value instanceof Timestamp) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == String.class) {
                    col.appendChild(document.createCDATASection((String)value));
                } else if (DisplayType.isLOB((int)dt)) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else {
                    col.appendChild(document.createCDATASection(value.toString()));
                }
            }
            root.appendChild(col);
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                value = (String)this.m_custom.get(columnName);
                Element col = document.createElement(columnName);
                if (value != null) {
                    col.appendChild(document.createTextNode((String)value));
                }
                root.appendChild(col);
            }
            this.m_custom = null;
        }
        return document;
    }

    public void setDoc(Doc doc) {
        this.m_doc = doc;
    }

    public void setReplication(boolean isFromReplication) {
        this.m_isReplication = isFromReplication;
    }

    public boolean isReplication() {
        return this.m_isReplication;
    }

    public Doc getDoc() {
        return this.m_doc;
    }

    public static void set_TrxName(PO[] lines, String trxName) {
        for (PO line : lines) {
            line.set_TrxName(trxName);
        }
    }

    public int get_ValueAsInt(String columnName) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0) {
            return 0;
        }
        return this.get_ValueAsInt(idx);
    }

    public boolean get_ValueAsBoolean(String columnName) {
        Object oo = this.get_Value(columnName);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        int i;
        PO clone = (PO)super.clone();
        clone.m_trxName = null;
        if (this.m_custom != null) {
            clone.m_custom = new HashMap();
            clone.m_custom.putAll(this.m_custom);
        }
        if (this.m_newValues != null) {
            clone.m_newValues = new Object[this.m_newValues.length];
            for (i = 0; i < this.m_newValues.length; ++i) {
                clone.m_newValues[i] = this.m_newValues[i];
            }
        }
        if (this.m_oldValues != null) {
            clone.m_oldValues = new Object[this.m_oldValues.length];
            for (i = 0; i < this.m_oldValues.length; ++i) {
                clone.m_oldValues[i] = this.m_oldValues[i];
            }
        }
        if (this.m_IDs != null) {
            clone.m_IDs = new Object[this.m_IDs.length];
            for (i = 0; i < this.m_IDs.length; ++i) {
                clone.m_IDs[i] = this.m_IDs[i];
            }
        }
        clone.p_ctx = Env.getCtx();
        clone.m_doc = null;
        clone.m_lobInfo = null;
        clone.m_attachment = null;
        clone.m_isReplication = false;
        return clone;
    }

    private int getParentFromSort(String sortColumn, String sortValue, String whereClause) {
        Integer parentID = 0;
        whereClause = (String)((Object)Optional.ofNullable(whereClause + " AND ").orElse((CallSite)((Object)"")));
        if (sortValue != null) {
            List parentPO = new Query(this.getCtx(), this.get_TableName(), whereClause + " IsSummary = 'Y' ", this.get_TrxName()).setOrderBy(sortColumn).list();
            HashMap<String, Integer> currentValues = new HashMap<String, Integer>();
            for (PO po : parentPO) {
                currentValues.put(po.get_ValueAsString(sortColumn), po.get_ID());
            }
            while (sortValue.length() > 0 && (parentID = (Integer)currentValues.get(sortValue = sortValue.substring(0, sortValue.length() - 1))) == null) {
                parentID = 0;
            }
        }
        return parentID;
    }
}

