/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.crosstabs.fill.BucketOrderer;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketValueOrderDecorator;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingData;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrosstabBucketingService
extends BucketingService
implements BucketingData {
    private static final Log log = LogFactory.getLog(CrosstabBucketingService.class);
    public static final String EXCEPTION_MESSAGE_KEY_DATA_NOT_PROCESSED = "crosstabs.calculation.data.not.processed";
    protected HeaderCell[][] colHeaders;
    protected HeaderCell[][] rowHeaders;
    protected CrosstabCell[][] cells;

    public CrosstabBucketingService(BucketingServiceContext serviceContext, List<BucketDefinition> rowBuckets, List<BucketDefinition> columnBuckets, List<MeasureDefinition> measures, boolean sorted, boolean[][] retrieveTotal) {
        super(serviceContext, rowBuckets, columnBuckets, measures, sorted, retrieveTotal);
    }

    public void createCrosstab() throws JRException {
        if (!this.processed) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DATA_NOT_PROCESSED, (Object[])null);
        }
        if (!this.hasData()) {
            return;
        }
        CollectedList[] collectedHeaders = new CollectedList[2];
        collectedHeaders[0] = this.createHeadersList((byte)0, this.bucketValueMap, 0, false);
        BucketingService.BucketMap columnTotalsMap = null;
        if (this.allBuckets[0].computeTotal()) {
            columnTotalsMap = this.bucketValueMap;
            for (int i = 0; i < this.rowBucketCount; ++i) {
                columnTotalsMap = (BucketingService.BucketMap)columnTotalsMap.getTotalEntry().getValue();
            }
        }
        collectedHeaders[1] = this.createHeadersList((byte)1, columnTotalsMap == null ? this.columnBucketMap : columnTotalsMap, 0, false);
        int rowBuckets = collectedHeaders[0].span;
        int colBuckets = collectedHeaders[1].span;
        int bucketMeasureCount = rowBuckets * colBuckets * this.origMeasureCount;
        if (log.isDebugEnabled()) {
            log.debug("crosstab has " + rowBuckets + " row buckets, " + colBuckets + " column buckets and " + this.origMeasureCount + " measures");
            log.debug("bucket measure count is " + bucketMeasureCount + ", limit " + this.bucketMeasureLimit);
        }
        this.checkBucketMeasureCount(bucketMeasureCount);
        this.colHeaders = this.createHeaders((byte)1, collectedHeaders, columnTotalsMap);
        this.rowHeaders = this.createHeaders((byte)0, collectedHeaders, this.bucketValueMap);
        this.cells = new CrosstabCell[rowBuckets][colBuckets];
        this.fillCells(collectedHeaders, this.bucketValueMap, 0, new int[]{0, 0}, new ArrayList<BucketDefinition.Bucket>(), new ArrayList<BucketingService.BucketMap>());
    }

    protected HeaderCell[][] createHeaders(byte dimension, CollectedList[] headersLists, BucketingService.BucketMap totalsMap) {
        HeaderCell[][] headers = new HeaderCell[this.buckets[dimension].length][headersLists[dimension].span];
        ArrayList<BucketDefinition.Bucket> vals = new ArrayList<BucketDefinition.Bucket>();
        this.fillHeaders(dimension, headers, 0, 0, headersLists[dimension], vals, totalsMap);
        return headers;
    }

    protected CollectedList createHeadersList(byte dimension, BucketingService.BucketMap bucketMap, int level, boolean total) throws JRException {
        CollectedList headers;
        BucketDefinition bucketDefinition = this.allBuckets[bucketMap.level];
        CrosstabTotalPositionEnum totalPosition = bucketDefinition.getTotalPosition();
        BucketOrderer bucketOrderer = bucketDefinition.getOrderer();
        if (bucketOrderer != null) {
            headers = new OrderedCollectedList(bucketDefinition);
            bucketOrderer.init(this);
        } else {
            headers = new SequentialCollectedList(totalPosition);
        }
        Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
        while (it.hasNext()) {
            CollectedList nextHeaders;
            Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
            BucketDefinition.Bucket bucketValue = entry.getKey();
            boolean totalBucket = bucketValue.isTotal();
            boolean createHeader = !totalBucket || total || totalPosition != CrosstabTotalPositionEnum.NONE;
            if (!createHeader) continue;
            if (level + 1 < this.buckets[dimension].length) {
                BucketingService.BucketMap nextMap = (BucketingService.BucketMap)entry.getValue();
                nextHeaders = this.createHeadersList(dimension, nextMap, level + 1, total || totalBucket);
            } else {
                nextHeaders = new SequentialCollectedList(CrosstabTotalPositionEnum.NONE);
                nextHeaders.span = 1;
            }
            nextHeaders.key = bucketValue;
            if (bucketOrderer != null) {
                Object orderValue;
                nextHeaders.orderValue = orderValue = bucketOrderer.getOrderValue(bucketMap, bucketValue);
            }
            headers.add(nextHeaders);
        }
        if (headers.span == 0) {
            headers.span = 1;
        }
        return headers;
    }

    @Override
    public MeasureDefinition.MeasureValue[] getMeasureTotals(BucketingService.BucketMap bucketMap, BucketDefinition.Bucket bucket) {
        Object bucketValue = bucketMap.get(bucket);
        for (int idx = bucketMap.level + 1; idx < this.rowBucketCount + this.colBucketCount; ++idx) {
            bucketValue = ((BucketingService.BucketMap)bucketValue).getTotalEntry().getValue();
        }
        MeasureDefinition.MeasureValue[] totals = (MeasureDefinition.MeasureValue[])bucketValue;
        MeasureDefinition.MeasureValue[] userTotals = this.getUserMeasureValues(totals);
        return userTotals;
    }

    protected void fillHeaders(byte dimension, HeaderCell[][] headers, int level, int col, CollectedList list, List<BucketDefinition.Bucket> vals, BucketingService.BucketMap totalsMap) {
        if (level == this.buckets[dimension].length) {
            return;
        }
        Iterator<CollectedList> it = list.iterator();
        while (it.hasNext()) {
            CollectedList subList = it.next();
            vals.add(subList.key);
            if (!subList.key.isTotal()) {
                this.fillHeaders(dimension, headers, level + 1, col, subList, vals, totalsMap);
            }
            int depthSpan = subList.key.isTotal() ? this.buckets[dimension].length - level : 1;
            BucketDefinition.Bucket[] values = new BucketDefinition.Bucket[this.buckets[dimension].length];
            vals.toArray(values);
            MeasureDefinition.MeasureValue[][] totals = this.retrieveHeaderTotals(dimension, values, totalsMap);
            if (subList.key.isTotal() || this.buckets[dimension][level].isMergeHeaderCells() || level >= this.buckets[dimension].length - 1) {
                headers[level][col] = new HeaderCell(values, subList.span, depthSpan, totals);
            } else {
                for (int c = col; c < col + subList.span; ++c) {
                    HeaderCell subheader = headers[level + 1][c];
                    if (subheader == null) continue;
                    headers[level][c] = new HeaderCell(values, subheader.getLevelSpan(), depthSpan, totals);
                }
            }
            col += subList.span;
            vals.remove(vals.size() - 1);
        }
    }

    protected MeasureDefinition.MeasureValue[][] retrieveHeaderTotals(byte dimension, BucketDefinition.Bucket[] values, BucketingService.BucketMap totalsMap) {
        int idx;
        int levelCount = this.buckets[dimension].length;
        Object[] levelBuckets = new Object[levelCount + 1];
        levelBuckets[0] = totalsMap;
        for (idx = 0; idx < levelCount; ++idx) {
            Object valueBucket = levelBuckets[idx];
            for (int lIdx = 0; lIdx <= idx; ++lIdx) {
                if (levelBuckets[lIdx] == null) continue;
                BucketingService.MapEntry entry = ((BucketingService.BucketMap)levelBuckets[lIdx]).getTotalEntry();
                levelBuckets[lIdx] = entry == null ? null : entry.getValue();
            }
            if (valueBucket == null) continue;
            levelBuckets[idx + 1] = idx < values.length && values[idx] != null ? ((BucketingService.BucketMap)valueBucket).get(values[idx]) : levelBuckets[idx];
        }
        if (dimension == 0) {
            for (idx = 0; idx < this.colBucketCount; ++idx) {
                for (int lIdx = 0; lIdx <= levelCount; ++lIdx) {
                    if (levelBuckets[lIdx] == null) continue;
                    BucketingService.MapEntry entry = ((BucketingService.BucketMap)levelBuckets[lIdx]).getTotalEntry();
                    levelBuckets[lIdx] = entry == null ? null : entry.getValue();
                }
            }
        }
        MeasureDefinition.MeasureValue[][] totals = new MeasureDefinition.MeasureValue[levelCount + 1][];
        for (int lIdx = 0; lIdx <= levelCount; ++lIdx) {
            MeasureDefinition.MeasureValue[] measureValues = (MeasureDefinition.MeasureValue[])levelBuckets[lIdx];
            if (measureValues == null) continue;
            totals[lIdx] = this.getUserMeasureValues(measureValues);
        }
        return totals;
    }

    protected void fillCells(CollectedList[] collectedHeaders, BucketingService.BucketMap bucketMap, int level, int[] pos, List<BucketDefinition.Bucket> vals, List<BucketingService.BucketMap> bucketMaps) {
        bucketMaps.add(bucketMap);
        int dimension = level < this.rowBucketCount ? 0 : 1;
        boolean last = level == this.allBuckets.length - 1;
        CollectedList[] nextCollected = null;
        if (!last) {
            nextCollected = new CollectedList[2];
            for (int d = 0; d < 2; ++d) {
                if (d == dimension) continue;
                nextCollected[d] = collectedHeaders[d];
            }
        }
        boolean incrementRow = level == this.buckets[0].length - 1;
        CollectedList collectedList = collectedHeaders[dimension];
        Iterator<CollectedList> it = collectedList.iterator();
        while (it.hasNext()) {
            CollectedList list = it.next();
            Object bucketValue = bucketMap == null ? null : bucketMap.get(list.key);
            vals.add(list.key);
            if (last) {
                this.fillCell(pos, vals, bucketMaps, (MeasureDefinition.MeasureValue[])bucketValue);
            } else {
                nextCollected[dimension] = list;
                BucketingService.BucketMap nextMap = bucketValue == null ? null : (BucketingService.BucketMap)bucketValue;
                this.fillCells(nextCollected, nextMap, level + 1, pos, vals, bucketMaps);
            }
            vals.remove(vals.size() - 1);
            if (!incrementRow) continue;
            pos[0] = pos[0] + 1;
            pos[1] = 0;
        }
        bucketMaps.remove(bucketMaps.size() - 1);
    }

    protected void fillCell(int[] pos, List<BucketDefinition.Bucket> vals, List<BucketingService.BucketMap> bucketMaps, MeasureDefinition.MeasureValue[] values) {
        Iterator<BucketDefinition.Bucket> valsIt = vals.iterator();
        BucketDefinition.Bucket[] rowValues = new BucketDefinition.Bucket[this.buckets[0].length];
        for (int i = 0; i < rowValues.length; ++i) {
            rowValues[i] = valsIt.next();
        }
        BucketDefinition.Bucket[] columnValues = new BucketDefinition.Bucket[this.buckets[1].length];
        for (int i = 0; i < columnValues.length; ++i) {
            columnValues[i] = valsIt.next();
        }
        MeasureDefinition.MeasureValue[] measureVals = values == null ? this.zeroUserMeasureValues : this.getUserMeasureValues(values);
        MeasureDefinition.MeasureValue[][][] totals = this.retrieveTotals(vals, bucketMaps);
        this.cells[pos[0]][pos[1]] = new CrosstabCell(rowValues, columnValues, measureVals, totals);
        pos[1] = pos[1] + 1;
    }

    protected MeasureDefinition.MeasureValue[][][] retrieveTotals(List<BucketDefinition.Bucket> vals, List<BucketingService.BucketMap> bucketMaps) {
        MeasureDefinition.MeasureValue[][][] totals = new MeasureDefinition.MeasureValue[this.rowBucketCount + 1][this.colBucketCount + 1][];
        for (int row = this.rowRetrTotalMax; row >= this.rowRetrTotalMin; --row) {
            if (!this.rowRetrTotals[row]) continue;
            BucketingService.BucketMap rowMap = bucketMaps.get(row);
            for (int i = row; rowMap != null && i < this.rowBucketCount; ++i) {
                BucketingService.MapEntry totalEntry = rowMap.getTotalEntry();
                rowMap = totalEntry == null ? null : (BucketingService.BucketMap)totalEntry.getValue();
            }
            for (int col = 0; col <= this.rowRetrColMax[row]; ++col) {
                BucketingService.BucketMap colMap = rowMap;
                if (col < this.colBucketCount - 1) {
                    if (row == this.rowBucketCount) {
                        rowMap = bucketMaps.get(this.rowBucketCount + col + 1);
                    } else if (rowMap != null) {
                        rowMap = (BucketingService.BucketMap)rowMap.get(vals.get(this.rowBucketCount + col));
                    }
                }
                if (!this.retrieveTotal[row][col]) continue;
                for (int i = col + 1; colMap != null && i < this.colBucketCount; ++i) {
                    colMap = (BucketingService.BucketMap)colMap.getTotalEntry().getValue();
                }
                if (colMap != null) {
                    if (col == this.colBucketCount) {
                        MeasureDefinition.MeasureValue[] measureValues = (MeasureDefinition.MeasureValue[])colMap.get(vals.get(this.rowBucketCount + this.colBucketCount - 1));
                        if (measureValues != null) {
                            totals[row][col] = this.getUserMeasureValues(measureValues);
                        }
                    } else {
                        BucketingService.MapEntry totalEntry = colMap.getTotalEntry();
                        if (totalEntry != null) {
                            MeasureDefinition.MeasureValue[] totalValues = (MeasureDefinition.MeasureValue[])totalEntry.getValue();
                            totals[row][col] = this.getUserMeasureValues(totalValues);
                        }
                    }
                }
                if (totals[row][col] != null) continue;
                totals[row][col] = this.zeroUserMeasureValues;
            }
        }
        return totals;
    }

    public HeaderCell[][] getColumnHeaders() {
        return this.colHeaders;
    }

    public HeaderCell[][] getRowHeaders() {
        return this.rowHeaders;
    }

    public CrosstabCell[][] getCrosstabCells() {
        return this.cells;
    }

    @Override
    public BucketingServiceContext getServiceContext() {
        return this.serviceContext;
    }

    @Override
    public BucketDefinition.Bucket getColumnTotalBucket(int columnGroupIndex) {
        if (columnGroupIndex < 0 || columnGroupIndex >= this.colBucketCount) {
            throw new IndexOutOfBoundsException("Column group index " + columnGroupIndex + " out of range, column group count is " + this.colBucketCount);
        }
        return this.allBuckets[this.rowBucketCount + columnGroupIndex].VALUE_TOTAL;
    }

    @Override
    public BucketDefinition.Bucket getColumnBucket(int columnGroupIndex, Object value) {
        if (columnGroupIndex < 0 || columnGroupIndex >= this.colBucketCount) {
            throw new IndexOutOfBoundsException("Column group index " + columnGroupIndex + " out of range, column group count is " + this.colBucketCount);
        }
        BucketDefinition bucket = this.allBuckets[this.rowBucketCount + columnGroupIndex];
        return value == null ? bucket.VALUE_NULL : bucket.create(value);
    }

    @Override
    public MeasureDefinition.MeasureValue[] getMeasureValues(BucketingService.BucketMap bucketMap, BucketDefinition.Bucket bucket, List<BucketDefinition.Bucket> columnValues) {
        Object bucketValue = bucketMap.get(bucket);
        for (int idx = bucketMap.level + 1; idx < this.rowBucketCount; ++idx) {
            bucketValue = ((BucketingService.BucketMap)bucketValue).getTotalEntry().getValue();
        }
        Iterator<BucketDefinition.Bucket> colValuesIt = columnValues.iterator();
        for (int idx = 0; idx < this.colBucketCount && bucketValue != null; ++idx) {
            if (colValuesIt.hasNext()) {
                BucketDefinition.Bucket columnBucket = colValuesIt.next();
                bucketValue = ((BucketingService.BucketMap)bucketValue).get(columnBucket);
                continue;
            }
            bucketValue = ((BucketingService.BucketMap)bucketValue).getTotalEntry().getValue();
        }
        MeasureDefinition.MeasureValue[] measureValues = bucketValue == null ? this.zeroUserMeasureValues : this.getUserMeasureValues((MeasureDefinition.MeasureValue[])bucketValue);
        return measureValues;
    }

    protected static class CollectedListComparator
    implements Comparator<CollectedList> {
        final String EXCEPTION_MESSAGE_KEY_TWO_TOTAL_KEYS_IN_SAME_LIST = "crosstabs.calculation.two.total.keys.in.same.list";
        final BucketOrderer bucketOrderer;
        final boolean totalFirst;

        CollectedListComparator(BucketDefinition bucketDefinition) {
            this.bucketOrderer = bucketDefinition.getOrderer();
            this.totalFirst = bucketDefinition.getTotalPosition() == CrosstabTotalPositionEnum.START;
        }

        @Override
        public int compare(CollectedList l1, CollectedList l2) {
            int order;
            if (l1 == l2) {
                return 0;
            }
            if (l1.key.isTotal()) {
                if (l2.key.isTotal()) {
                    throw new JRRuntimeException("crosstabs.calculation.two.total.keys.in.same.list", (Object[])null);
                }
                order = this.totalFirst ? -1 : 1;
            } else if (l2.key.isTotal()) {
                order = this.totalFirst ? 1 : -1;
            } else {
                BucketValueOrderDecorator.OrderPosition orderPosition2;
                BucketValueOrderDecorator.OrderPosition orderPosition1 = l1.key.getOrderPosition();
                if (orderPosition1 != (orderPosition2 = l2.key.getOrderPosition())) {
                    order = orderPosition1.comparePosition(orderPosition2);
                } else {
                    order = this.bucketOrderer.compareOrderValues(l1.orderValue, l2.orderValue);
                    if (order == 0) {
                        order = l1.key.compareTo(l2.key);
                    }
                }
            }
            return order;
        }
    }

    protected static class OrderedCollectedList
    extends CollectedList {
        final TreeSet<CollectedList> list;

        OrderedCollectedList(BucketDefinition bucketDefinition) {
            CollectedListComparator comparator = new CollectedListComparator(bucketDefinition);
            this.list = new TreeSet<CollectedList>(comparator);
        }

        @Override
        public Iterator<CollectedList> iterator() {
            return this.list.iterator();
        }

        @Override
        protected void addSublist(CollectedList sublist) {
            this.list.add(sublist);
        }
    }

    protected static class SequentialCollectedList
    extends CollectedList {
        final CrosstabTotalPositionEnum totalPosition;
        final LinkedList<CollectedList> list;

        SequentialCollectedList(CrosstabTotalPositionEnum totalPosition) {
            this.totalPosition = totalPosition;
            this.list = new LinkedList();
        }

        @Override
        public Iterator<CollectedList> iterator() {
            return this.list.iterator();
        }

        @Override
        protected void addSublist(CollectedList sublist) {
            if (sublist.key.isTotal() && this.totalPosition == CrosstabTotalPositionEnum.START) {
                this.list.addFirst(sublist);
            } else {
                this.list.add(sublist);
            }
        }
    }

    protected static abstract class CollectedList {
        int span = 0;
        BucketDefinition.Bucket key;
        Object orderValue;

        CollectedList() {
        }

        public abstract Iterator<CollectedList> iterator();

        public void add(CollectedList sublist) {
            this.addSublist(sublist);
            this.incrementSpan(sublist);
        }

        protected abstract void addSublist(CollectedList var1);

        private void incrementSpan(CollectedList sublist) {
            this.span = sublist != null ? (this.span += sublist.span) : ++this.span;
        }

        public String toString() {
            return this.key + "/" + this.span + ": " + super.toString();
        }
    }
}

