/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.fill.calculation.OrderByColumnInfo;
import net.sf.jasperreports.crosstabs.interactive.CrosstabOrderAttributes;
import net.sf.jasperreports.crosstabs.interactive.SortByColumnData;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.util.JacksonUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortByColumnCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(SortByColumnCommand.class);
    private final JasperReportsContext jasperReportsContext;
    private final JRDesignCrosstab crosstab;
    private final SortByColumnData sortData;
    private final JRCrosstabRowGroup lastRowGroup;
    private CrosstabOrderAttributes oldOrderAttributes;
    private String newOrderBy;

    public SortByColumnCommand(JasperReportsContext jasperReportsContext, JRDesignCrosstab crosstab, SortByColumnData sortData) {
        this.jasperReportsContext = jasperReportsContext;
        this.crosstab = crosstab;
        this.sortData = sortData;
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        this.lastRowGroup = rowGroups[rowGroups.length - 1];
    }

    @Override
    public void execute() throws CommandException {
        this.oldOrderAttributes = new CrosstabOrderAttributes(this.crosstab);
        BucketOrder order = this.sortData.getOrder();
        if (order == BucketOrder.NONE) {
            this.newOrderBy = null;
        } else {
            OrderByColumnInfo orderByInfo = new OrderByColumnInfo();
            orderByInfo.setMeasureIndex(this.sortData.getMeasureIndex());
            orderByInfo.setOrder(BucketOrder.toSortOrderEnum(order));
            orderByInfo.setColumnValues(this.sortData.getColumnValues());
            this.newOrderBy = JacksonUtil.getInstance(this.jasperReportsContext).getJsonString(orderByInfo);
        }
        this.setOrder();
    }

    protected void setOrder() {
        this.oldOrderAttributes.prepareSorting();
        if (log.isDebugEnabled()) {
            log.debug("setting crosstab " + this.sortData.getCrosstabId() + " order by to " + this.newOrderBy);
        }
        if (this.newOrderBy == null) {
            this.crosstab.getPropertiesMap().removeProperty("net.sf.jasperreports.crosstab.order.by.column");
        } else {
            this.crosstab.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.order.by.column", this.newOrderBy);
            ((JRDesignCrosstabBucket)this.lastRowGroup.getBucket()).setOrder(BucketOrder.NONE);
        }
    }

    @Override
    public void undo() {
        this.oldOrderAttributes.restore();
    }

    @Override
    public void redo() {
        this.setOrder();
    }
}

