/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.web.util.RequirejsConfigContributor;
import net.sf.jasperreports.web.util.WebRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequirejsConfigContributorSwitchDecorator
implements RequirejsConfigContributor {
    private static final Log log = LogFactory.getLog(RequirejsConfigContributorSwitchDecorator.class);
    private boolean defaultEnabled;
    private String propertyName;
    private RequirejsConfigContributor contributor;

    @Override
    public void contribute(WebRequestContext context, ObjectNode config) {
        boolean enabled = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getBooleanProperty(this.propertyName, this.defaultEnabled);
        if (log.isDebugEnabled()) {
            log.debug("switch for " + this.propertyName + " is " + enabled);
        }
        if (enabled) {
            this.contributor.contribute(context, config);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public RequirejsConfigContributor getContributor() {
        return this.contributor;
    }

    public void setContributor(RequirejsConfigContributor contributor) {
        this.contributor = contributor;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public void setDefaultEnabled(boolean defaultEnabled) {
        this.defaultEnabled = defaultEnabled;
    }
}

