/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.I_C_ElementValue;
import org.adempiere.core.domains.models.I_T_InvoiceGL;
import org.adempiere.core.domains.models.X_T_InvoiceGL;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.GenerateNotRealizedGainLossAbstract;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MElementValue;
import org.compiere.model.MFactAcct;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class GenerateNotRealizedGainLoss
extends GenerateNotRealizedGainLossAbstract {
    private final List<X_T_InvoiceGL> exchangeGainLossList = new ArrayList<X_T_InvoiceGL>();
    private final HashMap<Integer, MJournalBatch> journalBatches = new HashMap();
    private final HashMap<String, MJournal> journals = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() {
        this.cleanTemporaryTable();
        this.getAccountsForeignCurrency().forEach(i_C_ElementValue -> this.getAccountingSchemes().forEach(mAcctSchema -> this.getAccountRecords((MAcctSchema)mAcctSchema, (I_C_ElementValue)i_C_ElementValue).forEach(n -> Trx.run(string -> this.createExchangeGainLossReport((MAcctSchema)mAcctSchema, (Integer)n, string)))));
        if ("Y".equals(this.getIsCreateNewJournal())) {
            if (this.getDocTypeRevalId() <= 0) {
                throw new AdempiereException("@C_ConversionTypeReval_ID@ @NotFound@");
            }
            Trx.run(this::ExchangeGainLoss);
        }
        return "@Ok@";
    }

    private void ExchangeGainLoss(String string) {
        AtomicInteger atomicInteger = new AtomicInteger(10);
        this.exchangeGainLossList.stream().collect(Collectors.groupingBy(X_T_InvoiceGL::getC_AcctSchema_ID, Collectors.groupingBy(PO::getAD_Org_ID, Collectors.groupingBy(X_T_InvoiceGL::getAccount_ID)))).entrySet().forEach(entry -> ((Map)entry.getValue()).entrySet().forEach(entry2 -> ((Map)entry2.getValue()).entrySet().stream().map(entry3 -> {
            MElementValue mElementValue = new MElementValue(this.getCtx(), ((Integer)entry3.getKey()).intValue(), this.get_TrxName());
            MCurrency mCurrency = MCurrency.get((Properties)this.getCtx(), (int)mElementValue.getC_Currency_ID());
            BigDecimal bigDecimal = ((List)entry3.getValue()).stream().map(I_T_InvoiceGL::getAmtAcctBalance).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(mCurrency.getStdPrecision(), 4);
            BigDecimal bigDecimal2 = ((List)entry3.getValue()).stream().filter(x_T_InvoiceGL -> x_T_InvoiceGL.getC_Currency_ID() == mCurrency.getC_Currency_ID()).map(I_T_InvoiceGL::getAmtSourceBalance).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(mCurrency.getStdPrecision(), 4);
            BigDecimal bigDecimal3 = ((List)entry3.getValue()).stream().filter(x_T_InvoiceGL -> x_T_InvoiceGL.getC_Currency_ID() == mCurrency.getC_Currency_ID()).map(I_T_InvoiceGL::getAmtRevalDrDiff).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(mCurrency.getStdPrecision(), 4);
            BigDecimal bigDecimal4 = ((List)entry3.getValue()).stream().filter(x_T_InvoiceGL -> x_T_InvoiceGL.getC_Currency_ID() == mCurrency.getC_Currency_ID()).map(I_T_InvoiceGL::getAmtRevalCrDiff).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(mCurrency.getStdPrecision(), 4);
            AccountBalance accountBalance = new AccountBalance();
            accountBalance.companyId = this.getAD_Client_ID();
            accountBalance.organizationId = (Integer)entry.getKey();
            accountBalance.accountSchemaId = (Integer)entry2.getKey();
            accountBalance.accountId = mElementValue.get_ID();
            accountBalance.accountName = mElementValue.getName();
            accountBalance.currencyId = mElementValue.getC_Currency_ID();
            accountBalance.sourceBalance = bigDecimal2;
            accountBalance.accountBalance = bigDecimal;
            accountBalance.debit = bigDecimal3;
            accountBalance.credit = bigDecimal4;
            return accountBalance;
        }).collect(Collectors.toList()).stream().filter(accountBalance -> accountBalance.debit.subtract(accountBalance.credit).signum() != 0).forEach(accountBalance -> {
            MAcctSchema mAcctSchema = MAcctSchema.get((Properties)this.getCtx(), (int)((Integer)entry2.getKey()));
            MCurrency mCurrency = MCurrency.get((Properties)Env.getCtx(), (int)accountBalance.currencyId);
            MJournalBatch mJournalBatch = this.CreateJournalBatch(mAcctSchema, string);
            MJournal mJournal = this.CreateJournal(mJournalBatch, mAcctSchema, mCurrency, accountBalance.organizationId);
            BigDecimal bigDecimal = MConversionRate.getRate((int)accountBalance.currencyId, (int)mAcctSchema.getC_Currency_ID(), (Timestamp)this.getDateReval(), (int)this.getConversionTypeRevalId(), (int)accountBalance.companyId, (int)accountBalance.organizationId);
            this.CreateJournalLine(mJournal, mAcctSchema, (AccountBalance)accountBalance, mCurrency, bigDecimal, atomicInteger);
        })));
    }

    private MJournalBatch CreateJournalBatch(MAcctSchema mAcctSchema, String string2) {
        if (this.journalBatches.containsKey(mAcctSchema.get_ID())) {
            return this.journalBatches.get(mAcctSchema.get_ID());
        }
        MJournalBatch mJournalBatch = new MJournalBatch(this.getCtx(), 0, string2);
        StringBuilder stringBuilder = new StringBuilder();
        Optional.ofNullable(this.getBatchDescription()).ifPresent(string -> stringBuilder.append((String)string).append(" "));
        stringBuilder.append(this.getName()).append(" @DateAcct@ ").append(this.getDateReval());
        mJournalBatch.setDateAcct(this.getDateReval());
        mJournalBatch.setDateDoc(this.getDateReval());
        mJournalBatch.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
        mJournalBatch.setC_DocType_ID(this.getDocTypeRevalId());
        mJournalBatch.setDateAcct(this.getDateReval());
        mJournalBatch.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
        mJournalBatch.saveEx();
        this.journalBatches.put(mAcctSchema.get_ID(), mJournalBatch);
        return mJournalBatch;
    }

    private MJournal CreateJournal(MJournalBatch mJournalBatch, MAcctSchema mAcctSchema, MCurrency mCurrency, Integer n) {
        String string = n + "+" + mCurrency.get_ID();
        if (this.journals.containsKey(string)) {
            return this.journals.get(string);
        }
        MDocType mDocType = MDocType.get((Properties)this.getCtx(), (int)this.getDocTypeRevalId());
        Integer n2 = Optional.ofNullable(MGLCategory.getDefaultSystem((Properties)this.getCtx()).get_ID()).orElse(mDocType.getGL_Category_ID());
        MJournal mJournal = new MJournal(mJournalBatch);
        mJournal.setDateAcct(this.getDateReval());
        mJournal.setDateDoc(this.getDateReval());
        mJournal.setC_AcctSchema_ID(mAcctSchema.get_ID());
        mJournal.setAD_Org_ID(n.intValue());
        mJournal.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
        mJournal.setC_ConversionType_ID(this.getConversionTypeRevalId());
        mJournal.setGL_Category_ID(n2.intValue());
        mJournal.setGL_JournalBatch_ID(mJournalBatch.getGL_JournalBatch_ID());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@C_AcctSchema_ID@ ").append(mAcctSchema.getName()).append(" @C_Currency_ID@ ").append(mCurrency.getISO_Code());
        mJournal.setDescription(Msg.parseTranslation((Properties)Env.getCtx(), (String)stringBuilder.toString()));
        mJournal.saveEx();
        this.journals.put(string, mJournal);
        return mJournal;
    }

    private void CreateJournalLine(MJournal mJournal, MAcctSchema mAcctSchema, AccountBalance accountBalance, MCurrency mCurrency, BigDecimal bigDecimal, AtomicInteger atomicInteger) {
        MJournalLine mJournalLine = new MJournalLine(mJournal);
        mJournalLine.setLine(atomicInteger.getAndUpdate(n -> n + 10));
        mJournalLine.setAccount_ID(accountBalance.accountId.intValue());
        BigDecimal bigDecimal2 = accountBalance.sourceBalance.multiply(bigDecimal).subtract(accountBalance.accountBalance).setScale(mCurrency.getStdPrecision(), 4);
        BigDecimal bigDecimal3 = accountBalance.accountBalance.add(bigDecimal2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@Account_ID@ ").append(accountBalance.accountName).append(" @C_Currency_ID@ ").append(mCurrency.getISO_Code()).append(" ").append(accountBalance.sourceBalance.toString()).append(" @C_Currency_ID@ ").append(mAcctSchema.getC_Currency().getISO_Code()).append(" ").append(accountBalance.accountBalance.toString()).append(" @C_Conversion_Rate_ID@ ").append(Optional.of(bigDecimal.toString()).orElse(" @NotFound@ "));
        if (bigDecimal2.signum() > 0) {
            mJournalLine.setAmtSourceDr(bigDecimal2.abs());
            mJournalLine.setAmtAcctDr(bigDecimal2.abs());
            mJournalLine.setAmtSourceCr(BigDecimal.ZERO);
            mJournalLine.setAmtAcctCr(BigDecimal.ZERO);
            stringBuilder.append(" @UnrealizedGain_Acct@ ").append(bigDecimal2).append(" ").append(bigDecimal3);
        } else {
            mJournalLine.setAmtSourceDr(BigDecimal.ZERO);
            mJournalLine.setAmtAcctDr(BigDecimal.ZERO);
            mJournalLine.setAmtSourceCr(bigDecimal2.abs());
            mJournalLine.setAmtAcctCr(bigDecimal2.abs());
            stringBuilder.append(" @UnrealizedLoss_Acct@ ").append(bigDecimal2).append(" ").append(bigDecimal3);
        }
        mJournalLine.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
        mJournalLine.saveEx();
        MAcctSchemaDefault mAcctSchemaDefault = Optional.ofNullable(MAcctSchemaDefault.get((Properties)this.getCtx(), (int)mAcctSchema.getC_AcctSchema_ID())).orElseThrow(() -> new AdempiereException("@C_AcctSchema_Default@ @NotFound@"));
        this.createExchangeGainLoss(mAcctSchemaDefault, mJournal, mJournalLine, atomicInteger);
    }

    private void createExchangeGainLoss(MAcctSchemaDefault mAcctSchemaDefault, MJournal mJournal, MJournalLine mJournalLine, AtomicInteger atomicInteger) {
        if (mJournalLine.getAmtAcctDr().compareTo(mJournalLine.getAmtAcctCr()) > 0) {
            MJournalLine mJournalLine2 = new MJournalLine(mJournal);
            mJournalLine2.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine2.setDescription(mJournalLine.getDescription());
            mJournalLine2.setC_ValidCombination_ID(this.getUnrealizedGainLoss(mAcctSchemaDefault.getUnrealizedGain_Acct(), mJournalLine));
            BigDecimal bigDecimal = mJournalLine.getAmtAcctDr().subtract(mJournalLine.getAmtAcctCr());
            mJournalLine2.setAmtSourceCr(bigDecimal.abs());
            mJournalLine2.setAmtAcctCr(bigDecimal.abs());
            mJournalLine2.saveEx();
        } else if (mJournalLine.getAmtAcctCr().compareTo(mJournalLine.getAmtAcctDr()) > 0) {
            MJournalLine mJournalLine3 = new MJournalLine(mJournal);
            mJournalLine3.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine3.setDescription(mJournalLine.getDescription());
            mJournalLine3.setC_ValidCombination_ID(this.getUnrealizedGainLoss(mAcctSchemaDefault.getRealizedLoss_Acct(), mJournalLine));
            BigDecimal bigDecimal = mJournalLine.getAmtAcctDr().subtract(mJournalLine.getAmtAcctCr());
            mJournalLine3.setAmtSourceDr(bigDecimal.abs());
            mJournalLine3.setAmtAcctDr(bigDecimal.abs());
            mJournalLine3.saveEx();
        }
    }

    private void createExchangeGainLossReport(MAcctSchema mAcctSchema, Integer n, String string) {
        MFactAcct mFactAcct = new MFactAcct(this.getCtx(), n.intValue(), string);
        if (mFactAcct.getAmtAcctDr().subtract(mFactAcct.getAmtAcctCr()).signum() == 0) {
            return;
        }
        X_T_InvoiceGL x_T_InvoiceGL = new X_T_InvoiceGL(this.getCtx(), 0, string);
        x_T_InvoiceGL.setAD_PInstance_ID(this.getAD_PInstance_ID());
        x_T_InvoiceGL.setAD_Org_ID(mFactAcct.getAD_Org_ID());
        x_T_InvoiceGL.setC_AcctSchema_ID(mAcctSchema.get_ID());
        x_T_InvoiceGL.setDateReval(this.getDateReval());
        x_T_InvoiceGL.setC_ConversionTypeReval_ID(this.getConversionTypeRevalId());
        x_T_InvoiceGL.setC_DocTypeReval_ID(this.getDocTypeRevalId());
        x_T_InvoiceGL.setAccount_ID(mFactAcct.getAccount_ID());
        x_T_InvoiceGL.setC_Currency_ID(mFactAcct.getC_Currency_ID());
        x_T_InvoiceGL.setFact_Acct_ID(mFactAcct.getFact_Acct_ID());
        x_T_InvoiceGL.setAPAR("A");
        x_T_InvoiceGL.setAD_Table_ID(mFactAcct.getAD_Table_ID());
        x_T_InvoiceGL.setRecord_ID(mFactAcct.getRecord_ID());
        x_T_InvoiceGL.setAmtSourceBalance(mFactAcct.getAmtSourceDr().subtract(mFactAcct.getAmtSourceCr()));
        x_T_InvoiceGL.setAmtAcctBalance(mFactAcct.getAmtAcctDr().subtract(mFactAcct.getAmtAcctCr()));
        Optional<Object> optional = Optional.empty();
        Optional<Object> optional2 = Optional.empty();
        if (mFactAcct.getAmtSourceDr().signum() != 0) {
            optional = Optional.ofNullable(MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)mFactAcct.getAmtSourceDr(), (int)mFactAcct.getC_Currency_ID(), (int)mAcctSchema.getC_Currency_ID(), (Timestamp)this.getDateReval(), (int)this.getConversionTypeRevalId(), (int)this.getAD_Client_ID(), (int)mFactAcct.getAD_Org_ID()));
        }
        if (mFactAcct.getAmtSourceCr().signum() != 0) {
            optional2 = Optional.ofNullable(MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)mFactAcct.getAmtSourceCr(), (int)mFactAcct.getC_Currency_ID(), (int)mAcctSchema.getC_Currency_ID(), (Timestamp)this.getDateReval(), (int)this.getConversionTypeRevalId(), (int)this.getAD_Client_ID(), (int)mFactAcct.getAD_Org_ID()));
        }
        if (optional.orElse(BigDecimal.ZERO).signum() == 0 && optional2.orElse(BigDecimal.ZERO).signum() == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            MConversionType mConversionType = new MConversionType(this.getCtx(), this.getConversionTypeRevalId(), string);
            stringBuilder.append(" @C_ConversionTypeReval_ID@ ").append(mConversionType.getName()).append(" @C_Conversion_Rate_ID@ @From@ @C_Currency_ID@ ").append(mFactAcct.getC_Currency().getISO_Code()).append(" @to@ @C_Currency_ID@ ").append(mAcctSchema.getC_Currency().getISO_Code()).append(" @DateReval@ ").append(this.getDateReval()).append(" @NotFound@");
            throw new AdempiereException(stringBuilder.toString());
        }
        x_T_InvoiceGL.setAmtRevalDr(optional.orElse(BigDecimal.ZERO));
        x_T_InvoiceGL.setAmtRevalCr(optional2.orElse(BigDecimal.ZERO));
        x_T_InvoiceGL.setAmtRevalDrDiff(optional.orElse(BigDecimal.ZERO).subtract(mFactAcct.getAmtAcctDr()));
        x_T_InvoiceGL.setAmtRevalCrDiff(optional2.orElse(BigDecimal.ZERO).subtract(mFactAcct.getAmtAcctCr()));
        x_T_InvoiceGL.saveEx();
        this.exchangeGainLossList.add(x_T_InvoiceGL);
    }

    private MAccount getUnrealizedGainLoss(Integer n, MJournalLine mJournalLine) {
        MAccount mAccount = MAccount.getValidCombination((Properties)this.getCtx(), (int)n, (String)mJournalLine.get_TrxName());
        return MAccount.get((Properties)this.getCtx(), (int)mJournalLine.getAD_Client_ID(), (int)mJournalLine.getAD_Org_ID(), (int)mAccount.getC_AcctSchema_ID(), (int)mAccount.getAccount_ID(), (int)mAccount.getC_SubAcct_ID(), (int)mAccount.getM_Product_ID(), (int)mAccount.getC_BPartner_ID(), (int)mAccount.getAD_OrgTrx_ID(), (int)mAccount.getC_LocFrom_ID(), (int)mAccount.getC_LocTo_ID(), (int)mAccount.getC_SalesRegion_ID(), (int)mAccount.getC_Project_ID(), (int)mAccount.getC_Campaign_ID(), (int)mAccount.getC_Activity_ID(), (int)mAccount.getUser1_ID(), (int)mAccount.getUser2_ID(), (int)mAccount.getUser3_ID(), (int)mAccount.getUser4_ID(), (int)mAccount.getUserElement1_ID(), (int)mAccount.getUserElement2_ID(), (String)mAccount.get_TrxName());
    }

    private List<MAcctSchema> getAccountingSchemes() {
        List<MAcctSchema> list = new ArrayList<MAcctSchema>();
        if (this.getAcctSchemaId() > 0) {
            list.add(MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId()));
        } else {
            list = Arrays.asList(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID()));
        }
        return new ArrayList<MAcctSchema>(list);
    }

    private List<I_C_ElementValue> getAccountsForeignCurrency() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IsForeignCurrency").append("=? ");
        arrayList.add("Y");
        if (this.getCurrencyId() > 0) {
            stringBuilder.append(" AND ").append("C_Currency_ID").append("=? ");
            arrayList.add(this.getCurrencyId());
        } else {
            stringBuilder.append(" AND ").append("C_Currency_ID").append(">0 ");
        }
        stringBuilder.append(" AND ").append("AccountType").append(" IN('").append("A").append("','").append("L").append("','").append("O").append("')");
        return new Query(this.getCtx(), "C_ElementValue", stringBuilder.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("C_ElementValue_ID").list(I_C_ElementValue.class);
    }

    private List<Integer> getAccountRecords(MAcctSchema mAcctSchema, I_C_ElementValue i_C_ElementValue) {
        ArrayList<Comparable<Integer>> arrayList = new ArrayList<Comparable<Integer>>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C_AcctSchema_ID").append("=? ");
        arrayList.add(Integer.valueOf(mAcctSchema.get_ID()));
        stringBuilder.append(" AND ").append("Account_ID").append("=?");
        arrayList.add(Integer.valueOf(i_C_ElementValue.getC_ElementValue_ID()));
        stringBuilder.append(" AND ").append("DateAcct").append("<=?");
        arrayList.add(this.getDateReval());
        int[] nArray = new Query(this.getCtx(), "Fact_Acct", stringBuilder.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("Account_ID,C_Currency_ID").getIDs();
        List<Integer> list = Arrays.stream(nArray).boxed().collect(Collectors.toList());
        return list;
    }

    private void cleanTemporaryTable() {
        Trx.run(string -> {
            StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
            stringBuilder.append("T_InvoiceGL").append(" WHERE ").append("AD_PInstance_ID").append("=?");
            DB.executeUpdate((String)stringBuilder.toString(), (int)this.getAD_PInstance_ID(), (String)string);
        });
    }

    class AccountBalance {
        Integer companyId;
        Integer accountSchemaId;
        Integer organizationId;
        Integer accountId;
        String accountName;
        Integer currencyId;
        BigDecimal sourceBalance;
        BigDecimal accountBalance;
        BigDecimal debit;
        BigDecimal credit;

        AccountBalance() {
        }
    }
}

