/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MDistribution;
import org.compiere.model.MDistributionLine;
import org.compiere.model.MElementValue;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public final class Fact {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Doc m_doc = null;
    private MAcctSchema m_acctSchema = null;
    private String m_trxName;
    private String m_postingType = null;
    public static final String POST_Actual = "A";
    public static final String POST_Budget = "B";
    public static final String POST_Commitment = "E";
    public static final String POST_Reservation = "R";
    private boolean m_converted = false;
    private ArrayList<FactLine> m_lines = new ArrayList();

    public Fact(Doc doc, MAcctSchema mAcctSchema, String string) {
        this.m_doc = doc;
        this.m_acctSchema = mAcctSchema;
        this.m_postingType = string;
        this.m_trxName = doc.getTrxName();
        this.log.config(this.toString());
    }

    public void dispose() {
        this.m_lines.clear();
        this.m_lines = null;
    }

    public FactLine createLine(DocLine docLine, MAccount mAccount, int n, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (mAccount == null) {
            this.log.info("No account for " + docLine + ": Amt=" + bigDecimal + "/" + bigDecimal2 + " - " + this.toString());
            return null;
        }
        FactLine factLine = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), docLine == null ? 0 : docLine.get_ID(), this.m_trxName);
        factLine.setDocumentInfo(this.m_doc, docLine);
        factLine.setPostingType(this.m_postingType);
        factLine.setAccount(this.m_acctSchema, mAccount);
        if (!factLine.setAmtSource(n, bigDecimal, bigDecimal2)) {
            if (docLine == null || docLine.getQty() == null || docLine.getQty().signum() == 0) {
                this.log.fine("Both amounts & qty = 0/Null - " + docLine + " - " + this.toString());
                return null;
            }
            this.log.fine("Both amounts = 0/Null, Qty=" + docLine.getQty() + " - " + docLine + " - " + this.toString());
        }
        factLine.convert();
        if (docLine != null && (docLine.getAmtAcctDr() != null || docLine.getAmtAcctCr() != null)) {
            factLine.setAmtAcct(docLine.getAmtAcctDr(), docLine.getAmtAcctCr());
        }
        this.log.fine(factLine.toString());
        this.add(factLine);
        return factLine;
    }

    public void add(FactLine factLine) {
        this.m_lines.add(factLine);
    }

    public void remove(FactLine factLine) {
        this.m_lines.remove(factLine);
    }

    public FactLine createLine(DocLine docLine, MAccount mAccount, MAccount mAccount2, int n, BigDecimal bigDecimal) {
        if (bigDecimal.signum() < 0) {
            return this.createLine(docLine, mAccount2, n, null, bigDecimal.abs());
        }
        return this.createLine(docLine, mAccount, n, bigDecimal, null);
    }

    public FactLine createLine(DocLine docLine, MAccount mAccount, int n, BigDecimal bigDecimal) {
        if (bigDecimal.signum() < 0) {
            return this.createLine(docLine, mAccount, n, null, bigDecimal.abs());
        }
        return this.createLine(docLine, mAccount, n, bigDecimal, null);
    }

    public boolean isPostingType(String string) {
        return this.m_postingType.equals(string);
    }

    public boolean isConverted() {
        return this.m_converted;
    }

    public MAcctSchema getAcctSchema() {
        return this.m_acctSchema;
    }

    public boolean isSourceBalanced() {
        boolean bl;
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        BigDecimal bigDecimal = this.getSourceBalance();
        boolean bl2 = bl = bigDecimal.signum() == 0;
        if (bl) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + bigDecimal + " - " + this.toString());
        }
        return bl;
    }

    protected BigDecimal getSourceBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine factLine = this.m_lines.get(i);
            bigDecimal = bigDecimal.add(factLine.getSourceBalance());
        }
        return bigDecimal;
    }

    public FactLine balanceSource() {
        if (!this.m_acctSchema.isSuspenseBalancing() || this.m_doc.isMultiCurrency()) {
            return null;
        }
        BigDecimal bigDecimal = this.getSourceBalance();
        this.log.finer("Diff=" + bigDecimal);
        FactLine factLine = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
        factLine.setDocumentInfo(this.m_doc, null);
        factLine.setPostingType(this.m_postingType);
        factLine.setAccount(this.m_acctSchema, this.m_acctSchema.getSuspenseBalancing_Acct());
        if (bigDecimal.signum() < 0) {
            factLine.setAmtSource(this.m_doc.getC_Currency_ID(), bigDecimal.abs(), Env.ZERO);
        } else {
            factLine.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, bigDecimal);
        }
        factLine.convert();
        this.log.fine(factLine.toString());
        this.m_lines.add(factLine);
        return factLine;
    }

    public boolean isSegmentBalanced() {
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        MAcctSchemaElement[] mAcctSchemaElementArray = this.m_acctSchema.getAcctSchemaElements();
        for (int i = 0; i < mAcctSchemaElementArray.length; ++i) {
            MAcctSchemaElement mAcctSchemaElement = mAcctSchemaElementArray[i];
            if (!mAcctSchemaElement.isBalanced() || this.isSegmentBalanced(mAcctSchemaElement.getElementType())) continue;
            return false;
        }
        return true;
    }

    public boolean isSegmentBalanced(String string) {
        if (string.equals("OO")) {
            HashMap<Integer, BigDecimal> hashMap = new HashMap<Integer, BigDecimal>();
            for (int i = 0; i < this.m_lines.size(); ++i) {
                Object object = this.m_lines.get(i);
                Integer n = new Integer(object.getAD_Org_ID());
                BigDecimal bigDecimal = object.getSourceBalance();
                BigDecimal bigDecimal2 = (BigDecimal)hashMap.get(n);
                if (bigDecimal2 != null) {
                    bigDecimal = bigDecimal.add(bigDecimal2);
                }
                hashMap.put(n, bigDecimal);
            }
            for (Object object : hashMap.values()) {
                if (((BigDecimal)object).signum() == 0) continue;
                hashMap.clear();
                this.log.warning("(" + string + ") NO - " + this.toString() + ", Balance=" + (BigDecimal)object);
                return false;
            }
            hashMap.clear();
            this.log.finer("(" + string + ") - " + this.toString());
            return true;
        }
        this.log.finer("(" + string + ") (not checked) - " + this.toString());
        return true;
    }

    public void balanceSegments() {
        MAcctSchemaElement[] mAcctSchemaElementArray = this.m_acctSchema.getAcctSchemaElements();
        for (int i = 0; i < mAcctSchemaElementArray.length; ++i) {
            MAcctSchemaElement mAcctSchemaElement = mAcctSchemaElementArray[i];
            if (!mAcctSchemaElement.isBalanced()) continue;
            this.balanceSegment(mAcctSchemaElement.getElementType());
        }
    }

    private void balanceSegment(String string) {
        if (this.m_lines.size() == 0) {
            return;
        }
        this.log.fine("(" + string + ") - " + this.toString());
        if (string.equals("OO")) {
            Balance balance;
            Object object;
            HashMap<Object, Balance> hashMap = new HashMap<Object, Balance>();
            for (int i = 0; i < this.m_lines.size(); ++i) {
                Object object2 = this.m_lines.get(i);
                object = new Integer(object2.getAD_Org_ID());
                balance = (Balance)hashMap.get(object);
                if (balance == null) {
                    balance = new Balance(object2.getAmtSourceDr(), object2.getAmtSourceCr());
                    hashMap.put(object, balance);
                    continue;
                }
                balance.add(object2.getAmtSourceDr(), object2.getAmtSourceCr());
            }
            for (Object object2 : hashMap.keySet()) {
                object = (Balance)hashMap.get(object2);
                this.log.info(string + "=" + (Integer)object2 + ", " + (Balance)object);
                if (((Balance)object).isZeroBalance()) continue;
                balance = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                balance.setDocumentInfo(this.m_doc, null);
                balance.setPostingType(this.m_postingType);
                if (((Balance)object).getBalance().signum() < 0) {
                    if (((Balance)object).isReversal()) {
                        balance.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(string));
                        balance.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, ((Balance)object).getPostBalance());
                    } else {
                        balance.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(string));
                        balance.setAmtSource(this.m_doc.getC_Currency_ID(), ((Balance)object).getPostBalance(), Env.ZERO);
                    }
                } else if (((Balance)object).isReversal()) {
                    balance.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(string));
                    balance.setAmtSource(this.m_doc.getC_Currency_ID(), ((Balance)object).getPostBalance(), Env.ZERO);
                } else {
                    balance.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(string));
                    balance.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, ((Balance)object).getPostBalance());
                }
                balance.convert();
                balance.setAD_Org_ID((Integer)object2);
                this.m_lines.add((FactLine)balance);
                this.log.fine("(" + string + ") - " + (FactLine)balance);
            }
            hashMap.clear();
        }
    }

    public boolean isAcctBalanced() {
        boolean bl;
        if (this.m_lines.size() == 0) {
            return true;
        }
        BigDecimal bigDecimal = this.getAcctBalance();
        boolean bl2 = bl = bigDecimal.signum() == 0;
        if (bl) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + bigDecimal + " - " + this.toString());
        }
        return bl;
    }

    protected BigDecimal getAcctBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine factLine = this.m_lines.get(i);
            bigDecimal = bigDecimal.add(factLine.getAcctBalance());
        }
        return bigDecimal;
    }

    public FactLine balanceAccounting() {
        Object object;
        BigDecimal bigDecimal = this.getAcctBalance();
        this.log.fine("Balance=" + bigDecimal + ", CurrBal=" + this.m_acctSchema.isCurrencyBalancing() + " - " + this.toString());
        FactLine factLine = null;
        BigDecimal bigDecimal2 = Env.ZERO;
        FactLine factLine2 = null;
        BigDecimal bigDecimal3 = Env.ZERO;
        FactLine factLine3 = null;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            object = this.m_lines.get(i);
            BigDecimal bigDecimal4 = object.getAcctBalance().abs();
            if (object.isBalanceSheet() && bigDecimal4.compareTo(bigDecimal2) > 0) {
                bigDecimal2 = bigDecimal4;
                factLine2 = object;
                continue;
            }
            if (object.isBalanceSheet() || bigDecimal4.compareTo(bigDecimal3) <= 0) continue;
            bigDecimal3 = bigDecimal4;
            factLine3 = object;
        }
        if (this.m_acctSchema.isCurrencyBalancing()) {
            boolean bl;
            factLine = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
            factLine.setDocumentInfo(this.m_doc, null);
            factLine.setPostingType(this.m_postingType);
            factLine.setAccount(this.m_acctSchema, this.m_acctSchema.getCurrencyBalancing_Acct());
            factLine.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, Env.ZERO);
            factLine.convert();
            BigDecimal bigDecimal5 = Env.ZERO;
            object = Env.ZERO;
            boolean bl2 = bigDecimal.signum() < 0;
            BigDecimal bigDecimal6 = bigDecimal.abs();
            if (bl2) {
                bigDecimal5 = bigDecimal6;
            } else {
                object = bigDecimal6;
            }
            boolean bl3 = bl = factLine2 != null && (factLine2.isDrSourceBalance() && bl2 || !factLine2.isDrSourceBalance() && !bl2);
            if (bl) {
                bigDecimal5 = Env.ZERO;
                object = Env.ZERO;
                if (bl2) {
                    object = bigDecimal6.negate();
                } else {
                    bigDecimal5 = bigDecimal6.negate();
                }
            }
            factLine.setAmtAcct(bigDecimal5, (BigDecimal)object);
            this.log.fine(factLine.toString());
            this.m_lines.add(factLine);
        } else {
            factLine = factLine2 != null ? factLine2 : factLine3;
            if (factLine == null) {
                this.log.severe("No Line found");
            } else {
                this.log.fine("Adjusting Amt=" + bigDecimal + "; Line=" + factLine);
                factLine.currencyCorrect(bigDecimal);
                this.log.fine(factLine.toString());
            }
        }
        return factLine;
    }

    public boolean checkAccounts() {
        if (this.m_lines.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine factLine = this.m_lines.get(i);
            MAccount mAccount = factLine.getAccount();
            if (mAccount == null) {
                this.log.warning("No Account for " + factLine);
                return false;
            }
            MElementValue mElementValue = mAccount.getAccount();
            if (mElementValue == null) {
                this.log.warning("No Element Value for " + mAccount + ": " + factLine);
                this.m_doc.p_Error = mAccount.toString();
                return false;
            }
            if (mElementValue.isSummary()) {
                this.log.warning("Cannot post to Summary Account " + mElementValue + ": " + factLine);
                this.m_doc.p_Error = mElementValue.toString();
                return false;
            }
            if (mElementValue.isActive()) continue;
            this.log.warning("Cannot post to Inactive Account " + mElementValue + ": " + factLine);
            this.m_doc.p_Error = mElementValue.toString();
            return false;
        }
        return true;
    }

    public boolean distribute() {
        int n;
        if (this.m_lines.size() == 0) {
            return true;
        }
        ArrayList<FactLine> arrayList = new ArrayList<FactLine>();
        for (n = 0; n < this.m_lines.size(); ++n) {
            FactLine factLine = this.m_lines.get(n);
            List list = MDistribution.get((MAccount)factLine.getAccount(), (String)this.m_postingType, (int)this.m_doc.getC_DocType_ID(), (Timestamp)factLine.getDateAcct());
            if ((list == null || list.size() == 0) && ((list = MDistribution.get((Properties)factLine.getCtx(), (int)factLine.getC_AcctSchema_ID(), (String)this.m_postingType, (int)this.m_doc.getC_DocType_ID(), (int)factLine.getAD_Org_ID(), (int)factLine.getAccount_ID(), (int)factLine.getM_Product_ID(), (int)factLine.getC_BPartner_ID(), (int)factLine.getC_Project_ID(), (int)factLine.getC_Campaign_ID(), (int)factLine.getC_Activity_ID(), (int)factLine.getAD_OrgTrx_ID(), (int)factLine.getC_SalesRegion_ID(), (int)factLine.getC_LocTo_ID(), (int)factLine.getC_LocFrom_ID(), (int)factLine.getUser1_ID(), (int)factLine.getUser2_ID(), (int)factLine.getUser3_ID(), (int)factLine.getUser4_ID(), (Timestamp)factLine.getDateAcct())) == null || list.size() == 0)) continue;
            if (list.size() > 1) {
                this.log.warning("More then one Distributiion for " + factLine.getAccount());
            }
            MDistribution mDistribution = (MDistribution)list.get(0);
            mDistribution.set_TrxName(this.get_TrxName());
            List list2 = mDistribution.getLines(false);
            if (mDistribution.getPercentTotal().signum() != 0) {
                Object object;
                if (mDistribution.isCreateReversal()) {
                    object = factLine.reverse(mDistribution.getName());
                    this.log.info("Reversal=" + (FactLine)object);
                    arrayList.add((FactLine)object);
                } else {
                    object = (MDistributionLine)list2.stream().findFirst().get();
                    if (!object.isOverwritePostingType() || object.getPostingType() == null || mDistribution.getPostingType() == null || object.getPostingType() == null || mDistribution.getPostingType().equals(object.getPostingType()) || object.getPercent().doubleValue() != 0.0) {
                        this.m_lines.remove(n);
                        --n;
                    }
                }
            }
            mDistribution.distribute(factLine.getAccount(), factLine.getSourceBalance(), factLine.getQty(), factLine.getC_Currency_ID(), this.m_doc.getAmount().signum());
            for (MDistributionLine mDistributionLine : list2) {
                FactLine factLine2 = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                factLine2.setDocumentInfo(this.m_doc, factLine.getDocLine());
                factLine2.setAccount(this.m_acctSchema, mDistributionLine.getAccount());
                if (factLine2.getLine_ID() <= 0 && factLine.getLine_ID() > 0) {
                    factLine2.setLine_ID(factLine.getLine_ID());
                }
                if (factLine2.getAD_OrgTrx_ID() <= 0 && factLine.getAD_OrgTrx_ID() > 0) {
                    factLine2.setAD_OrgTrx_ID(factLine.getAD_OrgTrx_ID());
                }
                if (factLine2.getC_Campaign_ID() <= 0 && factLine.getC_Campaign_ID() > 0) {
                    factLine2.setC_Campaign_ID(factLine.getC_Campaign_ID());
                }
                if (factLine2.getC_Project_ID() <= 0 && factLine.getC_Project_ID() > 0) {
                    factLine2.setC_Project_ID(factLine.getC_Project_ID());
                }
                if (factLine2.getC_ProjectPhase_ID() <= 0 && factLine.getC_ProjectPhase_ID() > 0) {
                    factLine2.setC_ProjectPhase_ID(factLine.getC_ProjectPhase_ID());
                }
                if (factLine2.getC_ProjectTask_ID() <= 0 && factLine.getC_ProjectTask_ID() > 0) {
                    factLine2.setC_ProjectTask_ID(factLine.getC_ProjectTask_ID());
                }
                if (factLine2.getC_Activity_ID() <= 0 && factLine.getC_Activity_ID() > 0) {
                    factLine2.setC_Activity_ID(factLine.getC_Activity_ID());
                }
                if (factLine2.getC_SalesRegion_ID() <= 0 && factLine.getC_SalesRegion_ID() > 0) {
                    factLine2.setC_SalesRegion_ID(factLine.getC_SalesRegion_ID());
                }
                if (factLine2.getUser1_ID() <= 0 && factLine.getUser1_ID() > 0) {
                    factLine2.setUser1_ID(factLine.getUser1_ID());
                }
                if (factLine2.getUser2_ID() <= 0 && factLine.getUser2_ID() > 0) {
                    factLine2.setUser2_ID(factLine.getUser2_ID());
                }
                if (factLine2.getUser3_ID() <= 0 && factLine.getUser3_ID() > 0) {
                    factLine2.setUser3_ID(factLine.getUser3_ID());
                }
                if (factLine2.getUser4_ID() <= 0 && factLine.getUser4_ID() > 0) {
                    factLine2.setUser4_ID(factLine.getUser4_ID());
                }
                if (factLine2.getUserElement1_ID() <= 0 && factLine.getUserElement1_ID() > 0) {
                    factLine2.setUserElement1_ID(factLine.getUserElement1_ID());
                }
                if (factLine2.getUserElement2_ID() <= 0 && factLine.getUserElement2_ID() > 0) {
                    factLine2.setUserElement2_ID(factLine.getUserElement2_ID());
                }
                if (factLine2.getC_LocFrom_ID() <= 0 && factLine.getC_LocFrom_ID() > 0) {
                    factLine2.setC_LocFrom_ID(factLine.getC_LocFrom_ID());
                }
                if (factLine2.getC_LocTo_ID() <= 0 && factLine.getC_LocTo_ID() > 0) {
                    factLine2.setC_LocTo_ID(factLine.getC_LocTo_ID());
                }
                factLine2.setPostingType(this.m_postingType);
                if (mDistributionLine.isOverwritePostingType() && mDistributionLine.getPostingType() != null && !mDistribution.getPostingType().equals(mDistributionLine.getPostingType()) && mDistributionLine.getPercent().doubleValue() == 0.0) {
                    factLine2.setPostingType(mDistributionLine.getPostingType());
                }
                if (mDistributionLine.isOverwriteOrg()) {
                    factLine2.setAD_Org_ID(mDistributionLine.getOrg_ID());
                }
                if (mDistributionLine.isOverwriteAcct()) {
                    factLine2.setAccount_ID(mDistributionLine.getAccount_ID());
                }
                if (mDistributionLine.isOverwriteActivity()) {
                    factLine2.setC_Activity_ID(mDistributionLine.getC_Activity_ID());
                }
                if (mDistributionLine.isOverwriteBPartner()) {
                    factLine2.setC_BPartner_ID(mDistributionLine.getC_BPartner_ID());
                }
                if (mDistributionLine.isOverwriteCampaign()) {
                    factLine2.setC_Campaign_ID(mDistributionLine.getC_Campaign_ID());
                }
                if (mDistributionLine.isOverwriteLocFrom()) {
                    factLine2.setC_LocFrom_ID(mDistributionLine.getC_LocFrom_ID());
                }
                if (mDistributionLine.isOverwriteLocTo()) {
                    factLine2.setC_LocTo_ID(mDistributionLine.getC_LocTo_ID());
                }
                if (mDistributionLine.isOverwriteOrgTrx()) {
                    factLine2.setAD_OrgTrx_ID(mDistributionLine.getAD_OrgTrx_ID());
                }
                if (mDistributionLine.isOverwriteProduct()) {
                    factLine2.setM_Product_ID(mDistributionLine.getM_Product_ID());
                }
                if (mDistributionLine.isOverwriteProject()) {
                    factLine2.setC_Project_ID(mDistributionLine.getC_Project_ID());
                }
                if (mDistributionLine.isOverwriteSalesRegion()) {
                    factLine2.setC_SalesRegion_ID(mDistributionLine.getC_SalesRegion_ID());
                }
                if (mDistributionLine.isOverwriteUser1()) {
                    factLine2.setUser1_ID(mDistributionLine.getUser1_ID());
                }
                if (mDistributionLine.isOverwriteUser2()) {
                    factLine2.setUser2_ID(mDistributionLine.getUser2_ID());
                }
                if (mDistributionLine.isOverwriteUser3()) {
                    factLine2.setUser3_ID(mDistributionLine.getUser3_ID());
                }
                if (mDistributionLine.isOverwriteUser4()) {
                    factLine2.setUser4_ID(mDistributionLine.getUser4_ID());
                }
                if (mDistributionLine.isInvertAccountSign()) {
                    if (mDistributionLine.getAmt() != null && mDistributionLine.getAmt().signum() < 0) {
                        factLine2.setAmtSource(factLine.getC_Currency_ID(), null, mDistributionLine.getAmt().abs());
                    } else {
                        factLine2.setAmtSource(factLine.getC_Currency_ID(), mDistributionLine.getAmt(), null);
                    }
                } else if (mDistributionLine.getAmt() != null && mDistributionLine.getAmt().signum() < 0) {
                    factLine2.setAmtSource(factLine.getC_Currency_ID(), null, mDistributionLine.getAmt().abs());
                } else {
                    factLine2.setAmtSource(factLine.getC_Currency_ID(), mDistributionLine.getAmt(), null);
                }
                factLine2.setQty(mDistributionLine.getQty());
                factLine2.convert();
                String string = mDistribution.getName() + " #" + mDistributionLine.getLine();
                if (mDistributionLine.getDescription() != null) {
                    string = string + " - " + mDistributionLine.getDescription();
                }
                factLine2.addDescription(string);
                this.log.info(factLine2.toString());
                arrayList.add(factLine2);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.m_lines.add((FactLine)arrayList.get(n));
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Fact[");
        stringBuffer.append(this.m_doc.toString());
        stringBuffer.append(",").append(this.m_acctSchema.toString());
        stringBuffer.append(",PostType=").append(this.m_postingType);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public FactLine[] getLines() {
        FactLine[] factLineArray = new FactLine[this.m_lines.size()];
        this.m_lines.toArray(factLineArray);
        return factLineArray;
    }

    public boolean save(String string) {
        this.m_trxName = string;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine factLine = this.m_lines.get(i);
            if (factLine.save(string)) continue;
            return false;
        }
        return true;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    private void set_TrxName(String string) {
        this.m_trxName = string;
    }

    public Doc getDocument() {
        return this.m_doc;
    }

    public class Balance {
        public BigDecimal DR = Env.ZERO;
        public BigDecimal CR = Env.ZERO;

        public Balance(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            this.DR = bigDecimal;
            this.CR = bigDecimal2;
        }

        public void add(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            this.DR = this.DR.add(bigDecimal);
            this.CR = this.CR.add(bigDecimal2);
        }

        public BigDecimal getBalance() {
            return this.DR.subtract(this.CR);
        }

        public BigDecimal getPostBalance() {
            BigDecimal bigDecimal = this.getBalance().abs();
            if (this.isReversal()) {
                return bigDecimal.negate();
            }
            return bigDecimal;
        }

        public boolean isZeroBalance() {
            return this.getBalance().signum() == 0;
        }

        public boolean isReversal() {
            return this.DR.signum() <= 0 && this.CR.signum() <= 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Balance[");
            stringBuffer.append("DR=").append(this.DR).append("-CR=").append(this.CR).append(" = ").append(this.getBalance()).append("]");
            return stringBuffer.toString();
        }
    }
}

