/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInvoice
extends CalloutEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String docType(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        ResultSet resultSet;
        CPreparedStatement cPreparedStatement;
        block11: {
            Integer n2 = (Integer)object;
            if (n2 == null || n2 == 0) {
                return "";
            }
            String string = "SELECT d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext, d.DocBaseType, s.StartNewYear, s.DateColumn, s.AD_Sequence_ID FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
            cPreparedStatement = null;
            resultSet = null;
            try {
                String string2;
                cPreparedStatement = DB.prepareStatement((String)string, null);
                cPreparedStatement.setInt(1, n2);
                resultSet = cPreparedStatement.executeQuery();
                if (!resultSet.next()) break block11;
                Env.setContext((Properties)properties, (int)n, (String)"HasCharges", (String)resultSet.getString(1));
                if (resultSet.getString(3).equals("Y")) {
                    if ("Y".equals(resultSet.getString(6))) {
                        string2 = resultSet.getString(7);
                        gridTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear((GridTab)gridTab, (int)resultSet.getInt(8), (String)string2, null) + ">"));
                    } else {
                        gridTab.setValue("DocumentNo", (Object)("<" + resultSet.getString(4) + ">"));
                    }
                }
                string2 = resultSet.getString(5);
                Env.setContext((Properties)properties, (int)n, (String)"DocBaseType", (String)string2);
                if (string2.startsWith("AP")) {
                    gridTab.setValue("PaymentRule", (Object)"S");
                } else if (string2.endsWith("C")) {
                    gridTab.setValue("PaymentRule", (Object)"P");
                }
            }
            catch (SQLException sQLException) {
                String string3;
                try {
                    this.log.log(Level.SEVERE, string, (Throwable)sQLException);
                    string3 = sQLException.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(resultSet, (Statement)cPreparedStatement);
                    throw throwable;
                }
                DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
                return string3;
            }
        }
        DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartner(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        ResultSet resultSet;
        CPreparedStatement cPreparedStatement;
        block25: {
            Integer n2 = (Integer)object;
            if (n2 == null || n2 == 0) {
                return "";
            }
            String string = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, l.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
            boolean bl = Env.getContext((Properties)properties, (int)n, (String)"IsSOTrx").equals("Y");
            cPreparedStatement = null;
            resultSet = null;
            try {
                String string2;
                double d;
                String string3;
                String string4;
                cPreparedStatement = DB.prepareStatement((String)string, null);
                cPreparedStatement.setInt(1, n2);
                resultSet = cPreparedStatement.executeQuery();
                if (!resultSet.next()) break block25;
                Integer n3 = resultSet.getInt(bl ? "M_PriceList_ID" : "PO_PriceList_ID");
                if (!resultSet.wasNull()) {
                    gridTab.setValue("M_PriceList_ID", (Object)n3);
                } else {
                    int n4 = Env.getContextAsInt((Properties)properties, (String)"#M_PriceList_ID");
                    if (n4 != 0) {
                        gridTab.setValue("M_PriceList_ID", (Object)n4);
                    }
                }
                String string5 = resultSet.getString(bl ? "PaymentRule" : "PaymentRulePO");
                if (string5 != null && string5.length() != 0) {
                    if (Env.getContext((Properties)properties, (int)n, (String)"DocBaseType").endsWith("C")) {
                        string5 = "P";
                    } else if (bl && (string5.equals("S") || string5.equals("U"))) {
                        string5 = "P";
                    }
                    gridTab.setValue("PaymentRule", (Object)string5);
                }
                n3 = resultSet.getInt(bl ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID");
                if (!resultSet.wasNull()) {
                    gridTab.setValue("C_PaymentTerm_ID", (Object)n3);
                }
                int n5 = resultSet.getInt("C_BPartner_Location_ID");
                if (n2.toString().equals(Env.getContext((Properties)properties, (int)n, (int)1113, (String)"C_BPartner_ID")) && (string4 = Env.getContext((Properties)properties, (int)n, (int)1113, (String)"C_BPartner_Location_ID")).length() > 0) {
                    n5 = Integer.parseInt(string4);
                }
                if (n5 == 0) {
                    gridTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    gridTab.setValue("C_BPartner_Location_ID", (Object)n5);
                }
                int n6 = resultSet.getInt("AD_User_ID");
                if (n2.toString().equals(Env.getContext((Properties)properties, (int)n, (int)1113, (String)"C_BPartner_ID")) && (string3 = Env.getContext((Properties)properties, (int)n, (int)1113, (String)"AD_User_ID")).length() > 0) {
                    n6 = Integer.parseInt(string3);
                }
                if (n6 == 0) {
                    gridTab.setValue("AD_User_ID", null);
                } else {
                    gridTab.setValue("AD_User_ID", (Object)n6);
                }
                if (bl && (d = resultSet.getDouble("SO_CreditLimit")) != 0.0) {
                    double d2 = resultSet.getDouble("CreditAvailable");
                    if (!resultSet.wasNull() && d2 < 0.0) {
                        gridTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(d2), false);
                    }
                }
                if ((string3 = resultSet.getString("POReference")) != null && string3.length() != 0) {
                    gridTab.setValue("POReference", (Object)string3);
                } else {
                    gridTab.setValue("POReference", null);
                }
                String string6 = resultSet.getString("SO_Description");
                if (string6 != null && string6.trim().length() != 0) {
                    gridTab.setValue("Description", (Object)string6);
                }
                if ((string2 = resultSet.getString("IsDiscountPrinted")) != null && string2.length() != 0) {
                    gridTab.setValue("IsDiscountPrinted", (Object)string2);
                    break block25;
                }
                gridTab.setValue("IsDiscountPrinted", (Object)"N");
            }
            catch (SQLException sQLException) {
                String string7;
                try {
                    this.log.log(Level.SEVERE, "bPartner", (Throwable)sQLException);
                    string7 = sQLException.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(resultSet, (Statement)cPreparedStatement);
                    resultSet = null;
                    cPreparedStatement = null;
                    throw throwable;
                }
                DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                return string7;
            }
        }
        DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return "";
    }

    public String paymentTerm(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        Integer n2 = (Integer)object;
        int n3 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_Invoice_ID");
        if (n2 == null || n2 == 0 || n3 == 0) {
            return "";
        }
        MPaymentTerm mPaymentTerm = new MPaymentTerm(properties, n2.intValue(), null);
        if (mPaymentTerm.get_ID() == 0) {
            return "PaymentTerm not found";
        }
        boolean bl = mPaymentTerm.apply(n3);
        gridTab.setValue("IsPayScheduleValid", (Object)(bl ? "Y" : "N"));
        return "";
    }

    public String product(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        Object object2;
        Integer n2 = (Integer)object;
        Integer n3 = 0;
        if (n2 == null || n2 == 0) {
            return "";
        }
        gridTab.setValue("C_Charge_ID", null);
        MProduct mProduct = MProduct.get((Properties)Env.getCtx(), (int)n2);
        gridTab.setValue("M_AttributeSetInstance_ID", (Object)mProduct.getEnvAttributeSetInstance(properties, n));
        boolean bl = Env.getContext((Properties)properties, (int)n, (String)"IsSOTrx").equals("Y");
        int n4 = Env.getContextAsInt((Properties)properties, (int)n, (int)n, (String)"C_BPartner_ID");
        BigDecimal bigDecimal4 = (BigDecimal)gridTab.getValue("QtyInvoiced");
        MProductPricing mProductPricing = new MProductPricing(n2.intValue(), n4, bigDecimal4, bl, null);
        int n5 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_PriceList_ID");
        mProductPricing.setM_PriceList_ID(n5);
        Timestamp timestamp = Env.getContextAsDate((Properties)properties, (int)n, (String)"DateInvoiced");
        int n6 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_PriceList_Version_ID");
        if (n6 == 0 && n5 > 0 && (n6 = DB.getSQLValueEx(null, (String)(object2 = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{n5, timestamp})) > 0) {
            Env.setContext((Properties)properties, (int)n, (String)"M_PriceList_Version_ID", (int)n6);
        }
        mProductPricing.setM_PriceList_Version_ID(n6);
        object2 = Env.getContextAsDate((Properties)properties, (int)n, (String)"DateInvoiced");
        mProductPricing.setPriceDate((Timestamp)object2);
        BigDecimal bigDecimal5 = (BigDecimal)gridTab.getValue("PriceList");
        if (bigDecimal5.signum() == 0 && mProductPricing.getPriceList().signum() != 0) {
            gridTab.setValue("PriceList", (Object)mProductPricing.getPriceList());
        }
        if (((bigDecimal3 = (BigDecimal)gridTab.getValue("PriceLimit")) == null || bigDecimal3.signum() == 0) && mProductPricing.getPriceLimit().signum() > 0) {
            gridTab.setValue("PriceLimit", (Object)mProductPricing.getPriceLimit());
        }
        if (((bigDecimal2 = (BigDecimal)gridTab.getValue("PriceActual")) == null || bigDecimal2.signum() == 0) && mProductPricing.getPriceStd().signum() > 0) {
            gridTab.setValue("PriceActual", (Object)mProductPricing.getPriceStd());
        }
        if (((bigDecimal = (BigDecimal)gridTab.getValue("PriceEntered")) == null || bigDecimal.signum() == 0) && mProductPricing.getPriceStd().signum() > 0) {
            gridTab.setValue("PriceEntered", (Object)mProductPricing.getPriceStd());
        }
        gridTab.setValue("C_Currency_ID", (Object)new Integer(mProductPricing.getC_Currency_ID()));
        gridTab.setValue("C_UOM_ID", (Object)mProductPricing.getC_UOM_ID());
        Env.setContext((Properties)properties, (int)n, (String)"DiscountSchema", (String)(mProductPricing.isDiscountSchema() ? "Y" : "N"));
        return this.tax(properties, n, gridTab, gridField, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String charge(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        Integer n2 = (Integer)object;
        if (n2 == null || n2 == 0) {
            return "";
        }
        if (gridTab.getValue("M_Product_ID") != null) {
            gridTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        gridTab.setValue("M_AttributeSetInstance_ID", null);
        gridTab.setValue("S_ResourceAssignment_ID", null);
        gridTab.setValue("C_UOM_ID", (Object)100);
        Env.setContext((Properties)properties, (int)n, (String)"DiscountSchema", (String)"N");
        String string = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement((String)string, null);
            cPreparedStatement.setInt(1, n2);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                gridTab.setValue("PriceEntered", (Object)resultSet.getBigDecimal(1));
                gridTab.setValue("PriceActual", (Object)resultSet.getBigDecimal(1));
                gridTab.setValue("PriceLimit", (Object)Env.ZERO);
                gridTab.setValue("PriceList", (Object)Env.ZERO);
                gridTab.setValue("Discount", (Object)Env.ZERO);
            }
        }
        catch (SQLException sQLException) {
            String string2;
            try {
                this.log.log(Level.SEVERE, string + sQLException);
                string2 = sQLException.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                DB.close(resultSet, (Statement)cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            return string2;
        }
        DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return this.tax(properties, n, gridTab, gridField, object);
    }

    public String tax(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        String string = gridField.getColumnName();
        if (object == null) {
            return "";
        }
        int n2 = 0;
        n2 = string.equals("M_Product_ID") ? (Integer)object : Env.getContextAsInt((Properties)properties, (int)n, (String)"M_Product_ID");
        int n3 = 0;
        n3 = string.equals("C_Charge_ID") ? (Integer)object : Env.getContextAsInt((Properties)properties, (int)n, (String)"C_Charge_ID");
        this.log.fine("Product=" + n2 + ", C_Charge_ID=" + n3);
        if (n2 == 0 && n3 == 0) {
            return this.amt(properties, n, gridTab, gridField, object);
        }
        int n4 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_BPartner_Location_ID");
        if (n4 == 0) {
            return this.amt(properties, n, gridTab, gridField, object);
        }
        this.log.fine("Ship BP_Location=" + n4);
        int n5 = n4;
        this.log.fine("Bill BP_Location=" + n5);
        Timestamp timestamp = Env.getContextAsDate((Properties)properties, (int)n, (String)"DateInvoiced");
        this.log.fine("Bill Date=" + timestamp);
        Timestamp timestamp2 = timestamp;
        this.log.fine("Ship Date=" + timestamp2);
        int n6 = Env.getContextAsInt((Properties)properties, (int)n, (String)"AD_Org_ID");
        this.log.fine("Org=" + n6);
        int n7 = Env.getContextAsInt((Properties)properties, (String)"#M_Warehouse_ID");
        this.log.fine("Warehouse=" + n7);
        int n8 = Tax.get((Properties)properties, (int)n2, (int)n3, (Timestamp)timestamp, (Timestamp)timestamp2, (int)n6, (int)n7, (int)n5, (int)n4, (boolean)Env.getContext((Properties)properties, (int)n, (String)"IsSOTrx").equals("Y"), null);
        this.log.info("Tax ID=" + n8);
        if (n8 == 0) {
            gridTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            gridTab.setValue("C_Tax_ID", (Object)n8);
        }
        return this.amt(properties, n, gridTab, gridField, object);
    }

    public String amt(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        MProduct mProduct;
        Object object2;
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_UOM_ID");
        int n3 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_Product_ID");
        int n4 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_PriceList_ID");
        int n5 = MPriceList.getStandardPrecision((Properties)properties, (int)n4);
        BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("QtyEntered");
        BigDecimal bigDecimal2 = (BigDecimal)gridTab.getValue("QtyInvoiced");
        this.log.fine("QtyEntered=" + bigDecimal + ", Invoiced=" + bigDecimal2 + ", UOM=" + n2);
        BigDecimal bigDecimal3 = (BigDecimal)gridTab.getValue("PriceEntered");
        BigDecimal bigDecimal4 = (BigDecimal)gridTab.getValue("PriceActual");
        BigDecimal bigDecimal5 = (BigDecimal)gridTab.getValue("PriceLimit");
        BigDecimal bigDecimal6 = (BigDecimal)gridTab.getValue("PriceList");
        this.log.fine("PriceList=" + bigDecimal6 + ", Limit=" + bigDecimal5 + ", Precision=" + n5);
        this.log.fine("PriceEntered=" + bigDecimal3 + ", Actual=" + bigDecimal4);
        if (n3 == 0) {
            if (gridField.getColumnName().equals("PriceActual")) {
                bigDecimal3 = (BigDecimal)object;
                gridTab.setValue("PriceEntered", object);
            } else if (gridField.getColumnName().equals("PriceEntered")) {
                bigDecimal4 = (BigDecimal)object;
                gridTab.setValue("PriceActual", object);
            }
        } else if ((gridField.getColumnName().equals("QtyInvoiced") || gridField.getColumnName().equals("QtyEntered") || gridField.getColumnName().equals("C_UOM_ID") || gridField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext((Properties)properties, (int)n, (String)"DiscountSchema"))) {
            int n6 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_BPartner_ID");
            if (gridField.getColumnName().equals("QtyEntered")) {
                bigDecimal2 = MUOMConversion.convertProductFrom((Properties)properties, (int)n3, (int)n2, (BigDecimal)bigDecimal);
            }
            if (bigDecimal2 == null) {
                bigDecimal2 = bigDecimal;
            }
            boolean bl = Env.getContext((Properties)properties, (int)n, (String)"IsSOTrx").equals("Y");
            object2 = new MProductPricing(n3, n6, bigDecimal2, bl, null);
            object2.setM_PriceList_ID(n4);
            int n7 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_PriceList_Version_ID");
            object2.setM_PriceList_Version_ID(n7);
            Timestamp timestamp = (Timestamp)gridTab.getValue("DateInvoiced");
            object2.setPriceDate(timestamp);
            BigDecimal bigDecimal7 = (BigDecimal)gridTab.getValue("PriceEntered");
            if ((bigDecimal7 == null || bigDecimal7.signum() == 0) && object2.getPriceStd().signum() > 0) {
                bigDecimal3 = MUOMConversion.convertProductFrom((Properties)properties, (int)n3, (int)n2, (BigDecimal)object2.getPriceStd());
                if (bigDecimal3 == null) {
                    bigDecimal3 = object2.getPriceStd();
                }
                this.log.fine("amt - QtyChanged -> PriceActual=" + object2.getPriceStd() + ", PriceEntered=" + bigDecimal3 + ", Discount=" + object2.getDiscount());
                gridTab.setValue("PriceEntered", (Object)bigDecimal3);
            } else {
                bigDecimal3 = bigDecimal7;
            }
            BigDecimal bigDecimal8 = (BigDecimal)gridTab.getValue("PriceActual");
            if ((bigDecimal8 == null || bigDecimal8.signum() == 0) && object2.getPriceStd().signum() > 0) {
                bigDecimal4 = object2.getPriceStd();
                gridTab.setValue("PriceActual", (Object)bigDecimal4);
            } else {
                bigDecimal4 = bigDecimal8;
            }
            gridTab.setValue("PriceEntered", (Object)bigDecimal3);
            Env.setContext((Properties)properties, (int)n, (String)"DiscountSchema", (String)(object2.isDiscountSchema() ? "Y" : "N"));
        } else if (gridField.getColumnName().equals("PriceActual")) {
            bigDecimal4 = (BigDecimal)object;
            bigDecimal3 = MUOMConversion.convertProductFrom((Properties)properties, (int)n3, (int)n2, (BigDecimal)bigDecimal4);
            if (bigDecimal3 == null) {
                bigDecimal3 = bigDecimal4;
            }
            this.log.fine("amt - PriceActual=" + bigDecimal4 + " -> PriceEntered=" + bigDecimal3);
            gridTab.setValue("PriceEntered", (Object)bigDecimal3);
        } else if (gridField.getColumnName().equals("PriceEntered")) {
            bigDecimal3 = (BigDecimal)object;
            bigDecimal4 = MUOMConversion.convertProductTo((Properties)properties, (int)n3, (int)n2, (BigDecimal)bigDecimal3);
            if (bigDecimal4 == null) {
                bigDecimal4 = bigDecimal3;
            }
            this.log.fine("amt - PriceEntered=" + bigDecimal3 + " -> PriceActual=" + bigDecimal4);
            gridTab.setValue("PriceActual", (Object)bigDecimal4);
        }
        if (MPriceList.isCheckPriceLimit((Integer)n4).booleanValue() && bigDecimal5.doubleValue() != 0.0 && bigDecimal4.compareTo(bigDecimal5) < 0) {
            BigDecimal bigDecimal9;
            bigDecimal4 = bigDecimal5;
            bigDecimal3 = MUOMConversion.convertProductFrom((Properties)properties, (int)n3, (int)n2, (BigDecimal)bigDecimal5);
            if (bigDecimal3 == null) {
                bigDecimal3 = bigDecimal5;
            }
            this.log.fine("amt =(under) PriceEntered=" + bigDecimal3 + ", Actual" + bigDecimal5);
            gridTab.setValue("PriceActual", (Object)bigDecimal5);
            gridTab.setValue("PriceEntered", (Object)bigDecimal3);
            gridTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (bigDecimal6.intValue() != 0 && (bigDecimal9 = new BigDecimal((bigDecimal6.doubleValue() - bigDecimal4.doubleValue()) / bigDecimal6.doubleValue() * 100.0)).scale() > 2) {
                bigDecimal9 = bigDecimal9.setScale(2, RoundingMode.HALF_UP);
            }
        }
        BigDecimal bigDecimal10 = null;
        if (n3 != 0 && (mProduct = MProduct.get((Properties)properties, (int)n3)).getC_UOM_ID() != n2 && bigDecimal3 != null && !bigDecimal3.equals(Env.ZERO) && bigDecimal != null && !bigDecimal.equals(Env.ZERO)) {
            bigDecimal10 = bigDecimal.multiply(bigDecimal3);
        }
        if (bigDecimal10 == null) {
            bigDecimal10 = bigDecimal2.multiply(bigDecimal4);
        }
        if (bigDecimal10.scale() > n5) {
            bigDecimal10 = bigDecimal10.setScale(n5, RoundingMode.HALF_UP);
        }
        this.log.info("amt = LineNetAmt=" + bigDecimal10);
        gridTab.setValue("LineNetAmt", (Object)bigDecimal10);
        BigDecimal bigDecimal11 = Env.ZERO;
        if (gridField.getColumnName().equals("TaxAmt")) {
            bigDecimal11 = (BigDecimal)gridTab.getValue("TaxAmt");
        } else {
            object2 = (Integer)gridTab.getValue("C_Tax_ID");
            if (object2 != null) {
                MTax mTax = new MTax(properties, ((Integer)object2).intValue(), null);
                bigDecimal11 = mTax.calculateTax(bigDecimal10, this.isTaxIncluded(n), n5);
                gridTab.setValue("TaxAmt", (Object)bigDecimal11);
            }
        }
        gridTab.setValue("LineTotalAmt", (Object)bigDecimal10.add(bigDecimal11));
        return "";
    }

    private boolean isTaxIncluded(int n) {
        String string = Env.getContext((Properties)Env.getCtx(), (int)n, (String)"IsTaxIncluded");
        if (string.isEmpty()) {
            int n2 = Env.getContextAsInt((Properties)Env.getCtx(), (int)n, (String)"M_PriceList_ID");
            if (n2 == 0) {
                return false;
            }
            string = DB.getSQLValueString(null, (String)"SELECT IsTaxIncluded FROM M_PriceList WHERE M_PriceList_ID=?", (int)n2);
            if (string == null) {
                string = "N";
            }
            Env.setContext((Properties)Env.getCtx(), (int)n, (String)"IsTaxIncluded", (String)string);
        }
        return "Y".equals(string);
    }

    public String qty(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = Env.getContextAsInt((Properties)properties, (int)n, (String)"M_Product_ID");
        if (n2 == 0) {
            BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("QtyEntered");
            gridTab.setValue("QtyInvoiced", (Object)bigDecimal);
        } else if (gridField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            int n3 = (Integer)object;
            BigDecimal bigDecimal3 = (BigDecimal)gridTab.getValue("QtyEntered");
            if (bigDecimal3.compareTo(bigDecimal2 = bigDecimal3.setScale(MUOM.getPrecision((Properties)properties, (int)n3), RoundingMode.HALF_UP)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + n3 + "; QtyEntered=" + bigDecimal3 + "->" + bigDecimal2);
                bigDecimal3 = bigDecimal2;
                gridTab.setValue("QtyEntered", (Object)bigDecimal3);
            }
            if ((bigDecimal = MUOMConversion.convertProductFrom((Properties)properties, (int)n2, (int)n3, (BigDecimal)bigDecimal3)) == null) {
                bigDecimal = bigDecimal3;
            }
            boolean bl = bigDecimal3.compareTo(bigDecimal) != 0;
            BigDecimal bigDecimal4 = (BigDecimal)gridTab.getValue("PriceActual");
            BigDecimal bigDecimal5 = MUOMConversion.convertProductFrom((Properties)properties, (int)n2, (int)n3, (BigDecimal)bigDecimal4);
            if (bigDecimal5 == null) {
                bigDecimal5 = bigDecimal4;
            }
            this.log.fine("qty - UOM=" + n3 + ", QtyEntered/PriceActual=" + bigDecimal3 + "/" + bigDecimal4 + " -> " + bl + " QtyInvoiced/PriceEntered=" + bigDecimal + "/" + bigDecimal5);
            Env.setContext((Properties)properties, (int)n, (String)"UOMConversion", (String)(bl ? "Y" : "N"));
            gridTab.setValue("QtyInvoiced", (Object)bigDecimal);
            gridTab.setValue("PriceEntered", (Object)bigDecimal5);
        } else if (gridField.getColumnName().equals("QtyEntered")) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal6 = (BigDecimal)object;
            int n4 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_UOM_ID");
            BigDecimal bigDecimal7 = bigDecimal6.setScale(MUOM.getPrecision((Properties)properties, (int)n4), RoundingMode.HALF_UP);
            if (bigDecimal6.compareTo(bigDecimal7) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + n4 + "; QtyEntered=" + bigDecimal6 + "->" + bigDecimal7);
                bigDecimal6 = bigDecimal7;
                gridTab.setValue("QtyEntered", (Object)bigDecimal6);
            }
            if ((bigDecimal = MUOMConversion.convertProductFrom((Properties)properties, (int)n2, (int)n4, (BigDecimal)bigDecimal6)) == null) {
                bigDecimal = bigDecimal6;
            }
            boolean bl = bigDecimal6.compareTo(bigDecimal) != 0;
            this.log.fine("qty - UOM=" + n4 + ", QtyEntered=" + bigDecimal6 + " -> " + bl + " QtyInvoiced=" + bigDecimal);
            Env.setContext((Properties)properties, (int)n, (String)"UOMConversion", (String)(bl ? "Y" : "N"));
            gridTab.setValue("QtyInvoiced", (Object)bigDecimal);
        } else if (gridField.getColumnName().equals("QtyInvoiced")) {
            BigDecimal bigDecimal;
            int n5 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_UOM_ID");
            BigDecimal bigDecimal8 = (BigDecimal)object;
            int n6 = MProduct.get((Properties)properties, (int)n2).getUOMPrecision();
            BigDecimal bigDecimal9 = bigDecimal8.setScale(n6, RoundingMode.HALF_UP);
            if (bigDecimal8.compareTo(bigDecimal9) != 0) {
                this.log.fine("Corrected QtyInvoiced Scale " + bigDecimal8 + "->" + bigDecimal9);
                bigDecimal8 = bigDecimal9;
                gridTab.setValue("QtyInvoiced", (Object)bigDecimal8);
            }
            if ((bigDecimal = MUOMConversion.convertProductTo((Properties)properties, (int)n2, (int)n5, (BigDecimal)bigDecimal8)) == null) {
                bigDecimal = bigDecimal8;
            }
            boolean bl = bigDecimal8.compareTo(bigDecimal) != 0;
            this.log.fine("qty - UOM=" + n5 + ", QtyInvoiced=" + bigDecimal8 + " -> " + bl + " QtyEntered=" + bigDecimal);
            Env.setContext((Properties)properties, (int)n, (String)"UOMConversion", (String)(bl ? "Y" : "N"));
            gridTab.setValue("QtyEntered", (Object)bigDecimal);
        }
        return "";
    }
}

