/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_HR_Concept;
import org.adempiere.core.domains.models.X_HR_Movement;
import org.adempiere.core.domains.models.X_HR_Payroll;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutPaySelection
extends CalloutEngine {
    public String payAmt(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("OpenAmt");
        BigDecimal bigDecimal2 = (BigDecimal)gridTab.getValue("DiscountAmt");
        BigDecimal bigDecimal3 = (BigDecimal)gridTab.getValue("PayAmt");
        BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal3).subtract(bigDecimal2);
        this.log.fine(" - OpenAmt=" + bigDecimal + " - PayAmt=" + bigDecimal3 + ", Discount=" + bigDecimal2 + ", Difference=" + bigDecimal4);
        gridTab.setValue("DifferenceAmt", (Object)bigDecimal4);
        return "";
    }

    public String discountAmt(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("OpenAmt");
        BigDecimal bigDecimal2 = (BigDecimal)gridTab.getValue("DiscountAmt");
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        BigDecimal bigDecimal4 = Env.ZERO;
        this.log.fine(" - OpenAmt=" + bigDecimal + " - PayAmt=" + bigDecimal3 + ", Discount=" + bigDecimal2 + ", Difference=" + bigDecimal4);
        gridTab.setValue("PayAmt", (Object)bigDecimal3);
        gridTab.setValue("DifferenceAmt", (Object)bigDecimal4);
        return "";
    }

    public String conversion(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        MInvoice mInvoice;
        String string = gridField.getColumnName();
        if (!string.equals("C_ConversionType_ID") && !string.equals("C_Conversion_Rate_ID")) {
            return "";
        }
        Integer n2 = (Integer)gridTab.getValue("C_Invoice_ID");
        Integer n3 = (Integer)gridTab.getValue("C_Order_ID");
        Integer n4 = (Integer)gridTab.getValue("C_PaySelection_ID");
        if (!(n2 != null && n2 != 0 || n3 != null && n3 != 0)) {
            return "";
        }
        BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("AmtSource");
        BigDecimal bigDecimal2 = (BigDecimal)gridTab.getValue("OpenAmt");
        BigDecimal bigDecimal3 = (BigDecimal)gridTab.getValue("DiscountAmt");
        BigDecimal bigDecimal4 = (BigDecimal)gridTab.getValue("PayAmt");
        BigDecimal bigDecimal5 = bigDecimal2.subtract(bigDecimal4).subtract(bigDecimal3);
        this.log.fine(" - OpenAmt=" + bigDecimal2 + " - PayAmt=" + bigDecimal4 + ", Discount=" + bigDecimal3 + ", Difference=" + bigDecimal5);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Integer n9 = (Integer)gridTab.getValue("C_ConversionType_ID");
        if (n9 != null) {
            n7 = n9;
        }
        if ((n9 = (Integer)gridTab.getValue("C_Conversion_Rate_ID")) != null) {
            n8 = n9;
        }
        if ((n9 = (Integer)gridTab.getValue("AD_Client_ID")) != null) {
            n5 = n9;
        }
        if ((n9 = (Integer)gridTab.getValue("AD_Org_ID")) != null) {
            n6 = n9;
        }
        int n10 = 0;
        if (n2 != null && n2 != 0) {
            mInvoice = new MInvoice(properties, n2.intValue(), null);
            n10 = mInvoice.getC_Currency_ID();
        } else if (n3 != 0) {
            mInvoice = new MOrder(properties, n3.intValue(), null);
            n10 = mInvoice.getC_Currency_ID();
        }
        mInvoice = new MPaySelection(properties, n4.intValue(), null);
        int n11 = mInvoice.getC_Currency_ID();
        MCurrency mCurrency = MCurrency.get((Properties)properties, (int)n11);
        Timestamp timestamp = mInvoice.getDateDoc();
        BigDecimal bigDecimal6 = Env.ONE;
        BigDecimal bigDecimal7 = Env.ONE;
        if (bigDecimal2.doubleValue() != 0.0) {
            bigDecimal6 = bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128);
            bigDecimal3 = bigDecimal3.multiply(bigDecimal6).setScale(mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
            bigDecimal4 = bigDecimal4.multiply(bigDecimal6).setScale(mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
        }
        if (n8 != 0) {
            bigDecimal7 = MConversionRate.getRate((Properties)properties, (int)n8);
        } else if (n11 > 0 && n10 > 0 && n11 != n10) {
            this.log.fine("InvCurrency=" + n10 + ", PayCurrency=" + n11 + ", Date=" + timestamp + ", Type=" + n7);
            bigDecimal7 = MConversionRate.getRate((int)n10, (int)n11, (Timestamp)timestamp, (int)n7, (int)n5, (int)n6);
        }
        if (bigDecimal7 == null || bigDecimal7.compareTo(Env.ZERO) == 0) {
            return "NoCurrencyConversion";
        }
        this.log.fine("Rate=" + bigDecimal7 + ", InvoiceOpenAmt=" + bigDecimal);
        bigDecimal2 = bigDecimal.multiply(bigDecimal7).setScale(mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
        bigDecimal4 = bigDecimal4.multiply(bigDecimal7).setScale(mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
        bigDecimal3 = bigDecimal3.multiply(bigDecimal7).setScale(mCurrency.getStdPrecision(), RoundingMode.HALF_UP);
        bigDecimal5 = bigDecimal2.subtract(bigDecimal4).subtract(bigDecimal3);
        gridTab.setValue("OpenAmt", (Object)bigDecimal2);
        gridTab.setValue("PayAmt", (Object)bigDecimal4);
        gridTab.setValue("DiscountAmt", (Object)bigDecimal3);
        gridTab.setValue("DifferenceAmt", (Object)bigDecimal5);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoice(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = (Integer)object;
        if (n2 == 0) {
            return "";
        }
        int n3 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_Currency_ID");
        Timestamp timestamp = Env.getContextAsDate((Properties)properties, (int)n, (String)"PayDate");
        int n4 = 0;
        int n5 = 0;
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        BigDecimal bigDecimal3 = Env.ZERO;
        Boolean bl = Boolean.FALSE;
        String string2 = "SELECT COALESCE(invoiceOpen(i.C_Invoice_ID, 0),0) AS AmtSource, COALESCE(currencyConvert(invoiceOpen(i.C_Invoice_ID, 0), i.C_Currency_ID,?, i.DateInvoiced, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID),0) AS OpenAmt, COALESCE(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),0) AS DiscountAmt, i.IsSOTrx, i.C_ConversionType_ID, i.C_BPartner_ID FROM C_Invoice_v i WHERE i.C_Invoice_ID=?";
        ResultSet resultSet = null;
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement((String)string2, null);
            cPreparedStatement.setInt(1, n3);
            cPreparedStatement.setTimestamp(2, timestamp);
            cPreparedStatement.setInt(3, n2);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                bigDecimal = resultSet.getBigDecimal(1);
                bigDecimal2 = resultSet.getBigDecimal(2);
                bigDecimal3 = resultSet.getBigDecimal(3);
                bl = "Y".equals(resultSet.getString(4));
                n4 = resultSet.getInt(5);
                n5 = resultSet.getInt(6);
            }
            DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        catch (SQLException sQLException) {
            this.log.log(Level.SEVERE, string2, (Throwable)sQLException);
        }
        finally {
            DB.close(resultSet, (Statement)cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        this.log.fine(" - OpenAmt=" + bigDecimal2 + " (Invoice=" + n2 + ",Currency=" + n3 + ")");
        gridTab.setValue("AmtSource", (Object)bigDecimal);
        gridTab.setValue("OpenAmt", (Object)bigDecimal2);
        gridTab.setValue("PayAmt", (Object)bigDecimal2.subtract(bigDecimal3));
        gridTab.setValue("DiscountAmt", (Object)bigDecimal3);
        gridTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        gridTab.setValue("IsSOTrx", (Object)bl);
        gridTab.setValue("C_ConversionType_ID", (Object)n4);
        gridTab.setValue("C_BPartner_ID", (Object)n5);
        MInvoice mInvoice = new MInvoice(properties, n2, null);
        if (gridTab.getValue("PaymentRule") == null) {
            gridTab.setValue("PaymentRule", (Object)mInvoice.getPaymentRule());
        }
        Optional<String> optional = Optional.ofNullable(mInvoice.getDescription());
        Optional<String> optional2 = Optional.ofNullable((String)gridTab.getValue("Description"));
        optional.ifPresent(string -> {
            String string2 = optional2.orElse("").isEmpty() ? string : optional2.orElse("") + " " + string;
            gridTab.setValue("Description", (Object)string2);
        });
        List list = MBPBankAccount.getByPartner((Properties)properties, (int)mInvoice.getC_BPartner_ID());
        list.stream().findFirst().ifPresent(mBPBankAccount -> gridTab.setValue("C_BP_BankAccount_ID", (Object)mBPBankAccount.getC_BP_BankAccount_ID()));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String order(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = (Integer)object;
        if (n2 == 0) {
            return "";
        }
        int n3 = Env.getContextAsInt((Properties)properties, (int)n, (String)"C_Currency_ID");
        Timestamp timestamp = Env.getContextAsDate((Properties)properties, (int)n, (String)"PayDate");
        int n4 = 0;
        int n5 = 0;
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        Boolean bl = Boolean.FALSE;
        String string = "SELECT o.GrandTotal, currencyConvert(o.GrandTotal, o.C_Currency_ID,?, o.DateOrdered, o.C_ConversionType_ID, o.AD_Client_ID, o.AD_Org_ID), o.IsSOTrx, o.C_ConversionType_ID, o.C_BPartner_ID FROM C_Order o WHERE o.C_Order_ID = ?";
        ResultSet resultSet = null;
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement((String)string, null);
            cPreparedStatement.setInt(1, n3);
            cPreparedStatement.setInt(2, n2);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                bigDecimal = resultSet.getBigDecimal(1);
                bigDecimal2 = resultSet.getBigDecimal(2);
                bl = "Y".equals(resultSet.getString(3));
                n4 = resultSet.getInt(4);
                n5 = resultSet.getInt(5);
            }
            DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        catch (SQLException sQLException) {
            this.log.log(Level.SEVERE, string, (Throwable)sQLException);
        }
        finally {
            DB.close(resultSet, (Statement)cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        this.log.fine(" - OpenAmt=" + bigDecimal2 + " (Order=" + n2 + ",Currency=" + n3 + ")");
        gridTab.setValue("AmtSource", (Object)bigDecimal);
        gridTab.setValue("OpenAmt", (Object)bigDecimal2);
        gridTab.setValue("PayAmt", (Object)bigDecimal2);
        gridTab.setValue("DiscountAmt", (Object)Env.ZERO);
        gridTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        gridTab.setValue("IsSOTrx", (Object)bl);
        gridTab.setValue("C_ConversionType_ID", (Object)n4);
        gridTab.setValue("C_BPartner_ID", (Object)n5);
        return "";
    }

    public String payrollMovement(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = (Integer)object;
        if (n2 == 0) {
            return "";
        }
        X_HR_Movement x_HR_Movement = new X_HR_Movement(properties, n2, null);
        X_HR_Concept x_HR_Concept = new X_HR_Concept(properties, x_HR_Movement.getHR_Concept_ID(), null);
        if (!x_HR_Concept.getColumnType().equals("A")) {
            return "@HR_Concept_ID@ <> @Amount@";
        }
        X_HR_Payroll x_HR_Payroll = new X_HR_Payroll(properties, x_HR_Movement.getHR_Payroll_ID(), null);
        if (x_HR_Payroll.getC_Charge_ID() == 0) {
            return "@C_Charge_ID@ @NotFound@";
        }
        gridTab.setValue("PayAmt", (Object)x_HR_Movement.getAmount());
        gridTab.setValue("C_Charge_ID", (Object)x_HR_Payroll.getC_Charge_ID());
        gridTab.setValue("C_BPartner_ID", (Object)x_HR_Movement.getC_BPartner_ID());
        return "";
    }

    public String bankAccount(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = (Integer)object;
        if (n2 == 0) {
            return "";
        }
        MBankAccount mBankAccount = MBankAccount.get((Properties)properties, (int)n2);
        if (mBankAccount == null) {
            return "";
        }
        gridTab.setValue("C_Currency_ID", (Object)mBankAccount.getC_Currency_ID());
        return "";
    }
}

