/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.io.File;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.LMX.model.MLMXDocument;
import org.eevolution.hr.process.SendPayrollReceiptByEmailAbstract;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class SendPayrollReceiptByEmail
extends SendPayrollReceiptByEmailAbstract {
    private int counter = 0;
    private int errors = 0;

    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.getMailTextId());
        MMailText mMailText = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        if (mMailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.getMailTextId() + " @NotFound@ ");
        }
        MClient mClient = MClient.get((Properties)this.getCtx());
        if (mClient.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (mClient.getSMTPHost() == null || mClient.getSMTPHost().isEmpty()) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long l = System.currentTimeMillis();
        this.sendEMail(mMailText);
        return "@Created@=" + this.counter + ", @Errors@=" + this.errors + " - " + (System.currentTimeMillis() - l) + "ms";
    }

    private void sendEMail(MMailText mMailText) {
        int[] nArray = this.getPaymentIds();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray[i];
            Boolean bl = this.sendIndividualMail(mMailText, n2, null, this.get_TrxName());
            if (bl == null) continue;
            if (bl.booleanValue()) {
                ++this.counter;
                continue;
            }
            ++this.errors;
        }
    }

    private Boolean sendIndividualMail(MMailText mMailText, int n, String string, String string2) {
        try {
            Object object;
            MPayment mPayment = new MPayment(this.getCtx(), n, string2);
            if (mPayment == null) {
                throw new AdempiereException("@C_Payment_ID@ @NotFound@");
            }
            MBPartner mBPartner = (MBPartner)mPayment.getC_BPartner();
            Object object2 = mMailText.getMailText(true);
            if (string != null) {
                object2 = (String)object2 + string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation mBPartnerLocation = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", stringBuffer.toString(), string2).setOnlyActiveRecords(true).setParameters(new Object[]{mBPartner.getC_BPartner_ID(), "Primary"}).first();
            if (mBPartnerLocation == null) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @NotFound@");
                return false;
            }
            DefaultNotifier defaultNotifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(string2);
            defaultNotifier.clearMessage().withApplicationType("UDP").withText(mMailText.getMailHeader()).withUserId(this.getAD_User_ID()).withDescription(mMailText.getMailHeader()).withEntity(MPayment.Table_ID, n);
            this.getXML(mPayment).forEach(arg_0 -> ((DefaultNotifier)defaultNotifier).addAttachment(arg_0));
            String string3 = null;
            string3 = mBPartnerLocation.getEMail();
            if (Util.isEmpty((String)string3) && (object = this.getBPAccountInfo(mPayment, true)) != null && Util.isEmpty((String)(string3 = object.getA_EMail())) && object.getAD_User_ID() != 0) {
                MUser mUser = MUser.get((Properties)this.getCtx(), (int)object.getAD_User_ID());
                string3 = mUser.getEMail();
            }
            if (((Optional)(object = Arrays.stream(MUser.getOfBPartner((Properties)this.getCtx(), (int)mBPartner.getC_BPartner_ID(), (String)this.get_TrxName())).findFirst())).isPresent()) {
                defaultNotifier.addRecipient(((MUser)((Optional)object).get()).getAD_User_ID());
            } else {
                defaultNotifier.addRecipient(string3);
            }
            this.addLog(0, null, null, mBPartner.getName() + " @MessageAddedToQueue@ @AD_Attachment_ID@ : " + defaultNotifier.getAttachments().size());
            defaultNotifier.addToQueue();
            return true;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public MBPBankAccount getBPAccountInfo(MPayment mPayment, boolean bl) {
        if (mPayment.getC_BP_BankAccount_ID() != 0) {
            return (MBPBankAccount)mPayment.getC_BP_BankAccount();
        }
        if (bl) {
            List list = MBPBankAccount.getByPartner((Properties)Env.getCtx(), (int)mPayment.getC_BPartner_ID());
            if (list == null || list.size() == 0) {
                return null;
            }
            Optional<MBPBankAccount> optional = list.stream().filter(mBPBankAccount -> mBPBankAccount.isACH()).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
            list.get(0);
        }
        return null;
    }

    private int[] getPaymentIds() {
        ArrayList<Constable> arrayList = new ArrayList<Constable>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS (SELECT 1 FROM C_PaySelectionCheck psc ").append("INNER JOIN C_PaySelectionLine psl ON(psc.C_PaySelection_ID = psl.C_PaySelection_ID AND psl.C_BPartner_ID = psc.C_BPartner_ID) ").append("INNER JOIN HR_Movement m ON (psl.HR_Movement_ID = m.HR_Movement_ID) ").append("WHERE C_Payment.C_Payment_ID = psc.C_Payment_ID ").append("AND m.HR_Process_ID = ? ");
        arrayList.add(Integer.valueOf(this.getHRProcessId()));
        if (this.getBPartnerId() > 0) {
            stringBuffer.append("AND psc.C_BPartner_ID=? ");
            arrayList.add(Integer.valueOf(this.getBPartnerId()));
        }
        if (this.getDepartmentId() > 0) {
            stringBuffer.append("AND m.HR_Department_ID=? ");
            arrayList.add(Integer.valueOf(this.getDepartmentId()));
        }
        if (this.getJobId() > 0) {
            stringBuffer.append("AND m.HR_Job_ID=? ");
            arrayList.add(Integer.valueOf(this.getJobId()));
        }
        if (this.getActivityId() > 0) {
            stringBuffer.append("AND m.C_Activity_ID=? ");
            arrayList.add(Integer.valueOf(this.getActivityId()));
        }
        if (this.getBPGroupId() > 0) {
            stringBuffer.append("AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = psc.C_BPartner_ID AND bp.IsEmployee=? AND bp.C_BP_Group_ID = ?)");
            arrayList.add(Boolean.valueOf(true));
            arrayList.add(Integer.valueOf(this.getBPGroupId()));
        }
        stringBuffer.append(")");
        return new Query(this.getCtx(), "C_Payment", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).getIDs();
    }

    private File getPDF(Integer n) {
        if (n <= 0) {
            return null;
        }
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(this.getADProcessId())).withTitle(SendPayrollReceiptByEmail.getProcessName()).withRecordId(Integer.valueOf(MPayment.Table_ID), n).execute();
        return processInfo.getPDFReport();
    }

    private List<File> getXML(MPayment mPayment) {
        return Optional.ofNullable(MLMXDocument.get((PO)mPayment)).map(MLMXDocument::getAttacments).orElseGet(ArrayList::new);
    }
}

