/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_AD_WF_EventAudit;
import org.adempiere.core.domains.models.I_C_AllocationHdr;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.core.domains.models.I_C_Payment;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wf.MWFEventAudit;
import org.eevolution.service.FactAccountService$;
import org.eevolution.service.InvoiceService$;
import org.eevolution.service.PaymentService$;
import scala.Option$;
import scala.runtime.BoxesRunTime;

public class ModelValidatorFunsalud
implements ModelValidator,
FactsValidator {
    private final CLogger logger = CLogger.getCLogger(this.getClass());
    private final int clientId;
    private final String withoutErrors;

    public ModelValidatorFunsalud() {
        this.clientId = -1;
        this.withoutErrors = "";
    }

    public CLogger logger() {
        return this.logger;
    }

    public int clientId() {
        return this.clientId;
    }

    public String withoutErrors() {
        return this.withoutErrors;
    }

    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("AD_WF_EventAudit", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addFactsValidate("C_AllocationHdr", (FactsValidator)this);
        engine.addFactsValidate("C_Invoice", (FactsValidator)this);
    }

    public String login(int orgId, int roleId, int userId) {
        return this.withoutErrors();
    }

    public int getAD_Client_ID() {
        int clientId = Env.getAD_Client_ID((Properties)Env.getCtx());
        return clientId;
    }

    public String modelChange(PO entity, int typeEvent) {
        PO pO = entity;
        if (2 == typeEvent && entity.get_ColumnIndex("C_Project_ID") > 0 && entity.get_ValueAsInt("C_Project_ID") <= 0) {
            int projectId = Env.getContextAsInt((Properties)entity.getCtx(), (String)"C_Project_ID");
            if (projectId > 0) {
                entity.set_ValueOfColumn("C_Project_ID", (Object)BoxesRunTime.boxToInteger((int)projectId));
            }
            return this.withoutErrors();
        }
        if (5 == typeEvent && I_AD_WF_EventAudit.Table_ID == entity.get_Table_ID()) {
            MWFEventAudit event;
            if (entity.is_ValueChanged("WFState") && (event = (MWFEventAudit)entity).getAD_Table_ID() == I_C_Invoice.Table_ID && event.getWFState().equals("CA") && event.getAttributeName().equals("IsApproved") && event.getNewValue() != null && event.getNewValue().equals("N")) {
                MInvoice invoice = new MInvoice(event.getCtx(), event.getRecord_ID(), event.get_TrxName());
                String textMessage = (String)Option$.MODULE$.apply((Object)event.getTextMsg()).getOrElse(ModelValidatorFunsalud::$anonfun$1);
                InvoiceService$.MODULE$.voidIt(invoice, textMessage);
            }
            return this.withoutErrors();
        }
        return this.withoutErrors();
    }

    public String docValidate(PO entity, int timing) {
        PO pO = entity;
        if (I_C_Invoice.Table_ID == entity.get_Table_ID() && 10 == timing) {
            return InvoiceService$.MODULE$.voidIt((MInvoice)entity, timing);
        }
        if (I_C_Payment.Table_ID == entity.get_Table_ID() && 9 == timing) {
            return PaymentService$.MODULE$.completeIt((MPayment)entity, timing);
        }
        return this.withoutErrors();
    }

    public String factsValidate(MAcctSchema accountSchema, List<Fact> accountingFacts, PO po) {
        MInvoice invoice;
        if (I_C_AllocationHdr.Table_ID == po.get_Table_ID() && accountingFacts != null && accountingFacts.size() > 0) {
            FactAccountService$.MODULE$.changeTaxAccountToRetentionAccount(accountSchema, accountingFacts, (MAllocationHdr)po);
        }
        if (I_C_Invoice.Table_ID == po.get_Table_ID() && accountingFacts != null && accountingFacts.size() > 0 && !(invoice = (MInvoice)po).isSOTrx()) {
            FactAccountService$.MODULE$.changeTaxAccountToExpenseAccountOnInvoice(accountSchema, accountingFacts, invoice);
        }
        if (I_C_AllocationHdr.Table_ID == po.get_Table_ID()) {
            FactAccountService$.MODULE$.applyIncome(accountSchema, accountingFacts, (MAllocationHdr)po);
        }
        return this.withoutErrors();
    }

    private static final String $anonfun$1() {
        return "";
    }
}

