/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.eevolution.process.CreateEquityPaymentsAbstract;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class CreateEquityPayments
extends CreateEquityPaymentsAbstract {
    @Override
    public void prepare() {
        super.prepare();
    }

    public String doIt() {
        Option optionPaymentSource = Option$.MODULE$.apply((Object)new MPayment(this.getCtx(), this.getPaymentId(), this.get_TrxName()));
        optionPaymentSource.foreach((Function1)(JProcedure1 & Serializable)paymentSource -> {
            this.IsValidPayment((MPayment)paymentSource);
            int partnerId = MOrg.get((Properties)this.getCtx(), (int)paymentSource.getAD_Org_ID()).getLinkedC_BPartner_ID(this.get_TrxName());
            if (partnerId <= 0) {
                throw new AdempiereException("@LinkedC_BPartner_ID@ @NotFound@");
            }
            MPayment expense = new MPayment(this.getCtx(), 0, this.get_TrxName());
            expense.setC_BankAccount_ID(this.getToCBankAccountId());
            expense.setDocumentNo(paymentSource.getDocumentNo());
            expense.setC_BPartner_ID(partnerId);
            expense.setIsReceipt(false);
            expense.setDateAcct(this.getDateAcct());
            expense.setDateTrx(this.getDateAcct());
            expense.setC_Currency_ID(paymentSource.getC_Currency_ID());
            expense.setC_ConversionType_ID(paymentSource.getC_ConversionType_ID());
            expense.setC_Charge_ID(this.getToCChargeId());
            expense.setPayAmt(this.getChargeAmt());
            expense.setTenderType(paymentSource.getTenderType());
            expense.setC_Project_ID(this.getProjectId());
            expense.setDescription(paymentSource.getDocumentInfo());
            expense.setOrig_TrxID(BoxesRunTime.boxToInteger((int)paymentSource.getC_Payment_ID()).toString());
            expense.setDocStatus("DR");
            expense.setDocAction("CO");
            expense.save();
            expense.processIt("CO");
            expense.saveEx();
            this.addLog(expense.getC_Payment_ID(), expense.getDateAcct(), expense.getPayAmt(), expense.getDocumentInfo());
            MPayment income = new MPayment(this.getCtx(), 0, this.get_TrxName());
            income.setDocumentNo(paymentSource.getDocumentNo());
            income.setC_BankAccount_ID(this.getCBankAccountId());
            income.setC_BPartner_ID(partnerId);
            income.setIsReceipt(true);
            income.setC_Currency_ID(paymentSource.getC_Currency_ID());
            income.setDateAcct(this.getDateAcct());
            income.setDateAcct(this.getDateAcct());
            income.setC_ConversionType_ID(paymentSource.getC_ConversionType_ID());
            income.setC_Charge_ID(this.getCChargeId());
            income.setPayAmt(this.getChargeAmt());
            income.setTenderType(paymentSource.getTenderType());
            income.setDescription(paymentSource.getDocumentInfo());
            income.setOrig_TrxID(BoxesRunTime.boxToInteger((int)paymentSource.getC_Payment_ID()).toString());
            income.setDocStatus("DR");
            income.setDocAction("CO");
            income.saveEx();
            income.processIt("CO");
            income.saveEx();
            this.addLog(income.getC_Payment_ID(), income.getDateAcct(), income.getPayAmt(), income.getDocumentInfo());
        });
        return "@Ok@";
    }

    public void IsValidPayment(MPayment payment) {
        if (!"CO".equals(payment.getDocStatus())) {
            throw new AdempiereException("@C_Payment_ID@ debe estar completo");
        }
        if (!payment.isReceipt()) {
            throw new AdempiereException("@C_Payment_ID@ debe ser un cobro");
        }
        if (payment.getC_Project_ID() <= 0) {
            throw new AdempiereException("@C_Project_ID@ @NotFound@");
        }
        if (this.IsEquityGenerated(Predef$.MODULE$.int2Integer(payment.getC_Payment_ID()))) {
            throw new AdempiereException(new java.lang.StringBuilder(60).append("@C_Payment_ID@ ").append(payment.getDocumentInfo()).append(" el patrimonio para este pago ya fue generado").toString());
        }
    }

    public boolean IsEquityGenerated(Integer paymentId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("Orig_TrxID").append("=?");
        return new Query(this.getCtx(), "C_Payment", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{paymentId.toString()}).match();
    }
}

