/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.I_C_Currency;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.process.ProjectGenerateNotRealizedGainLossAbstract;

public class ProjectGenerateNotRealizedGainLoss
extends ProjectGenerateNotRealizedGainLossAbstract {
    private final HashMap<Integer, MJournalBatch> journalBatches = new HashMap();
    private final HashMap<String, MJournal> journals = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() {
        AtomicInteger atomicInteger = new AtomicInteger(10);
        this.getAccountingSchemes().forEach(mAcctSchema -> this.getProjects((MAcctSchema)mAcctSchema).forEach(mProject -> {
            ProjectBalance projectBalance = this.getProjectBalance((MProject)mProject, (MAcctSchema)mAcctSchema);
            if (projectBalance.endingBalanceSource.signum() != 0) {
                int n = MConversionRate.getConversionRateId((int)mProject.getC_Currency_ID(), (int)mAcctSchema.getC_Currency_ID(), (Timestamp)this.getDateReval(), (int)this.getConversionTypeRevalId(), (int)this.getAD_Client_ID(), (int)mProject.getAD_Org_ID());
                if (n > 0) {
                    MConversionRate mConversionRate = MConversionRate.get((Properties)this.getCtx(), (int)n);
                    BigDecimal bigDecimal = projectBalance.endingBalanceSource.multiply(mConversionRate.getMultiplyRate());
                    projectBalance.rate = mConversionRate.getMultiplyRate();
                    projectBalance.endingBalanceExchange = bigDecimal.setScale(2, 4);
                    BigDecimal bigDecimal2 = projectBalance.endingBalance.subtract(projectBalance.endingBalanceExchange);
                    if (bigDecimal2.signum() > 0) {
                        projectBalance.exchangeLoss = bigDecimal2;
                    } else if (bigDecimal2.signum() < 0) {
                        projectBalance.exchangeGain = bigDecimal2.abs();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    MConversionType mConversionType = new MConversionType(this.getCtx(), this.getConversionTypeRevalId(), this.get_TrxName());
                    stringBuilder.append("@C_Project_ID@ ").append(mProject.getName()).append(" @C_ConversionTypeReval_ID@ ").append(mConversionType.getName()).append(" @C_Conversion_Rate_ID@ @From@ @C_Currency_ID@ ").append(mProject.getC_Currency().getISO_Code()).append(" @to@ @C_Currency_ID@ ").append(mAcctSchema.getC_Currency().getISO_Code()).append(" @DateReval@ ").append(this.getDateReval()).append(" @NotFound@");
                    throw new AdempiereException(stringBuilder.toString());
                }
                this.exchangeGainLoss((MAcctSchema)mAcctSchema, (MProject)mProject, projectBalance, atomicInteger);
            }
        }));
        return "@Ok@";
    }

    private void exchangeGainLoss(MAcctSchema mAcctSchema, MProject mProject, ProjectBalance projectBalance, AtomicInteger atomicInteger) {
        MJournalBatch mJournalBatch = this.createJournalBatch(mAcctSchema, mProject);
        MJournal mJournal = this.createJournal(mAcctSchema, mJournalBatch, mProject);
        this.createJournalLine(mAcctSchema, mJournal, mProject, projectBalance, atomicInteger);
    }

    private MJournalBatch createJournalBatch(MAcctSchema mAcctSchema, MProject mProject) {
        if (this.journalBatches.containsKey(mAcctSchema.get_ID())) {
            return this.journalBatches.get(mAcctSchema.get_ID());
        }
        MJournalBatch mJournalBatch = new MJournalBatch(this.getCtx(), 0, mProject.get_TrxName());
        StringBuilder stringBuilder = new StringBuilder();
        Optional.ofNullable(this.getBatchDescription()).ifPresent(string -> stringBuilder.append((String)string).append(" "));
        stringBuilder.append(this.getName()).append(" @DateAcct@ ").append(this.getDateReval());
        mJournalBatch.setDateAcct(this.getDateReval());
        mJournalBatch.setDateDoc(this.getDateReval());
        mJournalBatch.setAD_Org_ID(mProject.getAD_Org_ID());
        mJournalBatch.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
        mJournalBatch.setC_DocType_ID(this.getDocTypeRevalId());
        mJournalBatch.setDateAcct(this.getDateReval());
        mJournalBatch.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
        mJournalBatch.saveEx();
        this.journalBatches.put(mAcctSchema.get_ID(), mJournalBatch);
        return mJournalBatch;
    }

    private MJournal createJournal(MAcctSchema mAcctSchema, MJournalBatch mJournalBatch, MProject mProject) {
        String string = mProject.getAD_Org_ID() + "+" + mProject.getC_Currency_ID();
        if (this.journals.containsKey(string)) {
            return this.journals.get(string);
        }
        MDocType mDocType = MDocType.get((Properties)this.getCtx(), (int)this.getDocTypeRevalId());
        Integer n = Optional.ofNullable(MGLCategory.getDefaultSystem((Properties)this.getCtx()).get_ID()).orElse(mDocType.getGL_Category_ID());
        MJournal mJournal = new MJournal(mJournalBatch);
        mJournal.setDateAcct(this.getDateReval());
        mJournal.setDateDoc(this.getDateReval());
        mJournal.setC_AcctSchema_ID(mAcctSchema.get_ID());
        mJournal.setAD_Org_ID(mProject.getAD_Org_ID());
        mJournal.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
        mJournal.setC_ConversionType_ID(this.getConversionTypeRevalId());
        mJournal.setGL_Category_ID(n.intValue());
        mJournal.setGL_JournalBatch_ID(mJournalBatch.getGL_JournalBatch_ID());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@C_AcctSchema_ID@ ").append(mAcctSchema.getName()).append(" @C_Currency_ID@ ").append(mProject.getC_Currency().getISO_Code());
        mJournal.setDescription(Msg.parseTranslation((Properties)Env.getCtx(), (String)stringBuilder.toString()));
        mJournal.saveEx();
        this.journals.put(string, mJournal);
        return mJournal;
    }

    private void createJournalLine(MAcctSchema mAcctSchema, MJournal mJournal, MProject mProject, ProjectBalance projectBalance, AtomicInteger atomicInteger) {
        MJournalLine mJournalLine;
        MJournalLine mJournalLine2;
        MAccount mAccount;
        MAcctSchemaDefault mAcctSchemaDefault = Optional.ofNullable(MAcctSchemaDefault.get((Properties)this.getCtx(), (int)mAcctSchema.getC_AcctSchema_ID())).orElseThrow(() -> new AdempiereException("@C_AcctSchema_Default@ @NotFound@"));
        StringBuilder stringBuilder = new StringBuilder();
        I_C_Currency i_C_Currency = mProject.getC_Currency();
        I_C_Currency i_C_Currency2 = mAcctSchema.getC_Currency();
        stringBuilder.append("@C_Project_ID@ ").append(mProject.getValue()).append(" ").append(projectBalance.endingBalanceSource).append(" ").append(i_C_Currency.getISO_Code()).append(" ").append(" ").append(projectBalance.endingBalance).append(" ").append(i_C_Currency2.getISO_Code()).append(" @C_Conversion_Rate_ID@ ").append(Optional.of(projectBalance.rate.toString()).orElse(" @NotFound@ "));
        if (projectBalance.exchangeLoss.signum() > 0) {
            mAccount = MAccount.getValidCombination((Properties)this.getCtx(), (int)mAcctSchemaDefault.getUnrealizedLoss_Acct(), (String)mJournal.get_TrxName());
            stringBuilder.append(" @UnrealizedLoss_Acct@ ").append(projectBalance.exchangeLoss.toString()).append(" ").append(" @EndingBalance@ ").append(projectBalance.endingBalanceExchange).append(" ").append(i_C_Currency2.getISO_Code());
            mJournalLine2 = new MJournalLine(mJournal);
            mJournalLine2.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine2.setAccount_ID(mAccount.getAccount_ID());
            mJournalLine2.setAmtAcctDr(projectBalance.exchangeLoss);
            mJournalLine2.setAmtSourceDr(projectBalance.exchangeLoss);
            mJournalLine2.setAmtAcctCr(BigDecimal.ZERO);
            mJournalLine2.setAmtSourceCr(BigDecimal.ZERO);
            mJournalLine2.setC_Currency_ID(i_C_Currency2.getC_Currency_ID());
            mJournalLine2.setAmtAcctCr(BigDecimal.ZERO);
            mJournalLine2.setC_Project_ID(mProject.getC_Project_ID());
            mJournalLine2.setC_Activity_ID(mProject.getC_Activity_ID());
            mJournalLine2.setC_Campaign_ID(mProject.getC_Campaign_ID());
            mJournalLine2.setUser1_ID(mProject.getUser1_ID());
            mJournalLine2.setUser2_ID(mProject.getUser2_ID());
            mJournalLine2.setUser3_ID(mProject.getUser3_ID());
            mJournalLine2.setUser4_ID(mProject.getUser4_ID());
            mJournalLine2.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
            mJournalLine2.saveEx();
            mJournalLine = new MJournalLine(mJournal);
            mJournalLine.setAccount_ID(mAccount.getAccount_ID());
            mJournalLine.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine.setDescription(mJournalLine2.getDescription());
            mJournalLine.setC_Currency_ID(i_C_Currency2.getC_Currency_ID());
            mJournalLine.setAmtSourceDr(BigDecimal.ZERO);
            mJournalLine.setAmtAcctDr(BigDecimal.ZERO);
            mJournalLine.setAmtSourceCr(projectBalance.exchangeLoss);
            mJournalLine.setAmtAcctCr(projectBalance.exchangeLoss);
            mJournalLine.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
            mJournalLine.saveEx();
            this.addLog(mJournalLine2.getDescription());
        }
        if (projectBalance.exchangeGain.signum() > 0) {
            mAccount = MAccount.getValidCombination((Properties)this.getCtx(), (int)mAcctSchemaDefault.getUnrealizedGain_Acct(), (String)mJournal.get_TrxName());
            stringBuilder.append(" @UnrealizedGain_Acct@ ").append(projectBalance.exchangeGain.toString()).append(" ").append(" @EndingBalance@ ").append(projectBalance.endingBalanceExchange).append(" ").append(i_C_Currency2.getISO_Code());
            mJournalLine2 = new MJournalLine(mJournal);
            mJournalLine2.setAccount_ID(mAccount.getAccount_ID());
            mJournalLine2.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine2.setDescription(mJournalLine2.getDescription());
            mJournalLine2.setC_Currency_ID(i_C_Currency2.getC_Currency_ID());
            mJournalLine2.setAmtSourceDr(projectBalance.exchangeGain);
            mJournalLine2.setAmtAcctDr(projectBalance.exchangeGain);
            mJournalLine2.setAmtSourceCr(BigDecimal.ZERO);
            mJournalLine2.setAmtAcctCr(BigDecimal.ZERO);
            mJournalLine2.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
            mJournalLine2.saveEx();
            mJournalLine = new MJournalLine(mJournal);
            mJournalLine.setLine(atomicInteger.getAndUpdate(n -> n + 10));
            mJournalLine.setAccount_ID(mAccount.getAccount_ID());
            mJournalLine.setC_Currency_ID(i_C_Currency2.getC_Currency_ID());
            mJournalLine.setAmtSourceDr(BigDecimal.ZERO);
            mJournalLine.setAmtAcctDr(BigDecimal.ZERO);
            mJournalLine.setAmtSourceCr(projectBalance.exchangeGain);
            mJournalLine.setAmtAcctCr(projectBalance.exchangeGain);
            mJournalLine.setC_Project_ID(mProject.getC_Project_ID());
            mJournalLine.setC_Activity_ID(mProject.getC_Activity_ID());
            mJournalLine.setC_Campaign_ID(mProject.getC_Campaign_ID());
            mJournalLine.setUser1_ID(mProject.getUser1_ID());
            mJournalLine.setUser2_ID(mProject.getUser2_ID());
            mJournalLine.setUser3_ID(mProject.getUser3_ID());
            mJournalLine.setUser4_ID(mProject.getUser4_ID());
            mJournalLine.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)stringBuilder.toString()));
            mJournalLine.saveEx();
            this.addLog(mJournalLine.getDescription());
        }
    }

    private List<MAcctSchema> getAccountingSchemes() {
        List<MAcctSchema> list = new ArrayList<MAcctSchema>();
        if (this.getAcctSchemaId() > 0) {
            list.add(MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId()));
        } else {
            list = Arrays.asList(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID()));
        }
        return new ArrayList<MAcctSchema>(list);
    }

    private List<MProject> getProjects(MAcctSchema mAcctSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C_Currency_ID").append("<> ?");
        return new Query(this.getCtx(), "C_Project", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{mAcctSchema.getC_Currency_ID()}).list();
    }

    private ProjectBalance getProjectBalance(MProject mProject, MAcctSchema mAcctSchema) {
        String string = "SELECT p.C_Project_ID,        SUM(p.AmtSourceCr - p.AmtSourceDr) AS AmtSourceBalance,        SUM(p.AmtAcctCr - p.AmtAcctDr) AS AmtAcctBalance FROM getProjectBalance( ? , null, ? ) p GROUP BY p.C_Project_ID";
        ArrayList<Comparable<Integer>> arrayList = new ArrayList<Comparable<Integer>>();
        arrayList.add(Integer.valueOf(mProject.getC_Project_ID()));
        arrayList.add(this.getDateReval());
        ProjectBalance projectBalance = new ProjectBalance();
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement((String)string, (String)this.get_TrxName());
            DB.setParameters((PreparedStatement)cPreparedStatement, arrayList);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                projectBalance.projectId = resultSet.getInt("C_Project_ID");
                projectBalance.endingBalanceSource = resultSet.getBigDecimal("AmtSourceBalance");
                projectBalance.endingBalance = resultSet.getBigDecimal("AmtAcctBalance");
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException((Exception)sQLException, string);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, (Statement)cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close((ResultSet)resultSet, (Statement)cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return projectBalance;
    }

    class ProjectBalance {
        Integer projectId;
        BigDecimal endingBalance = BigDecimal.ZERO;
        BigDecimal endingBalanceExchange = BigDecimal.ZERO;
        BigDecimal endingBalanceSource = BigDecimal.ZERO;
        BigDecimal exchangeGain = BigDecimal.ZERO;
        BigDecimal exchangeLoss = BigDecimal.ZERO;
        BigDecimal rate = BigDecimal.ZERO;

        ProjectBalance() {
        }
    }
}

