/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.core.domains.models.I_GL_Journal;
import org.adempiere.core.domains.models.X_C_Project_Acct;
import org.adempiere.core.domains.models.X_C_Tax;
import org.adempiere.core.domains.models.X_C_Tax_Acct;
import org.adempiere.core.domains.models.X_Fact_Acct;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MElementValue;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProject;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.eevolution.service.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class FactAccountService$
implements Serializable {
    private static final String EXPENSE;
    public static final FactAccountService$ MODULE$;

    private FactAccountService$() {
    }

    static {
        MODULE$ = new FactAccountService$();
        EXPENSE = "Gasto";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FactAccountService$.class);
    }

    public String EXPENSE() {
        return EXPENSE;
    }

    public String applyIncome(MAcctSchema accountSchema, java.util.List<Fact> accountingFacts, MAllocationHdr allocation) {
        Object[] allocationLines = allocation.getLines(true);
        Object object = Predef$.MODULE$.refArrayOps(allocationLines);
        if (!ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)allocationLine -> allocationLine.getC_Payment_ID() > 0)) {
            return package$.MODULE$.withoutErrors();
        }
        CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala().headOption().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> FactAccountService$.applyIncome$$anonfun$2((MAllocationLine[])allocationLines, accountSchema, arg_0)));
        return package$.MODULE$.withoutErrors();
    }

    public String applyProjectIncome(MAcctSchema accountSchema, java.util.List<Fact> accountingFacts, MAllocationHdr allocation) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])allocation.getLines(true));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)allocationLine -> allocationLine.getC_Invoice_ID() > 0));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)allocationLine -> {
            Option maybeInvoice = Option$.MODULE$.apply((Object)((MInvoice)allocationLine.getC_Invoice()));
            maybeInvoice.filter((Function1 & Serializable)invoice -> invoice.getC_Project_ID() > 0 && invoice.isSOTrx()).foreach((Function1)(JProcedure1 & Serializable)invoice -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])invoice.getLines());
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)invoiceLine -> invoiceLine.getC_Project_ID() > 0));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)invoiceLine -> {
                    Option maybeProject = Option$.MODULE$.apply((Object)((MProject)invoiceLine.getC_Project()));
                    List<X_Fact_Acct> invoiceAccountingFacts = this.getAccountFact((PO)invoice, accountSchema.get_ID(), Fact.POST_Actual);
                    invoiceAccountingFacts.filter((Function1 & Serializable)invoiceAccountingFact -> invoiceAccountingFact.getLine_ID() > 0).foreach((Function1)(JProcedure1 & Serializable)invoiceAccountingFact -> maybeProject.foreach((Function1)(JProcedure1 & Serializable)project -> this.createAccountLine$1(allocation, (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MProject)project, (MAllocationLine)allocationLine, accountSchema, accountingFacts, (X_Fact_Acct)invoiceAccountingFact)));
                });
            });
        });
        return package$.MODULE$.withoutErrors();
    }

    public String changeTaxAccountToExpenseAccountOnInvoice(MAcctSchema accountSchema, java.util.List<Fact> accountingFacts, MInvoice invoice) {
        CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala().headOption().foreach((Function1)(JProcedure1 & Serializable)accountingFact -> {
            Option maybeInvoice = Option$.MODULE$.apply((Object)invoice);
            maybeInvoice.foreach((Function1)(JProcedure1 & Serializable)invoice -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])invoice.getLines());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)invoiceLine -> {
                    Option maybeTax = Option$.MODULE$.apply((Object)((MTax)invoiceLine.getC_Tax()));
                    if (maybeTax.isDefined()) {
                        if (((X_C_Tax)maybeTax.get()).isSummary()) {
                            Option maybeChildTaxes = Option$.MODULE$.apply((Object)((MTax)maybeTax.get()).getChildTaxes(true));
                            if (maybeChildTaxes.isDefined()) {
                                Object object = Predef$.MODULE$.refArrayOps((Object[])maybeChildTaxes.get());
                                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)taxChild -> {
                                    if (taxChild.getRate().signum() > 0) {
                                        MODULE$.createAccountLineOnInvoice(accountSchema, (Fact)accountingFact, (Buffer<Fact>)CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala(), (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)taxChild);
                                        return;
                                    }
                                });
                                return;
                            }
                            return;
                        }
                        if (((X_C_Tax)maybeTax.get()).getRate().signum() > 0) {
                            MODULE$.createAccountLineOnInvoice(accountSchema, (Fact)accountingFact, (Buffer<Fact>)CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala(), (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)maybeTax.get());
                            return;
                        }
                        return;
                    }
                });
            });
        });
        return package$.MODULE$.withoutErrors();
    }

    private void createAccountLineOnInvoice(MAcctSchema accountSchema, Fact accountingFact, Buffer<Fact> accountingFacts, MInvoice invoice, MInvoiceLine invoiceLine, MTax tax) {
        if (!Option$.MODULE$.apply((Object)tax.getTaxIndicator()).exists((Function1 & Serializable)TaxIndicator -> TaxIndicator.contains(MODULE$.EXPENSE()))) {
            return;
        }
        Buffer factLines = (Buffer)accountingFacts.flatten((Function1 & Serializable)fact -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])fact.getLines());
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)line -> line, ClassTag$.MODULE$.apply(FactLine.class))).toList();
        });
        this.getAccountTax(accountSchema, tax.getC_Tax_ID()).foreach((Function1)(JProcedure1 & Serializable)accountTax -> {
            if (factLines.nonEmpty()) {
                ((IterableOnceOps)factLines.filter((Function1 & Serializable)invoiceFactAccount -> {
                    Object object;
                    return invoiceFactAccount.getRecord_ID() == invoice.getC_Invoice_ID() && invoiceFactAccount.getLine_ID() == invoiceLine.getC_InvoiceLine_ID() && (ArrayOps$.MODULE$.contains$extension(object = Predef$.MODULE$.intArrayOps(this.getTaxChildIds$1(invoice, Predef$.MODULE$.int2Integer(invoiceFactAccount.getC_Tax_ID()))), (Object)BoxesRunTime.boxToInteger((int)tax.getC_Tax_ID())) || invoiceFactAccount.getC_Tax_ID() == tax.getC_Tax_ID());
                })).foreach((Function1)(JProcedure1 & Serializable)invoiceFactAccount -> {
                    MAccount accountExpense = invoiceFactAccount.getAccount();
                    BigDecimal taxRateFactor = tax.getRate().divide(BigDecimal.valueOf(100L));
                    BigDecimal invoiceLineTaxAmountSource = invoiceLine.getLineNetAmt().multiply(taxRateFactor).setScale(accountSchema.getStdPrecision(), RoundingMode.HALF_UP);
                    BigDecimal invoiceLineTaxAmount = MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoiceLineTaxAmountSource, (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                    MDocType docType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocType_ID());
                    if (invoiceLineTaxAmount.signum() != 0) {
                        MAccount taxAccount = MAccount.getValidCombination((Properties)invoice.getCtx(), (int)accountTax.getT_Due_Acct(), (String)accountingFact.get_TrxName());
                        FactLine expenseFactLine = accountingFact.createLine(invoiceFactAccount.getDocLine(), accountExpense, invoice.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                        expenseFactLine.setDocumentInfo(accountingFact.getDocument(), invoiceFactAccount.getDocLine());
                        expenseFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                        expenseFactLine.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                        expenseFactLine.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        expenseFactLine.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        expenseFactLine.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        expenseFactLine.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        expenseFactLine.setC_ProjectPhase_ID(invoiceFactAccount.getC_ProjectPhase_ID());
                        expenseFactLine.setC_ProjectTask_ID(invoiceFactAccount.getC_ProjectTask_ID());
                        expenseFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        expenseFactLine.setC_UOM_ID(invoiceFactAccount.getC_UOM_ID());
                        expenseFactLine.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        expenseFactLine.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        expenseFactLine.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        expenseFactLine.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        expenseFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        expenseFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        expenseFactLine.setC_Tax_ID(tax.getC_Tax_ID());
                        expenseFactLine.setLine_ID(invoiceFactAccount.getLine_ID());
                        if ("APC".equals(docType.getDocBaseType())) {
                            expenseFactLine.setAmtAcctCr(invoiceLineTaxAmount);
                            expenseFactLine.setAmtSourceCr(invoiceLineTaxAmountSource);
                        }
                        if ("API".equals(docType.getDocBaseType())) {
                            expenseFactLine.setAmtAcctDr(invoiceLineTaxAmount);
                            expenseFactLine.setAmtSourceDr(invoiceLineTaxAmountSource);
                        }
                        FactLine taxFactLine = accountingFact.createLine(invoiceFactAccount.getDocLine(), taxAccount, invoice.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                        taxFactLine.setDocumentInfo(accountingFact.getDocument(), invoiceFactAccount.getDocLine());
                        taxFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                        taxFactLine.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                        taxFactLine.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        taxFactLine.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        taxFactLine.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        taxFactLine.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        taxFactLine.setC_ProjectPhase_ID(invoiceFactAccount.getC_ProjectPhase_ID());
                        taxFactLine.setC_ProjectTask_ID(invoiceFactAccount.getC_ProjectTask_ID());
                        taxFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        taxFactLine.setC_UOM_ID(invoiceFactAccount.getC_UOM_ID());
                        taxFactLine.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        taxFactLine.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        taxFactLine.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        taxFactLine.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        taxFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        taxFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        taxFactLine.setC_Tax_ID(tax.getC_Tax_ID());
                        taxFactLine.setLine_ID(invoiceFactAccount.getLine_ID());
                        if ("APC".equals(docType.getDocBaseType())) {
                            taxFactLine.setAmtAcctDr(invoiceLineTaxAmount);
                            taxFactLine.setAmtSourceDr(invoiceLineTaxAmountSource);
                        }
                        if ("API".equals(docType.getDocBaseType())) {
                            taxFactLine.setAmtAcctCr(invoiceLineTaxAmount);
                            taxFactLine.setAmtSourceCr(invoiceLineTaxAmountSource);
                            return;
                        }
                        return;
                    }
                });
                return;
            }
        });
    }

    public String changeTaxAccountToExpenseAccount(MAcctSchema accountSchema, java.util.List<Fact> accountingFacts, MAllocationHdr allocation) {
        CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala().headOption().foreach((Function1)(JProcedure1 & Serializable)accountingFact -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])allocation.getLines(true));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)allocationLine -> allocationLine.getC_Invoice_ID() > 0));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)allocationLine -> {
                Option maybeInvoice = Option$.MODULE$.apply((Object)((MInvoice)allocationLine.getC_Invoice()));
                maybeInvoice.filter((Function1 & Serializable)invoice -> !"RE".equals(invoice.getDocStatus())).foreach((Function1)(JProcedure1 & Serializable)invoice -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])invoice.getLines());
                    ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)invoiceLine -> {
                        Option maybeTax = Option$.MODULE$.apply((Object)((MTax)invoiceLine.getC_Tax()));
                        if (maybeTax.isDefined()) {
                            if (((X_C_Tax)maybeTax.get()).isSummary()) {
                                Option maybeChildTaxes = Option$.MODULE$.apply((Object)((MTax)maybeTax.get()).getChildTaxes(true));
                                if (maybeChildTaxes.isDefined()) {
                                    Object object = Predef$.MODULE$.refArrayOps((Object[])maybeChildTaxes.get());
                                    ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)taxChild -> {
                                        if (taxChild.getRate().signum() > 0) {
                                            this.createAccountLine$2(allocation, accountSchema, (Fact)accountingFact, (MAllocationLine)allocationLine, (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)taxChild);
                                            return;
                                        }
                                    });
                                    return;
                                }
                                return;
                            }
                            if (((X_C_Tax)maybeTax.get()).getRate().signum() > 0) {
                                this.createAccountLine$2(allocation, accountSchema, (Fact)accountingFact, (MAllocationLine)allocationLine, (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)maybeTax.get());
                                return;
                            }
                            return;
                        }
                    });
                });
            });
        });
        return package$.MODULE$.withoutErrors();
    }

    public String changeTaxAccountToRetentionAccount(MAcctSchema accountSchema, java.util.List<Fact> accountingFacts, MAllocationHdr allocation) {
        CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala().headOption().foreach((Function1)(JProcedure1 & Serializable)accountingFact -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])allocation.getLines(true));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)allocationLine -> allocationLine.getC_Invoice_ID() > 0));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)allocationLine -> {
                Option maybeInvoice = Option$.MODULE$.apply((Object)((MInvoice)allocationLine.getC_Invoice()));
                maybeInvoice.filter((Function1 & Serializable)invoice -> !"RE".equals(invoice.getDocStatus())).foreach((Function1)(JProcedure1 & Serializable)invoice -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])invoice.getLines());
                    ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)invoiceLine -> {
                        Option maybeTax = Option$.MODULE$.apply((Object)((MTax)invoiceLine.getC_Tax()));
                        if (maybeTax.isDefined()) {
                            if (((X_C_Tax)maybeTax.get()).isSummary()) {
                                Option maybeChildTaxes = Option$.MODULE$.apply((Object)((MTax)maybeTax.get()).getChildTaxes(true));
                                if (maybeChildTaxes.isDefined()) {
                                    Object object = Predef$.MODULE$.refArrayOps((Object[])maybeChildTaxes.get());
                                    ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)taxChild -> {
                                        if (taxChild.getRate().signum() < 0) {
                                            this.createAccountLine$3(allocation, accountSchema, (Fact)accountingFact, (MAllocationLine)allocationLine, (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)taxChild);
                                            return;
                                        }
                                    });
                                    return;
                                }
                                return;
                            }
                            if (((X_C_Tax)maybeTax.get()).getRate().signum() < 0) {
                                this.createAccountLine$3(allocation, accountSchema, (Fact)accountingFact, (MAllocationLine)allocationLine, (MInvoice)invoice, (MInvoiceLine)invoiceLine, (MTax)maybeTax.get());
                                return;
                            }
                            return;
                        }
                    });
                });
            });
        });
        return package$.MODULE$.withoutErrors();
    }

    public Option<X_C_Project_Acct> getAccountProject(MAcctSchema accountSchema, int projectId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("C_Project_ID").append("=?");
        Option projectAccountOption = Option$.MODULE$.apply((Object)new Query(accountSchema.getCtx(), "C_Project_Acct", whereClause.toString(), accountSchema.get_TrxName()).setClient_ID().setParameters(new Object[]{BoxesRunTime.boxToInteger((int)accountSchema.getC_AcctSchema_ID()), BoxesRunTime.boxToInteger((int)projectId)}).first());
        return projectAccountOption;
    }

    public Option<MElementValue> getAccount(PO po, int accountSchemaId, String accountValue) {
        StringBuilder where = new StringBuilder();
        where.append("EXISTS (SELECT 1 FROM C_ElementValue ev , C_AcctSchema_Element ae WHERE ev.C_ElementValue_ID=C_ElementValue.C_ElementValue_ID AND ");
        where.append("ev.C_Element_ID=ae.C_Element_ID AND ae.ElementType='AC' AND ae.C_AcctSchema_ID=? AND ev.IsActive='Y' AND ev.Value=?)");
        MElementValue account = (MElementValue)new Query(po.getCtx(), "C_ElementValue", where.toString(), po.get_TrxName()).setClient_ID().setParameters(new Object[]{BoxesRunTime.boxToInteger((int)accountSchemaId), accountValue}).first();
        return Option$.MODULE$.apply((Object)account);
    }

    public List<X_Fact_Acct> getAccountFact(PO po, int accountSchemaId, String postingType) {
        return this.getAccountFact(po, accountSchemaId, postingType, (Option<String>)None$.MODULE$);
    }

    public List<X_Fact_Acct> getAccountFact(PO po, int accountSchemaId, String postingType, Option<String> accountValueOption) {
        StringBuilder where = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        where.append("AD_Table_ID").append("=? AND ");
        parameters.add(BoxesRunTime.boxToInteger((int)po.get_Table_ID()));
        where.append("Record_ID").append("=? AND ");
        parameters.add(BoxesRunTime.boxToInteger((int)po.get_ID()));
        where.append("PostingType").append("=?  ");
        parameters.add(postingType);
        accountValueOption.foreach((Function1 & Serializable)accountValue -> {
            where.append(" AND EXISTS (SELECT 1 FROM C_ElementValue ev , C_AcctSchema_Element ae WHERE ev.C_ElementValue_ID=Fact_Acct.Account_ID AND ");
            where.append("ev.C_Element_ID=ae.C_Element_ID AND ae.ElementType='AC' AND ae.C_AcctSchema_ID=? AND ev.IsActive='Y' AND ev.Value=?)");
            parameters.add(BoxesRunTime.boxToInteger((int)accountSchemaId));
            return parameters.add(accountValue);
        });
        List factsAccount = CollectionConverters$.MODULE$.ListHasAsScala(new Query(po.getCtx(), "Fact_Acct", where.toString(), po.get_TrxName()).setClient_ID().setParameters(parameters).list()).asScala().toList();
        return factsAccount;
    }

    public List<X_Fact_Acct> getAccountFactBasedOnInvoice(MInvoice invoice, int accountSchemaId, String postingType, String accountValue) {
        StringBuilder where = new StringBuilder();
        where.append("AD_Table_ID").append("=? AND ");
        where.append("PostingType").append("=? AND ");
        where.append("EXISTS (SELECT 1 FROM GL_Journal j INNER JOIN GL_JournalLine jl ON (jl.GL_Journal_ID = j.GL_Journal_ID) WHERE j.GL_Journal_ID = Fact_Acct.Record_ID AND jl.GL_JournalLine_ID=Fact_Acct.Line_ID AND jl.C_Invoice_ID = ? ) AND ");
        where.append("EXISTS (SELECT 1 FROM C_ElementValue ev , C_AcctSchema_Element ae WHERE ev.C_ElementValue_ID=Fact_Acct.Account_ID AND ");
        where.append("ev.C_Element_ID=ae.C_Element_ID AND ae.ElementType='AC' AND ae.C_AcctSchema_ID=? AND ev.IsActive='Y' AND ev.Value=?)");
        List factAccount = CollectionConverters$.MODULE$.ListHasAsScala(new Query(invoice.getCtx(), "Fact_Acct", where.toString(), invoice.get_TrxName()).setClient_ID().setParameters(new Object[]{BoxesRunTime.boxToInteger((int)I_GL_Journal.Table_ID), postingType, BoxesRunTime.boxToInteger((int)invoice.get_ID()), BoxesRunTime.boxToInteger((int)accountSchemaId), accountValue}).list()).asScala().toList();
        return factAccount;
    }

    public Option<X_C_Tax_Acct> getAccountTax(MAcctSchema accountSchema, int taxId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("C_Tax_ID").append("=?");
        Option taxAccountOption = Option$.MODULE$.apply((Object)new Query(accountSchema.getCtx(), "C_Tax_Acct", whereClause.toString(), accountSchema.get_TrxName()).setClient_ID().setParameters(new Object[]{BoxesRunTime.boxToInteger((int)accountSchema.getC_AcctSchema_ID()), BoxesRunTime.boxToInteger((int)taxId)}).first());
        return taxAccountOption;
    }

    private static final /* synthetic */ void applyIncome$$anonfun$2(MAllocationLine[] allocationLines$1, MAcctSchema accountSchema$1, Fact accountingFact) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])allocationLines$1);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)allocationLine -> allocationLine.getC_Invoice_ID() > 0));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)allocationLine -> {
            Option maybeInvoice = Option$.MODULE$.apply((Object)((MInvoice)allocationLine.getC_Invoice()));
            maybeInvoice.foreach((Function1)(JProcedure1 & Serializable)invoice -> {
                if (invoice.isSOTrx()) {
                    List<X_Fact_Acct> maybeInvoiceFactsAccount = MODULE$.getAccountFact((PO)invoice, accountSchema$1.get_ID(), Fact.POST_Actual);
                    if (maybeInvoiceFactsAccount.isEmpty()) {
                        throw new AdempiereException(new java.lang.StringBuilder(39).append("No existe contabilidad para la factura ").append(invoice.getDocumentInfo()).toString());
                    }
                    maybeInvoiceFactsAccount.filter((Function1 & Serializable)invoiceFactAccount -> invoiceFactAccount.getRecord_ID() == invoice.get_ID() && invoiceFactAccount.getM_Product_ID() > 0).foreach((Function1 & Serializable)invoiceFactAccount -> {
                        int precision = invoice.getC_Currency().getStdPrecision();
                        BigDecimal taxAmount = invoice.getGrandTotal().subtract(invoice.getTotalLines());
                        BigDecimal percentTax = taxAmount.signum() > 0 ? taxAmount.divide(invoice.getTotalLines(), precision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                        BigDecimal allocateAmountWithoutTax = percentTax.signum() != 0 ? allocationLine.getAmount().divide(BigDecimal.ONE.add(percentTax), 12, RoundingMode.HALF_UP) : allocationLine.getAmount();
                        BigDecimal percentInvoice = allocateAmountWithoutTax.compareTo(invoice.getGrandTotal()) >= 0 ? BigDecimal.ONE : allocateAmountWithoutTax.divide(invoiceFactAccount.getAmtSourceCr(), 12, RoundingMode.HALF_UP);
                        BigDecimal expenseAmount = invoiceFactAccount.getAmtSourceCr().multiply(percentInvoice);
                        ProductCost productCost = new ProductCost(invoice.getCtx(), invoiceFactAccount.getM_Product_ID(), 0, invoice.get_TrxName());
                        MAccount revenueAccount = productCost.getAccount(1, accountSchema$1);
                        MAccount accountExpense = MAccount.get((X_Fact_Acct)invoiceFactAccount);
                        FactLine expenseFactLine = accountingFact.createLine(null, accountExpense, invoice.getC_Currency_ID(), expenseAmount, BigDecimal.ZERO);
                        expenseFactLine.setDocumentInfo(accountingFact.getDocument(), null);
                        expenseFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                        expenseFactLine.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        expenseFactLine.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        expenseFactLine.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        expenseFactLine.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        expenseFactLine.setC_ProjectPhase_ID(invoiceFactAccount.getC_ProjectPhase_ID());
                        expenseFactLine.setC_ProjectTask_ID(invoiceFactAccount.getC_ProjectTask_ID());
                        expenseFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        expenseFactLine.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        expenseFactLine.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        expenseFactLine.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        expenseFactLine.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        expenseFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        expenseFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        expenseFactLine.setLine_ID(allocationLine.get_ID());
                        expenseFactLine.save();
                        FactLine revenueFactLine = accountingFact.createLine(null, revenueAccount, invoice.getC_Currency_ID(), BigDecimal.ZERO, expenseAmount);
                        revenueFactLine.setDocumentInfo(accountingFact.getDocument(), null);
                        revenueFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                        revenueFactLine.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                        revenueFactLine.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        revenueFactLine.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        revenueFactLine.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        revenueFactLine.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        revenueFactLine.setC_ProjectPhase_ID(invoiceFactAccount.getC_ProjectPhase_ID());
                        revenueFactLine.setC_ProjectTask_ID(invoiceFactAccount.getC_ProjectTask_ID());
                        revenueFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        revenueFactLine.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        revenueFactLine.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        revenueFactLine.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        revenueFactLine.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        revenueFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        revenueFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        revenueFactLine.setLine_ID(allocationLine.get_ID());
                        return revenueFactLine.save();
                    });
                    return;
                }
            });
        });
    }

    private final void createAccountLine$1(MAllocationHdr allocation$9, MInvoice invoice, MInvoiceLine invoiceLine, MProject project, MAllocationLine allocationLine, MAcctSchema accountSchema, java.util.List accountingFacts, X_Fact_Acct invoiceFactAccount) {
        if (project.getPlannedMarginAmt().signum() > 0) {
            int precision = invoice.getC_Currency().getStdPrecision();
            BigDecimal percentInvoice = allocationLine.getAmount().divide(invoice.getGrandTotal(), precision, RoundingMode.HALF_UP);
            BigDecimal percentInvoiceLine = invoice.getGrandTotal().divide(invoiceLine.getLineTotalAmt(), precision, RoundingMode.HALF_UP);
            this.getAccountProject(accountSchema, project.getC_Project_ID()).foreach((Function1)(JProcedure1 & Serializable)projectAccounting -> {
                MAccount productRevenueAccount = MAccount.get((X_Fact_Acct)invoiceFactAccount);
                BigDecimal amountRevenue = invoiceFactAccount.getAmtSourceCr().multiply(percentInvoice).multiply(percentInvoiceLine);
                Option accountingFactOption = CollectionConverters$.MODULE$.ListHasAsScala(accountingFacts).asScala().headOption();
                accountingFactOption.foreach((Function1)(JProcedure1 & Serializable)accountingFact -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])accountingFact.getLines());
                    ArrayOps$.MODULE$.headOption$extension(object).foreach((Function1 & Serializable)accountingFactLine -> {
                        FactLine revenueByApply = accountingFact.createLine(accountingFactLine.getDocLine(), productRevenueAccount, invoice.getC_Currency_ID(), amountRevenue, BigDecimal.ZERO);
                        revenueByApply.setDocumentInfo(accountingFact.getDocument(), accountingFactLine.getDocLine());
                        revenueByApply.setLine_ID(invoiceFactAccount.getLine_ID());
                        revenueByApply.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        revenueByApply.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        revenueByApply.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        revenueByApply.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        revenueByApply.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        revenueByApply.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                        revenueByApply.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        revenueByApply.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        revenueByApply.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        revenueByApply.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        revenueByApply.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        revenueByApply.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        revenueByApply.setLine_ID(allocationLine.get_ID());
                        revenueByApply.save();
                        MAccount projectlAccount = MAccount.getValidCombination((Properties)project.getCtx(), (int)projectAccounting.getPJ_Asset_Acct(), (String)accountingFact.get_TrxName());
                        FactLine revenueByApplied = accountingFact.createLine(accountingFactLine.getDocLine(), projectlAccount, allocation$9.getC_Currency_ID(), BigDecimal.ZERO, amountRevenue);
                        revenueByApplied.setDocumentInfo(accountingFact.getDocument(), accountingFactLine.getDocLine());
                        revenueByApplied.setLine_ID(invoiceFactAccount.getLine_ID());
                        revenueByApplied.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                        revenueByApplied.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                        revenueByApplied.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                        revenueByApplied.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                        revenueByApplied.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                        revenueByApplied.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                        revenueByApplied.setUser1_ID(invoiceFactAccount.getUser1_ID());
                        revenueByApplied.setUser2_ID(invoiceFactAccount.getUser2_ID());
                        revenueByApplied.setUser3_ID(invoiceFactAccount.getUser3_ID());
                        revenueByApplied.setUser4_ID(invoiceFactAccount.getUser4_ID());
                        revenueByApplied.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                        revenueByApplied.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                        revenueByApplied.setLine_ID(allocationLine.get_ID());
                        return revenueByApplied.save();
                    });
                });
            });
            return;
        }
    }

    private final int[] getTaxChildIds$1(MInvoice invoice$13, Integer taxId) {
        return new Query(invoice$13.getCtx(), "C_Tax", new java.lang.StringBuilder(36).append("Parent_Tax_ID").append(" = ?  AND ").append("IsSummary").append(" = ?").toString(), invoice$13.get_TrxName()).setClient_ID().setParameters(new Object[]{taxId, "N"}).getIDs();
    }

    private final BigDecimal invoiceLineNetTaxAmount$lzyINIT1$1(LazyRef invoiceLineNetTaxAmount$lzy1$1, MInvoice invoice$22, MAllocationHdr allocation$18, MInvoiceLine invoiceLine$11, MAcctSchema accountSchema$23, BigDecimal allocationLineAmount$1, BigDecimal invoiceTotal$1, MTax tax$7, BigDecimal invoiceLineTaxAmount$1, X_C_Tax_Acct accountTax$3, Fact accountingFact$16, MAccount accountExpense$2, X_Fact_Acct invoiceFactAccount$4, MAllocationLine allocationLine$15) {
        BigDecimal bigDecimal;
        LazyRef lazyRef = invoiceLineNetTaxAmount$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (invoiceLineNetTaxAmount$lzy1$1.initialized()) {
                object = invoiceLineNetTaxAmount$lzy1$1.value();
            } else {
                BigDecimal bigDecimal2;
                if (invoice$22.getC_Currency_ID() == allocation$18.getC_Currency_ID()) {
                    bigDecimal2 = invoiceLine$11.getLineNetAmt();
                } else {
                    MConversionRate.convert((Properties)invoice$22.getCtx(), (BigDecimal)invoiceLine$11.getLineNetAmt(), (int)invoice$22.getC_Currency_ID(), (int)accountSchema$23.getC_Currency_ID(), (Timestamp)invoice$22.getDateAcct(), (int)invoice$22.getC_ConversionType_ID(), (int)invoice$22.getAD_Client_ID(), (int)invoice$22.getAD_Org_ID());
                    int precision = invoice$22.getC_Currency().getStdPrecision();
                    BigDecimal percentInvoice = allocationLineAmount$1.divide(invoiceTotal$1, 12, RoundingMode.HALF_UP);
                    BigDecimal taxAmount = invoiceLine$11.getC_Tax_ID() == tax$7.get_ID() ? invoiceLineTaxAmount$1 : this.invoiceLineNetTaxAmount$1(invoiceLineNetTaxAmount$lzy1$1, invoice$22, allocation$18, invoiceLine$11, accountSchema$23, allocationLineAmount$1, invoiceTotal$1, tax$7, invoiceLineTaxAmount$1, accountTax$3, accountingFact$16, accountExpense$2, invoiceFactAccount$4, allocationLine$15).multiply(tax$7.getRate()).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                    BigDecimal expenseAmountSource = taxAmount.multiply(percentInvoice).setScale(accountSchema$23.getStdPrecision(), RoundingMode.HALF_UP);
                    BigDecimal expenseAmountBase = MConversionRate.convert((Properties)invoice$22.getCtx(), (BigDecimal)expenseAmountSource, (int)invoice$22.getC_Currency_ID(), (int)accountSchema$23.getC_Currency_ID(), (Timestamp)invoice$22.getDateAcct(), (int)invoice$22.getC_ConversionType_ID(), (int)invoice$22.getAD_Client_ID(), (int)invoice$22.getAD_Org_ID()).setScale(accountSchema$23.getStdPrecision(), RoundingMode.HALF_UP);
                    MAccount taxAccount = MAccount.getValidCombination((Properties)invoice$22.getCtx(), (int)accountTax$3.getT_Receivables_Acct(), (String)accountingFact$16.get_TrxName());
                    FactLine expenseFactLine = accountingFact$16.createLine(null, accountExpense$2, invoice$22.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                    expenseFactLine.setDocumentInfo(accountingFact$16.getDocument(), null);
                    expenseFactLine.setC_BPartner_ID(invoiceFactAccount$4.getC_BPartner_ID());
                    expenseFactLine.setAD_OrgTrx_ID(invoiceLine$11.getAD_OrgTrx_ID());
                    expenseFactLine.setC_Activity_ID(invoiceLine$11.getC_Activity_ID());
                    expenseFactLine.setC_Campaign_ID(invoiceLine$11.getC_Campaign_ID());
                    expenseFactLine.setC_Project_ID(invoiceLine$11.getC_Project_ID());
                    expenseFactLine.setC_ProjectPhase_ID(invoiceLine$11.getC_ProjectPhase_ID());
                    expenseFactLine.setC_ProjectTask_ID(invoiceLine$11.getC_ProjectTask_ID());
                    expenseFactLine.setC_SalesRegion_ID(invoiceFactAccount$4.getC_SalesRegion_ID());
                    expenseFactLine.setUser1_ID(invoiceLine$11.getUser1_ID());
                    expenseFactLine.setUser2_ID(invoiceLine$11.getUser2_ID());
                    expenseFactLine.setUser3_ID(invoiceLine$11.getUser3_ID());
                    expenseFactLine.setUser4_ID(invoiceLine$11.getUser4_ID());
                    expenseFactLine.setUserElement1_ID(invoiceFactAccount$4.getUserElement1_ID());
                    expenseFactLine.setUserElement2_ID(invoiceFactAccount$4.getUserElement2_ID());
                    expenseFactLine.setC_Tax_ID(invoiceLine$11.getC_Tax_ID());
                    expenseFactLine.setLine_ID(allocationLine$15.get_ID());
                    expenseFactLine.setAmtAcctDr(expenseAmountBase);
                    expenseFactLine.setAmtSourceDr(expenseAmountSource);
                    FactLine taxFactLine = accountingFact$16.createLine(null, taxAccount, invoice$22.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                    taxFactLine.setDocumentInfo(accountingFact$16.getDocument(), null);
                    taxFactLine.setC_BPartner_ID(invoiceFactAccount$4.getC_BPartner_ID());
                    taxFactLine.setM_Product_ID(invoiceFactAccount$4.getM_Product_ID());
                    taxFactLine.setAD_OrgTrx_ID(invoiceFactAccount$4.getAD_OrgTrx_ID());
                    taxFactLine.setC_Activity_ID(invoiceFactAccount$4.getC_Activity_ID());
                    taxFactLine.setC_Campaign_ID(invoiceFactAccount$4.getC_Campaign_ID());
                    taxFactLine.setC_Project_ID(invoiceFactAccount$4.getC_Project_ID());
                    taxFactLine.setC_ProjectPhase_ID(invoiceFactAccount$4.getC_ProjectPhase_ID());
                    taxFactLine.setC_ProjectTask_ID(invoiceFactAccount$4.getC_ProjectTask_ID());
                    taxFactLine.setC_SalesRegion_ID(invoiceFactAccount$4.getC_SalesRegion_ID());
                    taxFactLine.setUser1_ID(invoiceFactAccount$4.getUser1_ID());
                    taxFactLine.setUser2_ID(invoiceFactAccount$4.getUser2_ID());
                    taxFactLine.setUser3_ID(invoiceFactAccount$4.getUser3_ID());
                    taxFactLine.setUser4_ID(invoiceFactAccount$4.getUser4_ID());
                    taxFactLine.setUserElement1_ID(invoiceFactAccount$4.getUserElement1_ID());
                    taxFactLine.setUserElement2_ID(invoiceFactAccount$4.getUserElement2_ID());
                    taxFactLine.setC_Tax_ID(invoiceFactAccount$4.getC_Tax_ID());
                    taxFactLine.setLine_ID(allocationLine$15.get_ID());
                    taxFactLine.setAmtAcctCr(expenseAmountBase);
                    taxFactLine.setAmtSourceCr(expenseAmountSource);
                    bigDecimal2 = expenseAmountSource;
                }
                object = invoiceLineNetTaxAmount$lzy1$1.initialize((Object)bigDecimal2);
            }
            bigDecimal = (BigDecimal)object;
        }
        return bigDecimal;
    }

    private final BigDecimal invoiceLineNetTaxAmount$1(LazyRef invoiceLineNetTaxAmount$lzy1$2, MInvoice invoice$23, MAllocationHdr allocation$19, MInvoiceLine invoiceLine$12, MAcctSchema accountSchema$24, BigDecimal allocationLineAmount$2, BigDecimal invoiceTotal$2, MTax tax$8, BigDecimal invoiceLineTaxAmount$2, X_C_Tax_Acct accountTax$4, Fact accountingFact$17, MAccount accountExpense$3, X_Fact_Acct invoiceFactAccount$5, MAllocationLine allocationLine$16) {
        return (BigDecimal)(invoiceLineNetTaxAmount$lzy1$2.initialized() ? invoiceLineNetTaxAmount$lzy1$2.value() : this.invoiceLineNetTaxAmount$lzyINIT1$1(invoiceLineNetTaxAmount$lzy1$2, invoice$23, allocation$19, invoiceLine$12, accountSchema$24, allocationLineAmount$2, invoiceTotal$2, tax$8, invoiceLineTaxAmount$2, accountTax$4, accountingFact$17, accountExpense$3, invoiceFactAccount$5, allocationLine$16));
    }

    private final void createAccountLine$2(MAllocationHdr allocation$17, MAcctSchema accountSchema, Fact accountingFact, MAllocationLine allocationLine, MInvoice invoice, MInvoiceLine invoiceLine, MTax tax) {
        if (!Option$.MODULE$.apply((Object)tax.getTaxIndicator()).exists((Function1 & Serializable)TaxIndicator -> TaxIndicator.contains(MODULE$.EXPENSE()))) {
            return;
        }
        this.getAccountTax(accountSchema, tax.getC_Tax_ID()).foreach((Function1)(JProcedure1 & Serializable)accountTax -> {
            List<X_Fact_Acct> invoiceFactsAccountList = MODULE$.getAccountFact((PO)invoice, accountSchema.get_ID(), Fact.POST_Actual);
            if (invoiceFactsAccountList.nonEmpty()) {
                Option maybeAccountExpense = invoiceFactsAccountList.find((Function1 & Serializable)invoiceFactAccount -> invoiceFactAccount.getRecord_ID() == invoice.get_ID() && invoiceFactAccount.getLine_ID() == invoiceLine.getC_InvoiceLine_ID());
                if (maybeAccountExpense.nonEmpty()) {
                    MAccount accountExpense = MAccount.get((X_Fact_Acct)((X_Fact_Acct)maybeAccountExpense.get()));
                    invoiceFactsAccountList.filter((Function1 & Serializable)invoiceFactAccount -> invoiceFactAccount.getRecord_ID() == invoice.get_ID() && invoiceFactAccount.getLine_ID() <= 0 && invoiceFactAccount.getC_Tax_ID() == tax.getC_Tax_ID()).foreach((Function1)(JProcedure1 & Serializable)invoiceFactAccount -> {
                        LazyRef lazyRef = new LazyRef();
                        BigDecimal invoiceTotal = invoice.getC_Currency_ID() == allocation$17.getC_Currency_ID() ? invoice.getGrandTotal() : MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoice.getGrandTotal(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                        BigDecimal allocationLineAmount = invoice.getC_Currency_ID() == allocation$17.getC_Currency_ID() ? allocationLine.getAmount().negate() : MConversionRate.convert((Properties)allocationLine.getCtx(), (BigDecimal)allocationLine.getAmount().negate(), (int)allocationLine.getParent().getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)allocationLine.getParent().getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)allocationLine.getParent().getAD_Client_ID(), (int)allocationLine.getParent().getAD_Org_ID());
                        BigDecimal invoiceLineTaxAmount = invoice.getC_Currency_ID() == allocation$17.getC_Currency_ID() ? invoiceLine.getTaxAmt() : MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoiceLine.getTaxAmt(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                    });
                    return;
                }
                return;
            }
        });
    }

    private final void createAccountLine$3(MAllocationHdr allocation$27, MAcctSchema accountSchema, Fact accountingFact, MAllocationLine allocationLine, MInvoice invoice, MInvoiceLine invoiceLine, MTax tax) {
        this.getAccountTax(accountSchema, tax.getC_Tax_ID()).foreach((Function1)(JProcedure1 & Serializable)accountTax -> {
            List<X_Fact_Acct> invoiceFactsAccountList = MODULE$.getAccountFact((PO)invoice, accountSchema.get_ID(), Fact.POST_Actual);
            if (invoiceFactsAccountList.nonEmpty()) {
                invoiceFactsAccountList.filter((Function1 & Serializable)invoiceFactAccount -> invoiceFactAccount.getRecord_ID() == invoice.get_ID() && invoiceFactAccount.getLine_ID() <= 0 && invoiceFactAccount.getC_Tax_ID() == tax.getC_Tax_ID()).foreach((Function1)(JProcedure1 & Serializable)invoiceFactAccount -> {
                    BigDecimal invoiceTotal = invoice.getC_Currency_ID() == allocation$27.getC_Currency_ID() ? invoice.getGrandTotal() : MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoice.getGrandTotal(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                    BigDecimal allocationLineAmount = invoice.getC_Currency_ID() == allocation$27.getC_Currency_ID() ? allocationLine.getAmount().negate() : MConversionRate.convert((Properties)allocationLine.getCtx(), (BigDecimal)allocationLine.getAmount().negate(), (int)allocationLine.getParent().getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)allocationLine.getParent().getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)allocationLine.getParent().getAD_Client_ID(), (int)allocationLine.getParent().getAD_Org_ID());
                    BigDecimal invoiceLineTaxAmount = invoice.getC_Currency_ID() == allocation$27.getC_Currency_ID() ? invoiceLine.getTaxAmt() : MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoiceLine.getTaxAmt(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                    BigDecimal invoiceLineNetTaxAmount = invoice.getC_Currency_ID() == allocation$27.getC_Currency_ID() ? invoiceLine.getLineNetAmt() : MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)invoiceLine.getLineNetAmt(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                    int precision = invoice.getC_Currency().getStdPrecision();
                    BigDecimal percentInvoice = allocationLineAmount.divide(invoiceTotal, 12, RoundingMode.HALF_UP);
                    BigDecimal taxAmount = invoiceLine.getC_Tax_ID() == tax.get_ID() ? invoiceLineTaxAmount : invoiceLineNetTaxAmount.multiply(tax.getRate()).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                    BigDecimal expenseAmountSource = taxAmount.multiply(percentInvoice).setScale(accountSchema.getStdPrecision(), RoundingMode.HALF_UP).abs();
                    BigDecimal expenseAmountBase = MConversionRate.convert((Properties)invoice.getCtx(), (BigDecimal)expenseAmountSource.abs(), (int)invoice.getC_Currency_ID(), (int)accountSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID()).setScale(accountSchema.getStdPrecision(), RoundingMode.HALF_UP);
                    MAccount taxAccount = MAccount.getValidCombination((Properties)invoice.getCtx(), (int)accountTax.getT_Receivables_Acct(), (String)accountingFact.get_TrxName());
                    MAccount taxAccountRetention = MAccount.getValidCombination((Properties)invoice.getCtx(), (int)accountTax.getT_Credit_Acct(), (String)accountingFact.get_TrxName());
                    FactLine expenseFactLine = accountingFact.createLine(null, taxAccountRetention, invoice.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                    expenseFactLine.setDocumentInfo(accountingFact.getDocument(), null);
                    expenseFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                    expenseFactLine.setAD_OrgTrx_ID(invoiceLine.getAD_OrgTrx_ID());
                    expenseFactLine.setC_Activity_ID(invoiceLine.getC_Activity_ID());
                    expenseFactLine.setC_Campaign_ID(invoiceLine.getC_Campaign_ID());
                    expenseFactLine.setC_Project_ID(invoiceLine.getC_Project_ID());
                    expenseFactLine.setC_ProjectPhase_ID(invoiceLine.getC_ProjectPhase_ID());
                    expenseFactLine.setC_ProjectTask_ID(invoiceLine.getC_ProjectTask_ID());
                    expenseFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                    expenseFactLine.setUser1_ID(invoiceLine.getUser1_ID());
                    expenseFactLine.setUser2_ID(invoiceLine.getUser2_ID());
                    expenseFactLine.setUser3_ID(invoiceLine.getUser3_ID());
                    expenseFactLine.setUser4_ID(invoiceLine.getUser4_ID());
                    expenseFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                    expenseFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                    expenseFactLine.setC_Tax_ID(invoiceLine.getC_Tax_ID());
                    expenseFactLine.setLine_ID(allocationLine.get_ID());
                    expenseFactLine.setAmtAcctDr(expenseAmountBase);
                    expenseFactLine.setAmtSourceDr(expenseAmountSource);
                    FactLine taxFactLine = accountingFact.createLine(null, taxAccount, invoice.getC_Currency_ID(), BigDecimal.ZERO, BigDecimal.ZERO);
                    taxFactLine.setDocumentInfo(accountingFact.getDocument(), null);
                    taxFactLine.setC_BPartner_ID(invoiceFactAccount.getC_BPartner_ID());
                    taxFactLine.setM_Product_ID(invoiceFactAccount.getM_Product_ID());
                    taxFactLine.setAD_OrgTrx_ID(invoiceFactAccount.getAD_OrgTrx_ID());
                    taxFactLine.setC_Activity_ID(invoiceFactAccount.getC_Activity_ID());
                    taxFactLine.setC_Campaign_ID(invoiceFactAccount.getC_Campaign_ID());
                    taxFactLine.setC_Project_ID(invoiceFactAccount.getC_Project_ID());
                    taxFactLine.setC_ProjectPhase_ID(invoiceFactAccount.getC_ProjectPhase_ID());
                    taxFactLine.setC_ProjectTask_ID(invoiceFactAccount.getC_ProjectTask_ID());
                    taxFactLine.setC_SalesRegion_ID(invoiceFactAccount.getC_SalesRegion_ID());
                    taxFactLine.setUser1_ID(invoiceFactAccount.getUser1_ID());
                    taxFactLine.setUser2_ID(invoiceFactAccount.getUser2_ID());
                    taxFactLine.setUser3_ID(invoiceFactAccount.getUser3_ID());
                    taxFactLine.setUser4_ID(invoiceFactAccount.getUser4_ID());
                    taxFactLine.setUserElement1_ID(invoiceFactAccount.getUserElement1_ID());
                    taxFactLine.setUserElement2_ID(invoiceFactAccount.getUserElement2_ID());
                    taxFactLine.setC_Tax_ID(invoiceFactAccount.getC_Tax_ID());
                    taxFactLine.setLine_ID(allocationLine.get_ID());
                    taxFactLine.setAmtAcctCr(expenseAmountBase);
                    taxFactLine.setAmtSourceCr(expenseAmountSource);
                });
                return;
            }
        });
    }
}

